/*
 * Decompiled with CFR 0.152.
 */
package furny.states;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.screen.ScreenController;
import furny.states.SummaryUIController;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.view.appstate.GUIState;
import ga.view.appstate.menu.MenuListener;

public class SummaryUIState<T extends IIndividual<T>>
extends GUIState {
    private SummaryUIController<T> controller;
    private NiftyJmeDisplay niftyDisplay;
    private Nifty nifty;
    private AudioRenderer audioRenderer;
    private final IInteractiveFitnessEvaluator<T> evaluator;
    private final MenuListener menuListener;

    public SummaryUIState(IInteractiveFitnessEvaluator<T> evaluator, MenuListener menuListener) {
        this.evaluator = evaluator;
        this.menuListener = menuListener;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.audioRenderer = app.getAudioRenderer();
        this.controller = new SummaryUIController<T>(this.evaluator);
        this.controller.setMenuListener(this.menuListener);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.viewPort);
            this.nifty = this.niftyDisplay.getNifty();
            this.nifty.fromXml("furny/ui/summaryUI.xml", "start", new ScreenController[]{this.controller});
            this.viewPort.addProcessor((SceneProcessor)this.niftyDisplay);
        } else {
            try {
                if (this.nifty != null) {
                    this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                    this.nifty.exit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        try {
            if (this.nifty != null) {
                this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                this.nifty.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanup();
    }
}

