/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin;

import furny.entities.Furniture;
import furny.entities.Tag;
import furny.furndb.FurnDBManager;
import furny.furndb.FurnitureUpdateListener;
import furny.furndb.SearchType;
import furny.swing.admin.FurnitureLabel;
import furny.swing.admin.IFurnitureBrowser;
import furny.swing.admin.tags.EditFurnitureTagsPanel;
import furny.swing.admin.viewer.IFurnitureViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXBusyLabel;

public class BrowserPanel
extends JPanel
implements FurnitureUpdateListener,
IFurnitureBrowser {
    private final List<Long> furnIds = new ArrayList<Long>();
    private final Map<Long, Furniture> map = new HashMap<Long, Furniture>();
    private final JTable table;
    private final FurnitureTableModel tableModel;
    private final JTextField findField;
    private final JComboBox searchTypeComboBox;
    private final IFurnitureViewer viewer;

    public BrowserPanel(IFurnitureViewer viewer) {
        this.viewer = viewer;
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.weightx = 0.01;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        JLabel label = new JLabel("Find by");
        this.add((Component)label, constraints);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        ++constraints.gridx;
        this.searchTypeComboBox = new JComboBox<SearchType>(SearchType.values());
        this.add((Component)this.searchTypeComboBox, constraints);
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 5, 5, 0);
        ++constraints.gridx;
        this.findField = new JTextField();
        this.findField.addActionListener(new ActionFind());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.findField.requestFocusInWindow();
            }
        });
        this.add((Component)this.findField, constraints);
        constraints.weightx = 0.0;
        constraints.insets = new Insets(5, 0, 5, 5);
        ++constraints.gridx;
        JButton button = new JButton(new ActionResetSearch());
        button.setMargin(new Insets(2, 5, 2, 5));
        this.add((Component)button, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 11;
        constraints.gridwidth = 5;
        this.tableModel = new FurnitureTableModel();
        this.table = new JTable(this.tableModel){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
            }
        };
        this.table.setAutoscrolls(false);
        this.table.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point hit = e.getPoint();
                int hitColumn = BrowserPanel.this.table.columnAtPoint(hit);
                int hitRow = BrowserPanel.this.table.rowAtPoint(hit);
                BrowserPanel.this.table.editCellAt(hitRow, hitColumn);
            }
        });
        this.table.setDefaultRenderer(Furniture.class, new FurnitureCellRenderer(null));
        FurnitureCellRenderer editor = new FurnitureCellRenderer(this);
        editor.label.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                BrowserPanel.this.table.removeEditor();
                BrowserPanel.this.table.dispatchEvent(e);
            }
        });
        this.table.setDefaultEditor(Furniture.class, editor);
        this.table.setRowHeight(400);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setGridColor(this.getBackground());
        this.table.setTableHeader(null);
        this.table.setDragEnabled(false);
        this.add((Component)new JScrollPane(this.table), constraints);
        ++constraints.gridy;
        constraints.gridwidth = 5;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, constraints);
        buttonPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        buttonPanel.add((Component)new JButton(new ActionRefresh()), constraints);
        ++constraints.gridx;
        buttonPanel.add((Component)new JButton(new ActionDeleteAll()), constraints);
        ++constraints.gridx;
        buttonPanel.add((Component)new JButton(new ActionAddTagsToAll()), constraints);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BrowserPanel.this.tableModel.fireTableStructureChanged();
            }
        });
        FurnDBManager.getInstance().addFurnitureUpdateListener(this);
        this.updateIds();
    }

    private void updateIds() {
        FurnDBManager.getInstance().updateFurnitureIds();
    }

    @Override
    public void searchByTag(String text) {
        this.searchTypeComboBox.setSelectedItem((Object)SearchType.TAGS);
        this.findField.setText(text);
        this.find(true);
    }

    private void find(SearchType type, String text, boolean equals) {
        if (text.isEmpty()) {
            this.updateIds();
        } else {
            FurnDBManager.getInstance().updateIdsByTagName(type, text, equals);
        }
    }

    private void find(boolean equals) {
        SearchType type = (SearchType)((Object)this.searchTypeComboBox.getSelectedItem());
        this.find(type, this.findField.getText(), equals);
    }

    private void resetSearch() {
        this.searchTypeComboBox.setSelectedItem((Object)SearchType.ALL);
        this.findField.setText("");
        this.find(false);
    }

    @Override
    public void furnitureIdsUpdated(final List<Long> ids) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.furnIds.clear();
                BrowserPanel.this.furnIds.addAll(ids);
                BrowserPanel.this.tableModel.fireTableDataChanged();
                BrowserPanel.this.table.removeEditor();
            }
        });
    }

    @Override
    public void furnitureUpdated(final Long id, final Furniture furniture) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.map.put(id, furniture);
                BrowserPanel.this.table.repaint();
                BrowserPanel.this.table.removeEditor();
            }
        });
    }

    @Override
    public void furnitureDeleted(final Long id) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.furnIds.remove(id);
                BrowserPanel.this.map.remove(id);
                BrowserPanel.this.tableModel.fireTableDataChanged();
                BrowserPanel.this.table.removeEditor();
            }
        });
    }

    private class ActionAddTagsToAll
    extends AbstractAction {
        public ActionAddTagsToAll() {
            super("Add tags to all");
            this.putValue("ShortDescription", "Add multiple tags to all displayed furnitures");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditFurnitureTagsPanel tp = new EditFurnitureTagsPanel();
            int n = JOptionPane.showConfirmDialog(null, tp, "Edit tags for furniture", 2, -1);
            if (n == 0) {
                List<Tag> tags = tp.getSelectedTags();
                for (Long id : BrowserPanel.this.furnIds) {
                    Furniture furniture = FurnDBManager.getInstance().getFurniture(id);
                    FurnDBManager.getInstance().addFurnitureTags(furniture, new TreeSet<Tag>(tags));
                }
            }
        }
    }

    private class ActionDeleteAll
    extends AbstractAction {
        public ActionDeleteAll() {
            super("Delete all furnitures");
            this.putValue("ShortDescription", "Delete all displayed furnitures");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = JOptionPane.showConfirmDialog(null, "Are you sure to delete furnitures " + BrowserPanel.this.furnIds + "?", "Delete Furniture", 0, 3);
            if (n == 0 && (n = JOptionPane.showConfirmDialog(null, "Are you really sure to delete all displayed furnitures?\nDeletion can not be undone!", "Delete Furniture", 0, 2)) == 0) {
                for (Long id : BrowserPanel.this.furnIds) {
                    FurnDBManager.getInstance().deleteFurniture(id);
                }
                BrowserPanel.this.resetSearch();
                BrowserPanel.this.viewer.setFurniture(null);
            }
        }
    }

    private class ActionRefresh
    extends AbstractAction {
        public ActionRefresh() {
            super("Refresh");
            this.putValue("ShortDescription", "Refresh furnitures from database");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserPanel.this.furnIds.clear();
            BrowserPanel.this.map.clear();
            BrowserPanel.this.resetSearch();
        }
    }

    private class ActionFind
    extends AbstractAction {
        public ActionFind() {
            super("Find");
            this.putValue("ShortDescription", "Find furnitures");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserPanel.this.find(false);
        }
    }

    private class ActionResetSearch
    extends AbstractAction {
        public ActionResetSearch() {
            super("X");
            this.putValue("ShortDescription", "Reset the search");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserPanel.this.resetSearch();
        }
    }

    private class FurnitureTableModel
    extends DefaultTableModel {
        private FurnitureTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Furniture.class;
        }

        @Override
        public int getColumnCount() {
            if (BrowserPanel.this.table != null) {
                return BrowserPanel.this.table.getWidth() / 200;
            }
            return 3;
        }

        @Override
        public int getRowCount() {
            return (int)Math.ceil((double)BrowserPanel.this.furnIds.size() / (double)this.getColumnCount());
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }

        @Override
        public Object getValueAt(int row, int column) {
            int index = row * this.getColumnCount() + column;
            if (index < BrowserPanel.this.furnIds.size()) {
                Long id = (Long)BrowserPanel.this.furnIds.get(index);
                Furniture furniture = (Furniture)BrowserPanel.this.map.get(id);
                if (furniture != null) {
                    return furniture;
                }
                FurnDBManager.getInstance().updateFurniture(id);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    private class FurnitureCellRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private final FurnitureLabel label;
        private final JLabel emptyLabel;
        private final JXBusyLabel busyLabel;

        public FurnitureCellRenderer(IFurnitureBrowser searchBar) {
            this.label = new FurnitureLabel(searchBar, BrowserPanel.this.viewer);
            this.busyLabel = new JXBusyLabel(new Dimension(50, 50));
            this.busyLabel.setHorizontalAlignment(0);
            this.busyLabel.setBusy(true);
            this.emptyLabel = new JLabel();
            this.emptyLabel.setBackground(BrowserPanel.this.getBackground());
            this.emptyLabel.setOpaque(true);
            this.emptyLabel.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Furniture) {
                Furniture furniture = (Furniture)value;
                this.label.setFurniture(furniture);
                return this.label;
            }
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    return this.busyLabel;
                }
                return this.emptyLabel;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellRendererComponent(table, BrowserPanel.this.tableModel.getValueAt(row, column), isSelected, true, row, column);
        }
    }
}

