/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.system.AppSettings;
import furny.entities.Furniture;
import furny.furndb.importer.DBModelSource;
import furny.jme.FurnyApplication;
import furny.swing.admin.BrowserPanel;
import furny.swing.admin.importer.ImporterPanel;
import furny.swing.admin.tags.TagPanel;
import furny.swing.admin.viewer.IFurnitureViewer;
import furny.swing.admin.viewer.IModelViewer;
import furny.swing.admin.viewer.ModelViewerState;
import furny.swing.admin.viewer.ViewerCanvasPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FurnDBAdminFrame
extends JFrame
implements IFurnitureViewer {
    private static final Logger LOGGER = Logger.getLogger(FurnDBAdminFrame.class.getName());
    private BrowserPanel browserPanel;
    private final JTabbedPane tabbedPane;
    private final transient IModelViewer viewer;
    private final FurnyApplication app;
    private final ViewerCanvasPanel viewerPanel;
    private final ImporterPanel importerPanel;

    public FurnDBAdminFrame() {
        super("FurnDBAdmin");
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.tabbedPane = new JTabbedPane();
        this.app = new FurnyApplication();
        AppSettings settings = new AppSettings(true);
        settings.setRenderer("LWJGL-OpenGL2");
        settings.setTitle(this.getTitle());
        this.app.setSettings(settings);
        final ModelViewerState state = new ModelViewerState(new DBModelSource(), this.app);
        this.viewer = state;
        this.app.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FurnDBAdminFrame.this.app.getStateManager().attach((AppState)state);
                return null;
            }
        });
        this.app.setPauseOnLostFocus(false);
        this.app.setShowSettings(false);
        LOGGER.fine(this.app.getAppSettings().toString());
        this.viewerPanel = new ViewerCanvasPanel((Application)this.app, this.viewer);
        this.importerPanel = new ImporterPanel(this.app);
        this.tabbedPane.addTab("Furnitures", this.createFurniturePanel());
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("Tags", this.createTagsPanel());
        this.tabbedPane.addTab("Import", this.importerPanel);
        this.add((Component)this.tabbedPane, constraints);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        LOGGER.info("Starting up admin application");
    }

    private JPanel createTagsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)new TagPanel(), constraints);
        return panel;
    }

    @Override
    public void setFurniture(Furniture furn) {
        this.viewer.setFurniture(furn);
        if (furn != null) {
            this.viewerPanel.updateViewerSize();
            this.tabbedPane.setSelectedComponent(this.viewerPanel);
        }
    }

    private JPanel createFurniturePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.browserPanel = new BrowserPanel(this);
        panel.add((Component)this.browserPanel, constraints);
        return panel;
    }
}

