/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin;

import com.jme3.math.Vector3f;
import furny.entities.Furniture;
import furny.entities.Tag;
import furny.furndb.FurnDBManager;
import furny.swing.admin.FurnitureLabelPopupMenu;
import furny.swing.admin.IFurnitureBrowser;
import furny.swing.admin.tags.EditFurnitureTagsPanel;
import furny.swing.admin.viewer.IFurnitureViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class FurnitureLabel
extends JLabel
implements HyperlinkListener {
    private static final Logger LOGGER = Logger.getLogger(FurnitureLabel.class.getName());
    private final ImageIcon icon;
    private final JLabel nameLabel;
    private final JLabel descriptionLabel;
    private final JLabel dateLabel;
    private final JLabel idLabel;
    private final JLabel itemNumberLabel;
    private final JLabel priceLabel;
    private final JLabel dimensionsLabel;
    private final JEditorPane tagPane;
    private final Font normalFont;
    private final Font disabledFont;
    private final Color normalColor = Color.BLACK;
    private final Color disabledColor = Color.LIGHT_GRAY;
    private final NumberFormat floatFormat = new DecimalFormat("0.00");
    private final StringBuilder toolTipBuilder = new StringBuilder();
    private final StringBuilder tagsBuilder = new StringBuilder();
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final IFurnitureBrowser browser;
    private final IFurnitureViewer viewer;
    private final boolean isEditor;
    private Furniture furniture;

    public FurnitureLabel() {
        this(null, null);
    }

    public FurnitureLabel(IFurnitureBrowser browser, IFurnitureViewer viewer) {
        this.browser = browser;
        this.viewer = viewer;
        this.isEditor = browser != null;
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setFocusable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 2, 10);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        this.icon = new ImageIcon();
        this.add((Component)new JLabel(this.icon), constraints);
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 10, 5, 10);
        ++constraints.gridy;
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        this.add((Component)this.nameLabel, constraints);
        ++constraints.gridy;
        this.descriptionLabel = new JLabel();
        this.add((Component)this.descriptionLabel, constraints);
        ++constraints.gridy;
        this.itemNumberLabel = new JLabel();
        this.add((Component)this.itemNumberLabel, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        this.add((Component)new JLabel("Price"), constraints);
        ++constraints.gridx;
        constraints.fill = 0;
        constraints.anchor = 13;
        this.priceLabel = new JLabel();
        this.add((Component)this.priceLabel, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.anchor = 17;
        this.add((Component)new JLabel("Dimensions (w,h,l)"), constraints);
        ++constraints.gridx;
        constraints.fill = 0;
        constraints.anchor = 13;
        this.dimensionsLabel = new JLabel();
        this.add((Component)this.dimensionsLabel, constraints);
        this.normalFont = this.descriptionLabel.getFont();
        this.disabledFont = this.normalFont.deriveFont(2);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 0, 10);
        this.idLabel = new JLabel();
        this.idLabel.setFont(this.normalFont.deriveFont(10.0f));
        this.add((Component)this.idLabel, constraints);
        ++constraints.gridy;
        this.dateLabel = new JLabel();
        this.dateLabel.setFont(this.normalFont.deriveFont(10.0f));
        this.add((Component)this.dateLabel, constraints);
        JPanel tagPanel = new JPanel();
        tagPanel.setOpaque(false);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)tagPanel, constraints);
        tagPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        tagPanel.add(Box.createVerticalStrut(50), constraints);
        this.tagPane = new JEditorPane();
        this.tagPane.setContentType("text/html");
        this.tagPane.setEditable(false);
        this.tagPane.setEditorKit(new HTMLEditorKit());
        this.tagPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.tagPane.setFont(this.normalFont);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        tagPanel.add((Component)this.tagPane, constraints);
        ++constraints.gridx;
        constraints.fill = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.anchor = 15;
        if (this.isEditor) {
            JButton addTagButton = new JButton(new ActionAddTag());
            addTagButton.setMargin(new Insets(1, 1, 1, 1));
            tagPanel.add((Component)addTagButton, constraints);
            this.tagPane.addHyperlinkListener(this);
            this.nameLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FurnitureLabel.this.editName();
                    }
                }
            });
            this.descriptionLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FurnitureLabel.this.editDescription();
                    }
                }
            });
            this.itemNumberLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FurnitureLabel.this.editItemNumber();
                    }
                }
            });
            this.priceLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FurnitureLabel.this.editPrice();
                    }
                }
            });
            this.dimensionsLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FurnitureLabel.this.editDimension();
                    }
                }
            });
            this.addMouseListener(new PopUpMouseListener());
        } else {
            tagPanel.add(Box.createHorizontalStrut(15), constraints);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.browser.searchByTag(e.getDescription());
        }
    }

    public void setFurniture(Furniture f) {
        this.furniture = f;
        if (f == null) {
            this.nameLabel.setText("");
            this.descriptionLabel.setText("");
            this.itemNumberLabel.setText("");
            this.priceLabel.setText("");
            this.dimensionsLabel.setText("");
            this.idLabel.setText("");
            this.dateLabel.setText("");
            this.setToolTipText("");
        } else {
            if (f.getImage() != null) {
                this.icon.setImage(f.getImage());
            }
            this.nameLabel.setText(f.getMetaData().getName());
            String descr = f.getMetaData().getDescription();
            if (descr == null || descr.isEmpty()) {
                descr = "No Description";
                this.descriptionLabel.setFont(this.disabledFont);
                this.descriptionLabel.setForeground(this.disabledColor);
            } else {
                this.descriptionLabel.setFont(this.normalFont);
                this.descriptionLabel.setForeground(this.normalColor);
            }
            this.descriptionLabel.setText(descr);
            String itemNumber = f.getMetaData().getItemNumber();
            if (itemNumber == null || itemNumber.isEmpty()) {
                itemNumber = "No Item Number";
                this.itemNumberLabel.setFont(this.disabledFont);
                this.itemNumberLabel.setForeground(this.disabledColor);
            } else {
                this.itemNumberLabel.setFont(this.normalFont);
                this.itemNumberLabel.setForeground(this.normalColor);
            }
            this.itemNumberLabel.setText(itemNumber);
            this.priceLabel.setText(this.floatFormat.format(f.getMetaData().getPrice()));
            Vector3f d = f.getMetaData().getDimension();
            this.dimensionsLabel.setText("" + this.floatFormat.format(d.getX()) + ", " + this.floatFormat.format(d.getY()) + ", " + this.floatFormat.format(d.getZ()));
            this.idLabel.setText("<html><b>ID:</b> " + f.getId() + "</html>");
            this.dateLabel.setText("<html><b>Changed:</b> " + this.df.format(f.getDate()) + "</html>");
            this.toolTipBuilder.setLength(0);
            this.tagsBuilder.setLength(0);
            this.tagsBuilder.append("<html><body>");
            Iterator<Tag> it = new TreeSet<Tag>(f.getMetaData().getTags()).iterator();
            if (it.hasNext()) {
                this.tagPane.setFont(this.normalFont);
                this.tagPane.setForeground(this.normalColor);
                this.toolTipBuilder.append("<html><b>Tags</b><table>");
            } else {
                this.tagsBuilder.append("No Tags");
                this.tagPane.setFont(this.disabledFont);
                this.tagPane.setForeground(this.disabledColor);
                this.toolTipBuilder.append("<html><b>No Tags</b><table>");
            }
            while (it.hasNext()) {
                Tag t = it.next();
                this.toolTipBuilder.append("<tr><td>");
                this.toolTipBuilder.append((Object)t.getType());
                this.toolTipBuilder.append("</td><td>");
                this.toolTipBuilder.append(t.getName());
                this.toolTipBuilder.append("</td></tr>");
                this.tagsBuilder.append("<a href=\"");
                this.tagsBuilder.append(t.getName());
                this.tagsBuilder.append("\"/>");
                this.tagsBuilder.append(t.getName());
                this.tagsBuilder.append("</a>");
                if (!it.hasNext()) continue;
                this.tagsBuilder.append(", ");
            }
            this.toolTipBuilder.append("</table></html>");
            this.setToolTipText(this.toolTipBuilder.toString());
            this.tagsBuilder.append("</body></html>");
            this.tagPane.setText(this.tagsBuilder.toString());
        }
    }

    private void editName() {
        String s;
        if (this.furniture != null && (s = this.editText(this.nameLabel)) != null && !s.isEmpty()) {
            this.furniture.getMetaData().setName(s);
            FurnDBManager.getInstance().saveFurniture(this.furniture, true);
        }
    }

    private void editDescription() {
        String s;
        if (this.furniture != null && (s = this.editText(this.descriptionLabel)) != null) {
            this.furniture.getMetaData().setDescription(s);
            FurnDBManager.getInstance().saveFurniture(this.furniture, true);
        }
    }

    private void editItemNumber() {
        String s;
        if (this.furniture != null && (s = this.editText(this.itemNumberLabel)) != null) {
            this.furniture.getMetaData().setItemNumber(s);
            FurnDBManager.getInstance().saveFurniture(this.furniture, true);
        }
    }

    private void editPrice() {
        Double d;
        if (this.furniture != null && (d = this.editPrice(this.furniture)) != null) {
            this.furniture.getMetaData().setPrice(d);
            FurnDBManager.getInstance().saveFurniture(this.furniture, true);
        }
    }

    private void editDimension() {
        Vector3f d;
        if (this.furniture != null && (d = this.editDimension(this.furniture)) != null) {
            this.furniture.getMetaData().setDimension(d);
            FurnDBManager.getInstance().saveFurniture(this.furniture, true);
        }
    }

    private String editText(JLabel label) {
        String textAfter;
        String textBefore = label.getText();
        if (!textBefore.equals(textAfter = (String)JOptionPane.showInputDialog(this, "Type new text", "Edit text", 3, null, null, textBefore))) {
            return textAfter;
        }
        return null;
    }

    private Vector3f editDimension(Furniture f) {
        Vector3f valueBefore = f.getMetaData().getDimension();
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.fill = 1;
            constraints.gridwidth = 6;
            panel.add((Component)new JLabel("Edit the dimensions"), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.gridwidth = 1;
            panel.add((Component)new JLabel("Width:"), constraints);
            ++constraints.gridx;
            JSpinner widthSpinner = new JSpinner(new SpinnerNumberModel(Float.valueOf(valueBefore.getX()), Float.valueOf(0.0f), Float.valueOf(20.0f), Float.valueOf(1.0f)));
            widthSpinner.setEditor(new JSpinner.NumberEditor(widthSpinner, "0.00"));
            panel.add((Component)widthSpinner, constraints);
            ++constraints.gridx;
            panel.add((Component)new JLabel("Height:"), constraints);
            ++constraints.gridx;
            JSpinner heightSpinner = new JSpinner(new SpinnerNumberModel(Float.valueOf(valueBefore.getY()), Float.valueOf(0.0f), Float.valueOf(20.0f), Float.valueOf(1.0f)));
            heightSpinner.setEditor(new JSpinner.NumberEditor(heightSpinner, "0.00"));
            panel.add((Component)heightSpinner, constraints);
            ++constraints.gridx;
            panel.add((Component)new JLabel("Length:"), constraints);
            ++constraints.gridx;
            JSpinner lengthSpinner = new JSpinner(new SpinnerNumberModel(Float.valueOf(valueBefore.getZ()), Float.valueOf(0.0f), Float.valueOf(20.0f), Float.valueOf(1.0f)));
            lengthSpinner.setEditor(new JSpinner.NumberEditor(lengthSpinner, "0.00"));
            panel.add((Component)lengthSpinner, constraints);
            int n = JOptionPane.showConfirmDialog(this, panel, "Edit dimensions", 2, 3);
            Vector3f newDim = new Vector3f(((Float)widthSpinner.getValue()).floatValue(), ((Float)heightSpinner.getValue()).floatValue(), ((Float)lengthSpinner.getValue()).floatValue());
            if (n == 0 && !newDim.equals((Object)valueBefore)) {
                return newDim;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "An error occured", e);
        }
        return null;
    }

    private Double editPrice(Furniture f) {
        Double valueBefore = f.getMetaData().getPrice();
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.fill = 1;
            panel.add((Component)new JLabel("Edit the price"), constraints);
            ++constraints.gridy;
            JSpinner spinner = new JSpinner(new SpinnerNumberModel(valueBefore, Double.valueOf(0.0), Double.valueOf(10000.0), (Number)0.01));
            spinner.setEditor(new JSpinner.NumberEditor(spinner, "0.00"));
            panel.add((Component)spinner, constraints);
            int n = JOptionPane.showConfirmDialog(this, panel, "Edit price", 2, 3);
            Double valueNew = (Double)spinner.getValue();
            if (n == 0 && !valueNew.equals(valueBefore)) {
                return valueNew;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "An error occured", e);
        }
        return null;
    }

    private class PopUpMouseListener
    extends MouseAdapter {
        private PopUpMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 3 && e.getClickCount() == 1) {
                new FurnitureLabelPopupMenu(FurnitureLabel.this.viewer, FurnitureLabel.this.furniture).show(FurnitureLabel.this, e.getX(), e.getY());
            } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                FurnitureLabel.this.viewer.setFurniture(FurnitureLabel.this.furniture);
            }
            e.consume();
        }
    }

    private class ActionAddTag
    extends AbstractAction {
        public ActionAddTag() {
            super("..");
            this.putValue("ShortDescription", "Edit tags for furniture");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditFurnitureTagsPanel tp = new EditFurnitureTagsPanel();
            ArrayList<Tag> existingTags = new ArrayList<Tag>(FurnitureLabel.this.furniture.getMetaData().getTags());
            tp.addTags(existingTags);
            int n = JOptionPane.showConfirmDialog(null, tp, "Edit tags for furniture", 2, -1);
            if (n == 0) {
                List<Tag> tags = tp.getSelectedTags();
                FurnDBManager.getInstance().setFurnitureTags(FurnitureLabel.this.furniture, new TreeSet<Tag>(tags));
            }
        }
    }
}

