/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin;

import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.swing.admin.viewer.IFurnitureViewer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class FurnitureLabelPopupMenu
extends JPopupMenu {
    private final Furniture furniture;
    private final IFurnitureViewer viewer;

    public FurnitureLabelPopupMenu(IFurnitureViewer viewer, Furniture furniture) {
        this.viewer = viewer;
        this.furniture = furniture;
        this.add(new ActionShow());
        this.addSeparator();
        this.add(new ActionDelete());
    }

    private class ActionDelete
    extends AbstractAction {
        public ActionDelete() {
            super("Delete");
            this.putValue("ShortDescription", "Delete this furniture");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n = JOptionPane.showConfirmDialog(null, "Are you sure to delete furniture \"" + FurnitureLabelPopupMenu.this.furniture.getName() + "\" (" + FurnitureLabelPopupMenu.this.furniture.getId() + ")?", "Delete Furniture", 0, -1);
            if (n == 0) {
                FurnDBManager.getInstance().deleteFurniture(FurnitureLabelPopupMenu.this.furniture.getId());
            }
        }
    }

    private class ActionShow
    extends AbstractAction {
        public ActionShow() {
            super("Show in model viewer");
            this.putValue("ShortDescription", "Show this furniture in the 3D model viewer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FurnitureLabelPopupMenu.this.viewer.setFurniture(FurnitureLabelPopupMenu.this.furniture);
        }
    }
}

