/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.genotype;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import furny.ga.FurnLayoutIndividual;
import furny.ga.FurnLayoutPhenotypeGenerator;
import furny.ga.rules.FurnitureIntersectionRule;
import furny.ga.rules.RoomContainsRule;
import furny.ga.util.FurnLayoutIOUtil;
import furny.jme.FurnyApplication;
import ga.core.validation.GAContext;
import ga.core.validation.RuleValidator;
import ga.view.streaming.ShowRoomState;
import ga.view.streaming.showroom.BoxShowRoom;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenotypePanel
extends JPanel
implements ChangeListener {
    private Canvas canvas;
    private SimpleApplication app;
    private final AppSettings settings;
    private ShowRoomState<FurnLayoutIndividual> srState;
    private final FurnLayoutPhenotypeGenerator phenotypeGenerator = new FurnLayoutPhenotypeGenerator();
    private RuleValidator<FurnLayoutIndividual> validator;
    private ShowRoom showRoom;
    private boolean initialized;
    private boolean showRoomNeedsUpdate;
    private JTextArea genotypeField;
    private JSpinner widthSpinner;
    private JSpinner lengthSpinner;
    private JSpinner minCountSpinner;
    private JSpinner maxCountSpinner;
    private int roomWidth = 500;
    private int roomLength = 500;
    private int minCount = 2;
    private int maxCount = 5;
    private final GAContext context = new GAContext();
    private final FurnLayoutIndividual ind = new FurnLayoutIndividual(this.context);
    private Timer timer;
    private final File lastDir = new File(".");

    public GenotypePanel() {
        this.settings = new AppSettings(true);
        this.settings.setRenderer("LWJGL-OpenGL2");
        this.settings.setTitle("");
        Locale.setDefault(Locale.ENGLISH);
        this.checkInit();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int newWidth = (Integer)this.widthSpinner.getValue();
        int newLength = (Integer)this.lengthSpinner.getValue();
        if (newWidth != this.roomWidth || newLength != this.roomLength) {
            this.roomWidth = newWidth;
            this.roomLength = newLength;
            this.showRoomNeedsUpdate = true;
            this.timer.restart();
        }
    }

    private void checkInit() {
        if (!this.initialized) {
            this.app = new FurnyApplication();
            this.app.setSettings(this.settings);
            this.app.enqueue((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GenotypePanel.this.validator = new RuleValidator();
                    GenotypePanel.this.validator.addRule(new FurnitureIntersectionRule());
                    GenotypePanel.this.validator.addRule(new RoomContainsRule());
                    ShowRoomSettings srSettings = new ShowRoomSettings();
                    srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
                    srSettings.put("width", Float.valueOf((float)GenotypePanel.this.roomWidth / 100.0f));
                    srSettings.put("length", Float.valueOf((float)GenotypePanel.this.roomLength / 100.0f));
                    srSettings.put("height", Float.valueOf(2.6f));
                    GenotypePanel.this.showRoom = new BoxShowRoom(GenotypePanel.this.app.getAssetManager(), GenotypePanel.this.settings, srSettings);
                    GenotypePanel.this.context.put("ValidationSpace", (Object)GenotypePanel.this.showRoom);
                    GenotypePanel.this.context.put("GenomeMinLength", (Object)GenotypePanel.this.minCount);
                    GenotypePanel.this.context.put("GenomeMaxLength", (Object)GenotypePanel.this.maxCount);
                    GenotypePanel.this.phenotypeGenerator.setAssetManager(GenotypePanel.this.app.getAssetManager());
                    CameraSettings camSettings = CameraSettings.getOrthographicSettings(GenotypePanel.this.showRoom, GenotypePanel.this.settings);
                    GenotypePanel.this.srState = new ShowRoomState(null, camSettings);
                    GenotypePanel.this.srState.setSettings(GenotypePanel.this.settings);
                    GenotypePanel.this.app.getStateManager().attach((AppState)GenotypePanel.this.srState);
                    return null;
                }
            });
            this.app.setPauseOnLostFocus(false);
            this.app.setShowSettings(false);
            this.app.createCanvas();
            JmeCanvasContext context = (JmeCanvasContext)this.app.getContext();
            this.canvas = context.getCanvas();
            this.app.startCanvas();
            this.app.enqueue((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            Thread.sleep(1000L);
                            return null;
                        }

                        @Override
                        protected void done() {
                            GenotypePanel.this.invalidate();
                            GenotypePanel.this.validate();
                            GenotypePanel.this.randomizeInd();
                        }
                    }.execute();
                    GenotypePanel.this.srState.setRootNode(GenotypePanel.this.showRoom);
                    return null;
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.gridwidth = 0;
            constraints.gridheight = 1;
            this.add((Component)this.createGenotypePanel(), constraints);
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            this.add((Component)new JLabel("Room Width (cm)"), constraints);
            ++constraints.gridx;
            SpinnerNumberModel model = new SpinnerNumberModel(this.roomWidth, 50, 5000, 5);
            this.widthSpinner = new JSpinner(model);
            model.addChangeListener(this);
            this.add((Component)this.widthSpinner, constraints);
            ++constraints.gridx;
            this.add((Component)new JLabel("Room Length (cm)"), constraints);
            ++constraints.gridx;
            model = new SpinnerNumberModel(this.roomLength, 50, 5000, 5);
            this.lengthSpinner = new JSpinner(model);
            model.addChangeListener(this);
            this.add((Component)this.lengthSpinner, constraints);
            ++constraints.gridx;
            this.add(Box.createHorizontalGlue(), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.gridwidth = 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.canvas.setPreferredSize(new Dimension(800, 400));
            this.canvas.setMaximumSize(this.canvas.getPreferredSize());
            this.canvas.setSize(this.canvas.getPreferredSize());
            this.add((Component)this.canvas, constraints);
            this.updateGenotypeField();
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    GenotypePanel.this.checkInit();
                }
            });
            this.invalidate();
            this.validate();
            this.repaint();
            this.timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenotypePanel.this.updateShowroom();
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
            this.initialized = true;
        }
    }

    private JPanel createCountPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        panel.add((Component)new JLabel("Min Count"), constraints);
        ++constraints.gridx;
        SpinnerNumberModel model = new SpinnerNumberModel(this.minCount, 1, 12, 1);
        this.minCountSpinner = new JSpinner(model);
        model.addChangeListener(this);
        panel.add((Component)this.minCountSpinner, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        panel.add((Component)new JLabel("Max Count"), constraints);
        ++constraints.gridx;
        model = new SpinnerNumberModel(this.maxCount, 1, 12, 1);
        this.maxCountSpinner = new JSpinner(model);
        model.addChangeListener(this);
        panel.add((Component)this.maxCountSpinner, constraints);
        return panel;
    }

    private JPanel createGenotypePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.fill = 1;
        constraints.anchor = 12;
        this.genotypeField = new JTextArea(5, 80);
        this.genotypeField.setLineWrap(true);
        this.genotypeField.setWrapStyleWord(true);
        this.genotypeField.setMinimumSize(new Dimension(800, 100));
        panel.add((Component)this.genotypeField, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 12;
        ++constraints.gridx;
        panel.add((Component)this.createCountPanel(), constraints);
        ++constraints.gridy;
        panel.add((Component)new JButton(new ActionCreateRandomGenotype()), constraints);
        ++constraints.gridx;
        panel.add((Component)new JButton(new ActionLoadGenotype()), constraints);
        constraints.gridx = 1;
        ++constraints.gridy;
        panel.add((Component)new JButton(new ActionUpdateView()), constraints);
        ++constraints.gridx;
        panel.add((Component)new JButton(new ActionSaveGenotype()), constraints);
        return panel;
    }

    private void updateGenotypeField() {
        this.genotypeField.setText(this.ind.getGenotypeString());
    }

    private void updateShowroom() {
        if (this.showRoomNeedsUpdate && this.initialized) {
            this.showRoomNeedsUpdate = false;
            this.app.enqueue((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ShowRoomSettings srSettings = new ShowRoomSettings();
                    srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
                    srSettings.put("width", Float.valueOf((float)GenotypePanel.this.roomWidth / 100.0f));
                    srSettings.put("length", Float.valueOf((float)GenotypePanel.this.roomLength / 100.0f));
                    srSettings.put("height", Float.valueOf(2.6f));
                    GenotypePanel.this.showRoom = new BoxShowRoom(GenotypePanel.this.app.getAssetManager(), GenotypePanel.this.settings, srSettings);
                    GenotypePanel.this.context.put("ValidationSpace", (Object)GenotypePanel.this.showRoom);
                    CameraSettings camSettings = CameraSettings.getOrthographicSettings(GenotypePanel.this.showRoom, GenotypePanel.this.settings);
                    GenotypePanel.this.srState.setEnabled(false);
                    GenotypePanel.this.srState.setCamSettings(camSettings);
                    GenotypePanel.this.srState.setRootNode(GenotypePanel.this.showRoom);
                    GenotypePanel.this.showRoom.setPhenotype((Spatial)GenotypePanel.this.phenotypeGenerator.createPhenotype(GenotypePanel.this.ind));
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            Thread.sleep(1000L);
                            return null;
                        }

                        @Override
                        protected void done() {
                            if (!GenotypePanel.this.validator.isValid(GenotypePanel.this.ind, GenotypePanel.this.context)) {
                                GenotypePanel.this.randomizeInd();
                            }
                            GenotypePanel.this.invalidate();
                            GenotypePanel.this.validate();
                            GenotypePanel.this.revalidate();
                        }
                    }.execute();
                    return null;
                }
            });
        }
    }

    private void updateView() {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GenotypePanel.this.showRoom.setPhenotype((Spatial)GenotypePanel.this.phenotypeGenerator.createPhenotype(GenotypePanel.this.ind));
                GenotypePanel.this.srState.setRootNode(GenotypePanel.this.showRoom);
                return null;
            }
        });
    }

    private void randomizeInd() {
        if (this.validator != null) {
            int i = 100000;
            do {
                this.ind.initRandomly();
                if (i-- >= 0) continue;
                this.ind.getFurnitures().clear();
                break;
            } while (!this.validator.isValid(this.ind, this.context));
            this.updateGenotypeField();
            this.updateView();
        }
    }

    private class ActionUpdateView
    extends AbstractAction {
        public ActionUpdateView() {
            super("Update View");
            this.putValue("ShortDescription", "Create a random genotype");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FurnLayoutIOUtil.parse(GenotypePanel.this.ind, GenotypePanel.this.genotypeField.getText()) && GenotypePanel.this.validator.isValid(GenotypePanel.this.ind, GenotypePanel.this.context)) {
                GenotypePanel.this.updateGenotypeField();
                GenotypePanel.this.updateView();
            } else {
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        for (int i = 0; i < 5; ++i) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GenotypePanel.this.genotypeField.setForeground(Color.RED);
                                }
                            });
                            Thread.sleep(300L);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GenotypePanel.this.genotypeField.setForeground(Color.RED.darker().darker());
                                }
                            });
                            Thread.sleep(200L);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        GenotypePanel.this.genotypeField.setForeground(Color.BLACK);
                    }
                };
                sw.execute();
            }
        }
    }

    private class ActionLoadGenotype
    extends AbstractAction {
        public ActionLoadGenotype() {
            super("Load");
            this.putValue("ShortDescription", "Load a genotype from a file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FurnLayoutIndividual newInd = FurnLayoutIOUtil.loadGenotype(GenotypePanel.this, GenotypePanel.this.ind);
            if (newInd != null) {
                GenotypePanel.this.updateGenotypeField();
                GenotypePanel.this.updateView();
            }
        }
    }

    private class ActionSaveGenotype
    extends AbstractAction {
        public ActionSaveGenotype() {
            super("Save");
            this.putValue("ShortDescription", "Save this genotype to a file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GenotypePanel.this.validator.isValid(GenotypePanel.this.ind, GenotypePanel.this.context)) {
                FurnLayoutIOUtil.saveGenotype(GenotypePanel.this, GenotypePanel.this.ind);
            } else {
                JOptionPane.showMessageDialog(GenotypePanel.this, "Individual is invalid, create a valid individual first!", "Error writing file", 2);
            }
        }
    }

    private class ActionCreateRandomGenotype
    extends AbstractAction {
        public ActionCreateRandomGenotype() {
            super("Random genotype");
            this.putValue("ShortDescription", "Create a random genotype");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenotypePanel.this.minCount = (Integer)GenotypePanel.this.minCountSpinner.getValue();
            GenotypePanel.this.maxCount = (Integer)GenotypePanel.this.maxCountSpinner.getValue();
            GenotypePanel.this.minCount = Math.min(GenotypePanel.this.minCount, GenotypePanel.this.maxCount);
            GenotypePanel.this.minCountSpinner.setValue(GenotypePanel.this.minCount);
            GenotypePanel.this.context.put("GenomeMinLength", (Object)GenotypePanel.this.minCount);
            GenotypePanel.this.context.put("GenomeMaxLength", (Object)GenotypePanel.this.maxCount);
            GenotypePanel.this.randomizeInd();
        }
    }
}

