/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.importer;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import furny.furndb.importer.FurnDBImporter;
import furny.swing.admin.viewer.ModelViewerState;
import furny.swing.common.FileChooserPanel;
import furny.swing.common.FileChosenListener;
import furny.util.FileUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.JXHyperlink;

public class ImporterPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(ImporterPanel.class.getName());
    private FileChooserPanel fileChooserPanel;
    private FileListModel model;
    private JList filesList;
    private final File assetBaseDir = new File("src/assets/");
    private File watchDir = new File("src/assets/models");
    private FileWatchThread watchThread;
    private boolean watchThreadActive;
    private ActionRefreshNow actionRefreshNow;
    private final FurnDBImporter importer;
    private final SimpleApplication app;

    public ImporterPanel(SimpleApplication app) {
        this.app = app;
        this.importer = new FurnDBImporter(app);
        this.importer.setExitMode(FurnDBImporter.ExitMode.DETACH_AND_UPDATE_IDS);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        this.add((Component)this.createLiveExchangePanel(), constraints);
    }

    private JPanel createLiveExchangePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Directory import"));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        JCheckBox cb = new JCheckBox(new ActionToggleWatchDog());
        cb.setSelected(this.watchThreadActive);
        panel.add((Component)cb, constraints);
        ++constraints.gridx;
        this.actionRefreshNow = new ActionRefreshNow();
        this.actionRefreshNow.setEnabled(!this.watchThreadActive);
        panel.add((Component)new JButton(this.actionRefreshNow), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.fill = 2;
        this.fileChooserPanel = new FileChooserPanel(new WatchDirChosenListener(), new DirectoryFileFilter());
        this.fileChooserPanel.setFileSelectionMode(1);
        panel.add((Component)this.fileChooserPanel, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.model = new FileListModel();
        this.filesList = new JList(this.model);
        panel.add((Component)new JScrollPane(this.filesList), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        panel.add((Component)new JButton(new ActionImport()), constraints);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImporterPanel.this.fileChooserPanel.setFile(ImporterPanel.this.watchDir);
                if (ImporterPanel.this.watchThreadActive) {
                    ImporterPanel.this.watchThread = new FileWatchThread();
                    ImporterPanel.this.watchThread.start();
                }
            }
        });
        return panel;
    }

    private JPanel createImportPanel(FileTableModel model) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        panel.add(Box.createHorizontalGlue(), constraints);
        constraints.weightx = 0.0;
        ++constraints.gridx;
        panel.add((Component)new JXHyperlink((Action)new ActionSelectNone(model)), constraints);
        ++constraints.gridx;
        panel.add((Component)new JXHyperlink((Action)new ActionSelectAll(model)), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        JTable table = new JTable(model);
        table.setDefaultRenderer(File.class, new FileTableRenderer());
        panel.add((Component)new JScrollPane(table), constraints);
        return panel;
    }

    private class FileWatchThread
    extends Thread {
        public FileWatchThread() {
            this.setDaemon(true);
            this.setPriority(3);
        }

        @Override
        public void run() {
            while (ImporterPanel.this.watchThreadActive) {
                try {
                    FileWatchThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Failed to sleep", e);
                }
                if (!ImporterPanel.this.filesList.isShowing()) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImporterPanel.this.model.update();
                    }
                });
            }
        }
    }

    private static class FileEntry {
        private final File file;
        private boolean selected;

        public FileEntry(File file) {
            this.file = file;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public File getFile() {
            return this.file;
        }
    }

    private static class FileTableRenderer
    extends DefaultTableCellRenderer {
        private FileTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object val = value instanceof File ? ((File)value).getName() : value;
            return super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
        }
    }

    private static class FileTableModel
    extends AbstractTableModel {
        private static final int COL_FILE = 0;
        private static final int COL_SELECT = 1;
        private static final int COL_COUNT = 2;
        private final List<FileEntry> entries = new ArrayList<FileEntry>();
        private final String assetPath;

        public FileTableModel(String assetPath) {
            this.assetPath = assetPath;
            this.update();
        }

        private void update() {
            this.entries.clear();
            List<File> files = FileUtils.getFiles(new File(this.assetPath), ".*\\.mesh\\.xml");
            for (File file : files) {
                this.entries.add(new FileEntry(file));
            }
        }

        public List<FileEntry> getEntries() {
            return this.entries;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return File.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1) {
                this.entries.get(row).setSelected((Boolean)aValue);
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.entries.get(row).getFile();
                }
                case 1: {
                    return this.entries.get(row).isSelected();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "File";
                }
                case 1: {
                    return "Import";
                }
            }
            return "";
        }

        public List<File> getSelectedFiles() {
            ArrayList<File> files = new ArrayList<File>();
            for (FileEntry entry : this.entries) {
                if (!entry.isSelected()) continue;
                files.add(entry.getFile());
            }
            return files;
        }
    }

    private class FileListModel
    extends DefaultListModel {
        private final List<File> subFiles = new ArrayList<File>();

        public FileListModel() {
            this.update();
        }

        private void update() {
            List<File> actFiles = FileUtils.getFiles(ImporterPanel.this.watchDir, ".*\\.mesh\\.xml");
            this.subFiles.clear();
            this.subFiles.addAll(actFiles);
            this.fireContentsChanged(this, 0, this.subFiles.size() - 1);
        }

        public Object get(int index) {
            return this.subFiles.get(index).getName();
        }

        @Override
        public int getSize() {
            return this.subFiles.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.get(index);
        }
    }

    private class ActionImport
    extends AbstractAction {
        public ActionImport() {
            super("Import...");
            this.putValue("ShortDescription", "Import all furniture models from directory");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.log(Level.INFO, "absolute: " + ImporterPanel.this.watchDir.getAbsolutePath());
            String assetPath = ImporterPanel.this.watchDir.getAbsolutePath().replace('\\', '/');
            LOGGER.log(Level.INFO, "1: " + assetPath);
            if (assetPath.startsWith("/") && assetPath.length() > 1) {
                assetPath = assetPath.substring(1);
            }
            LOGGER.log(Level.INFO, "2: " + assetPath);
            if (!assetPath.endsWith("/") && assetPath.length() > 0) {
                assetPath = assetPath + "/";
            }
            LOGGER.log(Level.INFO, "3: " + assetPath);
            final String fAssetPath = assetPath;
            FileTableModel model = new FileTableModel(assetPath);
            if (model.getRowCount() == 0) {
                JOptionPane.showMessageDialog(ImporterPanel.this, "No model files found in this directory.", "No files to import", 1);
                return;
            }
            int n = JOptionPane.showConfirmDialog(ImporterPanel.this, ImporterPanel.this.createImportPanel(model), "Select files to import", 2, -1);
            final List<File> files = model.getSelectedFiles();
            if (n == 0 && !files.isEmpty()) {
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        AppState viewerState = ImporterPanel.this.app.getStateManager().getState(ModelViewerState.class);
                        if (viewerState != null) {
                            viewerState.setEnabled(false);
                        }
                        ImporterPanel.this.importer.importModelsFromFiles(fAssetPath, files, new FurnDBImporter.ImportListener(){

                            @Override
                            public void importDone() {
                                AppState viewerState = ImporterPanel.this.app.getStateManager().getState(ModelViewerState.class);
                                LOGGER.info("viewer activated" + viewerState);
                                if (viewerState != null) {
                                    viewerState.setEnabled(true);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(ImporterPanel.this, "Import was successful.", "Import successful", 1);
                                    }
                                });
                            }
                        });
                        return null;
                    }
                };
                worker.execute();
            }
        }
    }

    private class ActionRefreshNow
    extends AbstractAction {
        public ActionRefreshNow() {
            super("Refresh now");
            this.putValue("ShortDescription", "Refresh the directory view now");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImporterPanel.this.model.update();
        }
    }

    private class ActionToggleWatchDog
    extends AbstractAction {
        public ActionToggleWatchDog() {
            super("Auto refresh");
            this.putValue("ShortDescription", "Refresh the directory view when something changes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImporterPanel.this.watchThreadActive = ((AbstractButton)e.getSource()).isSelected();
            ImporterPanel.this.actionRefreshNow.setEnabled(!ImporterPanel.this.watchThreadActive);
            if (ImporterPanel.this.watchThreadActive) {
                ImporterPanel.this.watchThread = new FileWatchThread();
                ImporterPanel.this.watchThread.start();
            }
        }
    }

    private static class ActionSelectAll
    extends AbstractAction {
        private final FileTableModel model;

        public ActionSelectAll(FileTableModel model) {
            super("All");
            this.model = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (FileEntry entry : this.model.getEntries()) {
                entry.setSelected(true);
            }
            this.model.fireTableDataChanged();
        }
    }

    private static class ActionSelectNone
    extends AbstractAction {
        private final FileTableModel model;

        public ActionSelectNone(FileTableModel model) {
            super("None");
            this.model = model;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (FileEntry entry : this.model.getEntries()) {
                entry.setSelected(false);
            }
            this.model.fireTableDataChanged();
        }
    }

    private class WatchDirChosenListener
    implements FileChosenListener {
        private WatchDirChosenListener() {
        }

        @Override
        public void fileChosen(File file, int type) {
            ImporterPanel.this.watchDir = file;
            ImporterPanel.this.model.update();
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public String getDescription() {
            return "Directories";
        }

        @Override
        public boolean accept(File f) {
            return true;
        }
    }
}

