/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.statistics;

import furny.ga.logger.StatisticsDBManager;
import furny.swing.admin.statistics.chart.FitnessHistogramChart;
import furny.swing.admin.statistics.chart.FurnitureHistogramChart;
import furny.swing.admin.statistics.chart.IChartSettings;
import furny.swing.admin.statistics.chart.MaxFitnessGenerationChart;
import furny.swing.admin.statistics.chart.MaxFitnessTimeChart;
import furny.swing.admin.statistics.chart.MeanFitnessGenerationChart;
import furny.swing.admin.statistics.chart.MeanFitnessTimeChart;
import furny.swing.admin.statistics.chart.MinMaxFitnessGenerationChart;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXBusyLabel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class StatisticsFrame
extends JFrame {
    private final JList chartList;
    private final ChartListModel chartModel;
    private final JList runList;
    private final RunListModel runModel;
    private JDesktopPane desktop;
    private JPanel rightPanel;
    private Long runId;
    private IChartSettings settings;

    public StatisticsFrame() {
        super("Statistics DB");
        this.setDefaultCloseOperation(3);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.chartModel = new ChartListModel();
        this.chartList = new JList(this.chartModel);
        this.chartList.setSelectionMode(0);
        this.chartList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    StatisticsFrame.this.settings = (IChartSettings)StatisticsFrame.this.chartModel.getElementAt(StatisticsFrame.this.chartList.getSelectedIndex());
                    StatisticsFrame.this.openChartFrame();
                }
            }
        });
        this.runModel = new RunListModel();
        this.runList = new JList(this.runModel);
        this.runList.setSelectionMode(0);
        this.runList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    StatisticsFrame.this.runId = (Long)StatisticsFrame.this.runModel.getElementAt(StatisticsFrame.this.runList.getSelectedIndex());
                    StatisticsFrame.this.openChartFrame();
                }
            }
        });
        JSplitPane splitPane = new JSplitPane(0, new JScrollPane(this.chartList), new JScrollPane(this.runList));
        splitPane.setDividerLocation(300);
        UIManager.put("Desktop.background", this.chartList.getBackground());
        this.createRightPanel();
        splitPane = new JSplitPane(1, splitPane, this.rightPanel);
        splitPane.setDividerLocation(200);
        this.add((Component)splitPane, constraints);
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
    }

    private void createRightPanel() {
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.rightPanel.add((Component)new JButton(new ActionTileViews()), constraints);
        ++constraints.gridx;
        this.rightPanel.add((Component)new JButton(new ActionCascadeViews()), constraints);
        ++constraints.gridx;
        this.rightPanel.add((Component)new JButton(new ActionCloseAllViews()), constraints);
        ++constraints.gridx;
        this.rightPanel.add(Box.createHorizontalGlue(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.desktop = new JDesktopPane();
        this.rightPanel.add((Component)this.desktop, constraints);
    }

    private void openChartFrame() {
        if (this.runId != null && this.settings != null) {
            String title = ((Object)this.settings).toString() + " evaluation run " + this.runId;
            for (JInternalFrame frame : this.desktop.getAllFrames()) {
                if (!frame.getTitle().equals(title) || !frame.isVisible()) continue;
                try {
                    frame.setIcon(false);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                frame.moveToFront();
                return;
            }
            final JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
            final JXBusyLabel busyLabel = new JXBusyLabel(new Dimension(50, 50));
            busyLabel.setHorizontalAlignment(0);
            busyLabel.setBusy(true);
            frame.add((Component)busyLabel);
            frame.setBounds(this.desktop.getComponentCount() * 25, this.desktop.getComponentCount() * 20, 400, 300);
            this.desktop.add(frame);
            SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){
                private JFreeChart chart;

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        this.chart = StatisticsFrame.this.settings.createChart(StatisticsFrame.this.runId);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    ChartPanel chartPanel = new ChartPanel(this.chart);
                    frame.remove((Component)busyLabel);
                    frame.add((Component)chartPanel);
                    frame.setSize(frame.getSize());
                }
            };
            sw.execute();
            frame.setVisible(true);
        }
    }

    private class ActionCloseAllViews
    extends AbstractAction {
        public ActionCloseAllViews() {
            super("Close all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JInternalFrame[] frames;
            for (JInternalFrame frame : frames = StatisticsFrame.this.desktop.getAllFrames()) {
                try {
                    frame.setClosed(true);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private class ActionCascadeViews
    extends AbstractAction {
        public ActionCascadeViews() {
            super("Cascade");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dimension d = StatisticsFrame.this.desktop.getSize();
            JInternalFrame[] frames = StatisticsFrame.this.desktop.getAllFrames();
            int n = frames.length;
            if (n == 0) {
                return;
            }
            int s = frames[0].getRootPane().getLocation().y;
            int m = n * s;
            int w = d.width - m;
            int h = d.height - m;
            for (int i = 0; i < n; ++i) {
                try {
                    frames[n - i - 1].setMaximum(false);
                    frames[n - i - 1].setIcon(false);
                }
                catch (PropertyVetoException e1) {
                    e1.printStackTrace();
                }
                frames[n - i - 1].setBounds(i * s, i * s, w + s, h + s);
            }
        }
    }

    private class ActionTileViews
    extends AbstractAction {
        public ActionTileViews() {
            super("Grid");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int w;
            int h;
            int ny;
            Dimension d = StatisticsFrame.this.desktop.getSize();
            JInternalFrame[] frames = StatisticsFrame.this.desktop.getAllFrames();
            int n = frames.length;
            if (n == 0) {
                return;
            }
            int nx = (int)Math.sqrt(n);
            int ymax = frames.length - nx * ((ny = (int)Math.ceil((double)frames.length / (double)nx)) - 1);
            if (ymax == 0) {
                h = d.height / --ny;
            } else {
                h = d.height / ny;
                if (ymax < ny) {
                    --ny;
                    w = d.width / ymax;
                    for (int x = 0; x < ymax; ++x) {
                        frames[nx * ny + x].setBounds(x * w, ny * h, w, h);
                        try {
                            frames[nx * ny + x].setMaximum(false);
                            frames[nx * ny + x].setIcon(false);
                            continue;
                        }
                        catch (PropertyVetoException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            w = d.width / nx;
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    frames[x + y * nx].setBounds(x * w, y * h, w, h);
                    try {
                        frames[x + y * nx].setMaximum(false);
                        frames[x + y * nx].setIcon(false);
                        continue;
                    }
                    catch (PropertyVetoException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private class RunListModel
    extends DefaultListModel {
        private final List<Long> runIds = StatisticsDBManager.getInstance().getRunEntries();

        @Override
        public Object getElementAt(int index) {
            return this.runIds.get(index);
        }

        @Override
        public int getSize() {
            return this.runIds.size();
        }
    }

    private class ChartListModel
    extends DefaultListModel {
        private final List<IChartSettings> settings = new ArrayList<IChartSettings>();

        public ChartListModel() {
            this.settings.add(new MinMaxFitnessGenerationChart());
            this.settings.add(new MaxFitnessGenerationChart());
            this.settings.add(new MaxFitnessTimeChart());
            this.settings.add(new MeanFitnessGenerationChart());
            this.settings.add(new MeanFitnessTimeChart());
            this.settings.add(new FitnessHistogramChart());
            this.settings.add(new FurnitureHistogramChart());
        }

        @Override
        public Object getElementAt(int index) {
            return this.settings.get(index);
        }

        @Override
        public int getSize() {
            return this.settings.size();
        }
    }
}

