/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.statistics.chart;

import furny.ga.logger.StatisticsCache;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.IndividualEntry;
import furny.swing.admin.statistics.chart.IChartSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class FitnessHistogramChart
implements IChartSettings {
    @Override
    public JFreeChart createChart(long runId) {
        List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
        HistogramDataset dataset = new HistogramDataset();
        HashMap<Integer, Integer> generationIndCount = new HashMap<Integer, Integer>();
        HashMap<Integer, Double> generationFitness = new HashMap<Integer, Double>();
        for (IndividualEntry individualEntry : list) {
            int generation = individualEntry.getGeneration();
            Integer count = (Integer)generationIndCount.get(generation);
            if (count != null) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            } else {
                count = 1;
            }
            generationIndCount.put(generation, count);
            Double fitness = (Double)generationFitness.get(generation);
            Double newFitness = individualEntry.getFitness();
            if (newFitness != null) {
                fitness = fitness != null ? Double.valueOf(fitness + newFitness) : newFitness;
            }
            generationFitness.put(generation, fitness);
        }
        for (Map.Entry entry : generationIndCount.entrySet()) {
            Double fitness = generationFitness.get(entry.getKey()) != null ? Double.valueOf((Double)generationFitness.get(entry.getKey()) / ((Integer)entry.getValue()).doubleValue()) : null;
            dataset.addSeries((Comparable)entry.getKey(), new double[]{((Integer)entry.getValue()).intValue()}, 1);
        }
        JFreeChart chart = ChartFactory.createHistogram(null, (String)"Generation", (String)"Fitness", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    @Override
    public String toString() {
        return "Fitness histogram";
    }
}

