/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.statistics.chart;

import furny.furndb.FurnCache;
import furny.ga.logger.DataCache;
import furny.swing.admin.statistics.chart.IChartSettings;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class FurnitureHistogramChart
implements IChartSettings {
    @Override
    public JFreeChart createChart(long runId) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry<Long, Long> entry : DataCache.getInstance().getFurnitureCount(runId).entrySet()) {
            dataset.addValue((Number)entry.getValue(), (Comparable)entry.getValue(), (Comparable)((Object)FurnCache.getInstance().getFurniture(entry.getKey()).getName()));
        }
        JFreeChart chart = ChartFactory.createBarChart(null, (String)"Furniture", (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        plot.getRenderer().setPositiveItemLabelPosition(p);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        return chart;
    }

    @Override
    public String toString() {
        return "Furniture histogram";
    }
}

