/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.statistics.chart;

import furny.ga.logger.DataCache;
import furny.swing.admin.statistics.chart.IChartSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MinMaxFitnessGenerationChart
implements IChartSettings {
    @Override
    public JFreeChart createChart(long runId) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)"Fitness(max) over generations"));
        for (Map.Entry<Long, Double> entry : DataCache.getInstance().getMaxFitnessOverGenerations(runId).entrySet()) {
            series.add((Number)entry.getKey(), (Number)entry.getValue());
        }
        xyDataset.addSeries(series);
        series = new XYSeries((Comparable)((Object)"Fitness(min) over generations"));
        for (Map.Entry<Long, Double> entry : DataCache.getInstance().getMinFitnessOverGenerations(runId).entrySet()) {
            series.add((Number)entry.getKey(), (Number)entry.getValue());
        }
        xyDataset.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Generation", (String)"Fitness", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYDifferenceRenderer renderer = new XYDifferenceRenderer((Paint)new Color(0.5f, 0.5f, 1.0f, 0.5f), (Paint)Color.RED, false);
        renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
        renderer.setSeriesPaint(0, (Paint)Color.GREEN);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    @Override
    public String toString() {
        return "Fitness(min/max) / Generations";
    }
}

