/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.tags;

import furny.entities.Tag;
import furny.entities.TagType;
import furny.furndb.FurnDBManager;
import furny.swing.admin.tags.TagComboBox;
import furny.swing.admin.tags.TagFlavor;
import furny.swing.admin.tags.TagTransferable;
import furny.swing.admin.tags.TagTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.renderer.DefaultListRenderer;

public class EditFurnitureTagsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(EditFurnitureTagsPanel.class.getName());
    private final List<Tag> tagsToAdd = new ArrayList<Tag>();
    private final JXList tagList;
    private final TagTree tagTree;

    public EditFurnitureTagsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(10, 10, 10, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 2;
        constraints.fill = 1;
        this.tagTree = new TagTree();
        this.tagTree.addMouseListener(new AddTagMouseListener());
        JScrollPane scrollPane = new JScrollPane(this.tagTree);
        scrollPane.setPreferredSize(new Dimension(150, 500));
        this.add((Component)scrollPane, constraints);
        constraints.insets = new Insets(10, 5, 10, 5);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.fill = 0;
        constraints.anchor = 15;
        this.add((Component)new JButton(new ActionAddTag()), constraints);
        ++constraints.gridy;
        constraints.anchor = 11;
        this.add((Component)new JButton(new ActionRemoveTag()), constraints);
        constraints.insets = new Insets(10, 5, 10, 10);
        constraints.gridy = 0;
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 2;
        constraints.fill = 1;
        this.tagList = new JXList((ListModel)new TagListModel());
        this.tagList.setTransferHandler((TransferHandler)new TagTransferHandler());
        this.tagList.setCellRenderer((ListCellRenderer)((Object)new TagListRenderer()));
        this.tagList.setDragEnabled(true);
        this.tagList.setSelectionMode(2);
        this.tagList.addMouseListener((MouseListener)new RemoveTagMouseListener());
        scrollPane = new JScrollPane((Component)this.tagList);
        scrollPane.setPreferredSize(new Dimension(150, 500));
        this.add((Component)scrollPane, constraints);
        constraints.insets = new Insets(10, 5, 10, 10);
        constraints.gridx = 0;
        constraints.gridy += 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 2;
        constraints.fill = 0;
        constraints.anchor = 17;
        this.add((Component)new JButton(new ActionCreateTag()), constraints);
    }

    public List<Tag> getSelectedTags() {
        return this.tagsToAdd;
    }

    public void addTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (this.tagsToAdd.contains(tag)) continue;
            this.tagsToAdd.add(tag);
        }
        Collections.sort(this.tagsToAdd);
    }

    public void removeTags(List<Tag> tags) {
        for (Tag tag : tags) {
            this.tagsToAdd.remove(tag);
        }
    }

    private static class TagCreationPane
    extends JPanel {
        private final TagComboBox comboBox;
        private final JTextField tagNameField;

        public TagCreationPane(final TagType type) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(10, 10, 10, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            this.comboBox = new TagComboBox();
            if (type != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TagCreationPane.this.comboBox.setSelectedItem((Object)type);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TagCreationPane.this.tagNameField.requestFocusInWindow();
                            }
                        });
                    }
                });
            }
            this.add((Component)this.comboBox, constraints);
            ++constraints.gridx;
            this.tagNameField = new JTextField(25);
            this.add((Component)this.tagNameField, constraints);
        }

        public Tag getTag() {
            String name = this.tagNameField.getText();
            if (name != null && !name.isEmpty()) {
                return new Tag(this.comboBox.getSelectedTagType(), name);
            }
            return null;
        }
    }

    private class TagTransferHandler
    extends TransferHandler {
        @Override
        protected Transferable createTransferable(JComponent component) {
            ArrayList<Tag> selection = new ArrayList<Tag>();
            for (Object o : EditFurnitureTagsPanel.this.tagList.getSelectedValues()) {
                if (!(o instanceof Tag)) continue;
                selection.add((Tag)o);
            }
            EditFurnitureTagsPanel.this.tagsToAdd.removeAll(selection);
            ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
            if (!selection.isEmpty()) {
                return new TagTransferable(selection);
            }
            return null;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            for (DataFlavor df : transferFlavors) {
                if (!df.equals(new TagFlavor())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent comp, Transferable trans) {
            try {
                List tags = (List)trans.getTransferData(new TagFlavor());
                EditFurnitureTagsPanel.this.addTags(tags);
                ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to add tags", e);
                return false;
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }
    }

    private static class TagListRenderer
    extends DefaultListRenderer {
        private TagListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Tag t = (Tag)value;
            return super.getListCellRendererComponent(list, (Object)t.toString(), index, isSelected, cellHasFocus);
        }
    }

    private class TagListModel
    extends AbstractListModel {
        private TagListModel() {
        }

        public void fireListChanged() {
            this.fireContentsChanged(this, 0, Math.min(EditFurnitureTagsPanel.this.tagsToAdd.size() - 1, 0));
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.getSize()) {
                return EditFurnitureTagsPanel.this.tagsToAdd.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return EditFurnitureTagsPanel.this.tagsToAdd.size();
        }
    }

    private class ActionCreateTag
    extends AbstractAction {
        public ActionCreateTag() {
            super("Create Tag...");
            this.putValue("ShortDescription", "Create a new tag");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath tp = EditFurnitureTagsPanel.this.tagTree.getSelectionModel().getSelectionPath();
            Object o = null;
            if (tp != null) {
                o = tp.getLastPathComponent();
            }
            TagType type = null;
            if (o instanceof TagTree.TagNode) {
                type = ((TagTree.TagNode)o).getTag().getType();
            } else if (o instanceof TagTree.TagTypeNode) {
                type = ((TagTree.TagTypeNode)o).getType();
            }
            TagCreationPane tcp = new TagCreationPane(type);
            int n = JOptionPane.showConfirmDialog(null, tcp, "Create Tag", 2, -1);
            if (n == 0) {
                Tag tag = tcp.getTag();
                if (tag == null) {
                    JOptionPane.showMessageDialog(EditFurnitureTagsPanel.this, "Tag cannot be created without a name", "Error", 0);
                    return;
                }
                for (Tag t : EditFurnitureTagsPanel.this.tagTree.getAllTags()) {
                    if (!t.equals(tag)) continue;
                    JOptionPane.showMessageDialog(EditFurnitureTagsPanel.this, "This tag already exists", "Error", 0);
                    return;
                }
                FurnDBManager.getInstance().saveTag(tag);
                EditFurnitureTagsPanel.this.tagTree.update();
            }
        }
    }

    private class ActionAddTag
    extends AbstractAction {
        public ActionAddTag() {
            super(">>");
            this.putValue("ShortDescription", "Add the selected tags to the list");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditFurnitureTagsPanel.this.addTags(EditFurnitureTagsPanel.this.tagTree.getSelectedTags());
            Collections.sort(EditFurnitureTagsPanel.this.tagsToAdd);
            ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
        }
    }

    private class RemoveTagMouseListener
    extends MouseAdapter {
        private RemoveTagMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                EditFurnitureTagsPanel.this.tagsToAdd.removeAll(Arrays.asList(EditFurnitureTagsPanel.this.tagList.getSelectedValues()));
                EditFurnitureTagsPanel.this.tagList.clearSelection();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
                    }
                });
            }
        }
    }

    private class AddTagMouseListener
    extends MouseAdapter {
        private AddTagMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                EditFurnitureTagsPanel.this.addTags(EditFurnitureTagsPanel.this.tagTree.getSelectedTags());
                Collections.sort(EditFurnitureTagsPanel.this.tagsToAdd);
                ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
            }
        }
    }

    private class ActionRemoveTag
    extends AbstractAction {
        public ActionRemoveTag() {
            super("<<");
            this.putValue("ShortDescription", "Remove the selected tags from the list");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditFurnitureTagsPanel.this.tagsToAdd.removeAll(Arrays.asList(EditFurnitureTagsPanel.this.tagList.getSelectedValues()));
            EditFurnitureTagsPanel.this.tagList.clearSelection();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((TagListModel)EditFurnitureTagsPanel.this.tagList.getModel()).fireListChanged();
                }
            });
        }
    }
}

