/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.tags;

import furny.entities.Tag;
import furny.entities.TagType;
import furny.furndb.FurnDBManager;
import furny.furndb.TagUpdateListener;
import furny.swing.admin.tags.TagComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TagPanel
extends JPanel
implements TagUpdateListener {
    private final TagComboBox tagTypeComboBox;
    private final JTable tagTable;
    private final TagTableModel model;
    private final List<Tag> tags = new ArrayList<Tag>();

    public TagPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.weightx = 0.01;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 13;
        JLabel label = new JLabel("Type");
        this.add((Component)label, constraints);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        ++constraints.gridx;
        this.tagTypeComboBox = new TagComboBox();
        this.tagTypeComboBox.addActionListener(new TagTypeChangeListener());
        this.add((Component)this.tagTypeComboBox, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        this.add(Box.createHorizontalGlue(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        this.model = new TagTableModel();
        this.tagTable = new JTable(this.model);
        this.tagTable.setDefaultRenderer(Tag.class, new TagCellRenderer());
        this.tagTable.setTableHeader(null);
        this.getTagTable().setSelectionMode(1);
        this.getTagTable().setRowSelectionAllowed(true);
        this.add((Component)new JScrollPane(this.tagTable), constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        this.add((Component)new JButton(new ActionAddTag()), constraints);
        ++constraints.gridy;
        this.add((Component)new JButton(new ActionRemoveTag()), constraints);
        FurnDBManager.getInstance().addTagUpdateListener(this);
        this.updateTags();
    }

    public JTable getTagTable() {
        return this.tagTable;
    }

    public List<Tag> getSelectedTags() {
        int[] rows;
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (int i : rows = this.tagTable.getSelectedRows()) {
            list.add(this.tags.get(i));
        }
        return list;
    }

    @Override
    public void tagsUpdated(TagType type, final List<Tag> newTags) {
        TagType thisType = this.tagTypeComboBox.getSelectedTagType();
        if (thisType.equals((Object)type)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TagPanel.this.tags.clear();
                    TagPanel.this.tags.addAll(newTags);
                    TagPanel.this.model.fireTableDataChanged();
                }
            });
        }
    }

    private void updateTags() {
        TagType type = this.tagTypeComboBox.getSelectedTagType();
        FurnDBManager.getInstance().updateTags(type);
    }

    private class ActionRemoveTag
    extends AbstractAction {
        public ActionRemoveTag() {
            super("Delete Tags");
            this.putValue("ShortDescription", "Delete tags");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int n;
            List<Tag> tags = TagPanel.this.getSelectedTags();
            if (!tags.isEmpty() && (n = JOptionPane.showConfirmDialog(TagPanel.this, "Are you sure to delete the selected tags?\nThis can not be undone.", "Delete tag", 0, 2)) == 0) {
                for (Tag t : tags) {
                    FurnDBManager.getInstance().deleteTag(t);
                }
                TagPanel.this.updateTags();
            }
        }
    }

    private class ActionAddTag
    extends AbstractAction {
        public ActionAddTag() {
            super("New tag");
            this.putValue("ShortDescription", "Create a new tag");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(TagPanel.this, "Please type the name for the new tag", "Add tag", 3);
            if (name != null && !name.isEmpty()) {
                for (Tag t : TagPanel.this.tags) {
                    if (!name.equals(t.getName())) continue;
                    JOptionPane.showMessageDialog(TagPanel.this, "This tag already exists", "Error", 0);
                    return;
                }
                TagType type = (TagType)((Object)TagPanel.this.tagTypeComboBox.getSelectedItem());
                if (type != null) {
                    Tag tag = new Tag(type, name);
                    FurnDBManager.getInstance().saveTag(tag);
                    TagPanel.this.updateTags();
                }
            }
        }
    }

    private static class TagCellRenderer
    extends DefaultTableCellRenderer {
        private TagCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Tag) {
                this.setText(((Tag)value).getName());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class TagTableModel
    extends DefaultTableModel {
        private TagTableModel() {
        }

        @Override
        public Object getValueAt(int row, int column) {
            return TagPanel.this.tags.get(row);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Tag.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return TagPanel.this.tags.size();
        }
    }

    private class TagTypeChangeListener
    implements ActionListener {
        private TagTypeChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagPanel.this.updateTags();
        }
    }
}

