/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.tags;

import furny.entities.Tag;
import furny.entities.TagType;
import furny.furndb.FurnDBManager;
import furny.furndb.TagUpdateListener;
import furny.swing.admin.tags.TagTransferHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TagTree
extends JTree
implements TagUpdateListener {
    private static final Logger LOGGER = Logger.getLogger(TagTree.class.getName());
    private final TagTreeModel model = new TagTreeModel();
    private List<Tag> allTags = new ArrayList<Tag>();

    public TagTree() {
        this.setModel(this.model);
        this.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.setTransferHandler(new TagTransferHandler(this));
        this.setDragEnabled(true);
        FurnDBManager.getInstance().addTagUpdateListener(this);
        this.update();
    }

    public List<Tag> getSelectedTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (this.getSelectionPaths() != null) {
            for (TreePath tp : this.getSelectionPaths()) {
                Object o = tp.getLastPathComponent();
                if (!(o instanceof TagNode)) continue;
                tags.add(((TagNode)o).getTag());
            }
        }
        return tags;
    }

    public List<Tag> getAllTags() {
        return this.allTags;
    }

    public void update() {
        FurnDBManager.getInstance().updateTags(null);
    }

    @Override
    public void tagsUpdated(TagType type, final List<Tag> tags) {
        if (type == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TagTree.this.allTags = tags;
                    Collections.sort(TagTree.this.allTags);
                    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Tags");
                    TagType[] tagTypes = TagType.values();
                    Arrays.sort(tagTypes, new Comparator<TagType>(){

                        @Override
                        public int compare(TagType o1, TagType o2) {
                            return o2.getRanking() - o1.getRanking();
                        }
                    });
                    for (TagType type : tagTypes) {
                        TagTypeNode n = new TagTypeNode(type);
                        root.add(n);
                        for (Tag tag : tags) {
                            if (!type.equals((Object)tag.getType())) continue;
                            n.add(new TagNode(tag));
                        }
                    }
                    TagTree.this.model.setRoot(root);
                    TagTree.this.model.fireTreeStructureChanged(root);
                    for (int i = 0; i < TagTree.this.getRowCount(); ++i) {
                        TagTree.this.expandRow(i);
                    }
                }
            });
        }
    }

    public static class TagNode
    extends DefaultMutableTreeNode {
        private final Tag tag;

        public TagNode(Tag tag) {
            this.tag = tag;
        }

        @Override
        public String toString() {
            return this.tag.getName();
        }

        public Tag getTag() {
            return this.tag;
        }
    }

    public static class TagTypeNode
    extends DefaultMutableTreeNode {
        private final TagType type;

        public TagTypeNode(TagType type) {
            this.type = type;
        }

        @Override
        public String toString() {
            return this.type.name();
        }

        public TagType getType() {
            return this.type;
        }
    }

    public static class TagTreeModel
    extends DefaultTreeModel {
        public TagTreeModel() {
            super(new DefaultMutableTreeNode("Tags"));
        }

        @Override
        public DefaultMutableTreeNode getRoot() {
            return (DefaultMutableTreeNode)super.getRoot();
        }

        public void refreshAllNodes() {
            this.refreshNode(this.getRoot());
        }

        private void refreshNode(TreeNode tn) {
            this.fireTreeNodesChanged(tn);
            for (int i = 0; i < tn.getChildCount(); ++i) {
                this.refreshNode(tn.getChildAt(i));
            }
        }

        public void fireTreeStructureChanged(TreeNode node) {
            try {
                TreeModelEvent event = new TreeModelEvent((Object)this, this.getPathToRoot(node));
                for (TreeModelListener l : this.getTreeModelListeners()) {
                    l.treeStructureChanged(event);
                }
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "An error occured", e);
            }
        }

        public void fireTreeNodesChanged(TreeNode node) {
            try {
                TreeModelEvent event = new TreeModelEvent((Object)this, this.getPathToRoot(node));
                for (TreeModelListener l : this.getTreeModelListeners()) {
                    l.treeNodesChanged(event);
                }
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "An error occured", e);
            }
        }
    }
}

