/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.viewer;

import com.jme3.app.state.AppState;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.input.ChaseCamera;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.furndb.importer.DBModelSource;
import furny.furndb.importer.IModelSource;
import furny.jme.FurnyApplication;
import furny.jme.appstate.SimpleAppState;
import furny.jme.node.Arrow;
import furny.jme.node.Grid;
import furny.swing.admin.viewer.IModelViewer;
import furny.util.CameraUtils;
import furny.util.LightingUtil;
import furny.util.ModelUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.concurrent.Callable;

public class ModelViewerState
extends SimpleAppState
implements IModelViewer {
    private final IModelSource modelSource;
    private ChaseCam2 chaseCam;
    private Node camTarget;
    private Node modelNode;
    private Node axisNode;
    private Node arrowNode;
    private Node scaleGrid;
    private Node userScaleGrid;
    private BitmapText infoText;
    private BitmapText infoText2;
    private BitmapText infoText3;
    private BitmapFont consoleFont;
    private Material redMaterial;
    private Material greenMaterial;
    private Material blueMaterial;
    private Furniture furniture;
    private boolean rotating;
    private boolean manual;
    private boolean showGrid;
    private boolean showScaleGrid;
    private boolean showUserScaleGrid;
    private boolean showDirectionArrow = true;
    private boolean hasModel;
    private final NumberFormat floatFormat = new DecimalFormat("0.00");
    private final FurnyApplication mainApp;

    public ModelViewerState(IModelSource modelSource, FurnyApplication app) {
        this.modelSource = modelSource;
        this.mainApp = app;
    }

    @Override
    public void simpleInitAppState() {
        this.camTarget = new Node("Camera Target");
        this.modelNode = new Node("Model Node");
        this.flyCam.setEnabled(false);
        this.chaseCam = new ChaseCam2(this.cam, this.camTarget, this.inputManager);
        this.chaseCam.setMaxDistance(20.0f);
        this.chaseCam.setMinDistance(0.01f);
        this.chaseCam.setMinVerticalRotation(-1.5707964f);
        this.chaseCam.setInvertVerticalAxis(false);
        this.chaseCam.setZoomSensitivity(20.0f);
        this.chaseCam.setZoomSpeed(0.02f);
        this.chaseCam.setRotationSensitivity(20.0f);
        this.chaseCam.setDragToRotate(true);
        this.chaseCam.setSmoothMotion(false);
        this.viewPort.setBackgroundColor(ColorRGBA.White);
        this.inputManager.addMapping("manual", new Trigger[]{new MouseButtonTrigger(0), new MouseButtonTrigger(1), new MouseButtonTrigger(2)});
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                ModelViewerState.this.manual = isPressed;
            }
        }, new String[]{"manual"});
        this.inputManager.addMapping("nextModel", new Trigger[]{new KeyTrigger(205)});
        this.inputManager.addMapping("previousModel", new Trigger[]{new KeyTrigger(203)});
        this.inputManager.addListener((InputListener)new ActionListener(){

            public void onAction(String name, boolean isPressed, float tpf) {
                if (isPressed) {
                    if ("nextModel".equals(name)) {
                        ModelViewerState.this.loadModel(1);
                    } else if ("previousModel".equals(name)) {
                        ModelViewerState.this.loadModel(-1);
                    }
                }
            }
        }, new String[]{"nextModel", "previousModel"});
        this.rootNode.attachChild((Spatial)this.camTarget);
        this.rootNode.attachChild((Spatial)this.modelNode);
        this.greenMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.greenMaterial.getAdditionalRenderState().setDepthTest(false);
        this.greenMaterial.setColor("Color", ColorRGBA.Green);
        this.redMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.redMaterial.getAdditionalRenderState().setDepthTest(false);
        this.redMaterial.setColor("Color", ColorRGBA.Red);
        this.blueMaterial = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.blueMaterial.getAdditionalRenderState().setDepthTest(false);
        this.blueMaterial.setColor("Color", ColorRGBA.Blue);
        this.axisNode = new Grid(new Vector3f(1.0f, 1.0f, 1.0f), 0.25f, 1.0f, this.assetManager);
        this.axisNode.setMaterial(this.redMaterial);
        this.rootNode.attachChild((Spatial)this.axisNode);
        this.arrowNode = new Arrow(Vector3f.ZERO, Vector3f.UNIT_Z, 0.06f, 3.0f, this.assetManager);
        this.arrowNode.setMaterial(this.blueMaterial);
        this.rootNode.attachChild((Spatial)this.arrowNode);
        this.setShowGrid(false);
        LightingUtil.createDefaultLights(this.rootNode);
        this.infoText = new BitmapText(this.guiFont, false);
        this.infoText.setText("");
        this.infoText.setColor(ColorRGBA.Black);
        this.consoleFont = this.assetManager.loadFont("Interface/Fonts/Console.fnt");
        this.infoText2 = new BitmapText(this.consoleFont, false);
        this.infoText2.setText("");
        this.infoText2.setColor(ColorRGBA.Black);
        this.infoText3 = new BitmapText(this.consoleFont, false);
        this.infoText3.setText("");
        this.infoText3.setColor(ColorRGBA.Black);
        this.arrangeText(this.mainApp.getAppSettings().getWidth(), this.mainApp.getAppSettings().getHeight());
        this.guiNode.attachChild((Spatial)this.infoText);
        this.guiNode.attachChild((Spatial)this.infoText2);
        this.guiNode.attachChild((Spatial)this.infoText3);
        this.fpsText.setColor(ColorRGBA.Black);
        this.setShowStatistics(this.isShowStatistics());
        for (Spatial sp : this.statsView.getChildren()) {
            if (!(sp instanceof BitmapText)) continue;
            ((BitmapText)sp).setColor(ColorRGBA.Black);
        }
        if (!this.hasModel) {
            this.loadModel(0);
        }
    }

    @Override
    public void setShowGrid(final boolean show) {
        this.showGrid = show;
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ModelViewerState.this.axisNode.setCullHint(show ? Spatial.CullHint.Never : Spatial.CullHint.Always);
                return null;
            }
        });
    }

    @Override
    public boolean isShowGrid() {
        return this.showGrid;
    }

    @Override
    public boolean isShowDirection() {
        return this.showDirectionArrow;
    }

    @Override
    public void setShowDirection(final boolean showDirectionArrow) {
        this.showDirectionArrow = showDirectionArrow;
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ModelViewerState.this.arrowNode.setCullHint(showDirectionArrow ? Spatial.CullHint.Never : Spatial.CullHint.Always);
                return null;
            }
        });
    }

    @Override
    public boolean isRotating() {
        return this.rotating;
    }

    @Override
    public void setRotating(boolean rotating) {
        this.rotating = rotating;
    }

    public boolean isClosed() {
        return !this.mainApp.getContext().isCreated();
    }

    private void loadModel(int offset) {
        Furniture furn = this.modelSource.next(offset);
        if (furn != null) {
            this.setFurniture(furn);
        }
    }

    @Override
    public void setFurniture(final Furniture furn) {
        this.furniture = furn;
        this.hasModel = true;
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ModelViewerState.this.modelNode.detachAllChildren();
                if (furn != null) {
                    ModelViewerState.this.modelNode.attachChild((Spatial)furn.getModel());
                    Vector3f extents = ModelUtil.getExtents(furn.getModel());
                    Vector3f halfExtents = extents.divide(2.0f);
                    Vector3f center = furn.getModel().getWorldBound().getCenter();
                    ModelViewerState.this.scaleGrid = new Grid(extents, 0.0f, 0.0f, 2.0f, ModelViewerState.this.assetManager);
                    ModelViewerState.this.scaleGrid.setMaterial(ModelViewerState.this.redMaterial);
                    ModelViewerState.this.modelNode.attachChild((Spatial)ModelViewerState.this.scaleGrid);
                    ModelViewerState.this.scaleGrid.setLocalTranslation(center.subtract(halfExtents));
                    Vector3f userExtents = furn.getMetaData().getDimension();
                    ModelViewerState.this.userScaleGrid = new Grid(userExtents, 0.0f, 0.0f, 2.0f, ModelViewerState.this.assetManager);
                    ModelViewerState.this.userScaleGrid.setMaterial(ModelViewerState.this.greenMaterial);
                    ModelViewerState.this.modelNode.attachChild((Spatial)ModelViewerState.this.userScaleGrid);
                    ModelViewerState.this.userScaleGrid.setLocalTranslation(center.subtract(userExtents.divide(2.0f)));
                    ModelViewerState.this.infoText.setText(furn.getName() + " (" + furn.getModel().getTriangleCount() + " Triangles)");
                    ModelViewerState.this.infoText2.setText("scale: " + ModelViewerState.this.floatFormat.format(extents.x) + ", " + ModelViewerState.this.floatFormat.format(extents.y) + ", " + ModelViewerState.this.floatFormat.format(extents.z));
                    ModelViewerState.this.infoText3.setText("user scale: " + ModelViewerState.this.floatFormat.format(userExtents.x) + ", " + ModelViewerState.this.floatFormat.format(userExtents.y) + ", " + ModelViewerState.this.floatFormat.format(userExtents.z));
                    ModelViewerState.this.setShowScaleGrid(ModelViewerState.this.showScaleGrid);
                    ModelViewerState.this.setShowUserScaleGrid(ModelViewerState.this.showUserScaleGrid);
                    CameraUtils.adjustChaseCam(furn.getModel(), ModelViewerState.this.chaseCam, ModelViewerState.this.cam, ModelViewerState.this.camTarget);
                    ModelViewerState.this.modelSource.seek(furn);
                } else {
                    ModelViewerState.this.infoText.setText("");
                    ModelViewerState.this.infoText2.setText("");
                    ModelViewerState.this.infoText3.setText("");
                }
                ModelViewerState.this.rootNode.updateGeometricState();
                ModelViewerState.this.guiNode.updateGeometricState();
                return null;
            }
        });
    }

    @Override
    public boolean isShowScaleGrid() {
        return this.showScaleGrid;
    }

    @Override
    public void setShowScaleGrid(final boolean showScaleGrid) {
        this.showScaleGrid = showScaleGrid;
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ModelViewerState.this.scaleGrid.setCullHint(showScaleGrid ? Spatial.CullHint.Never : Spatial.CullHint.Always);
                return null;
            }
        });
    }

    @Override
    public boolean isShowUserScaleGrid() {
        return this.showUserScaleGrid;
    }

    @Override
    public void setShowUserScaleGrid(final boolean showUserScaleGrid) {
        this.showUserScaleGrid = showUserScaleGrid;
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ModelViewerState.this.userScaleGrid.setCullHint(showUserScaleGrid ? Spatial.CullHint.Never : Spatial.CullHint.Always);
                return null;
            }
        });
    }

    @Override
    public void simpleUpdate(float tpf) {
        if (!this.manual && this.rotating) {
            this.chaseCam.setDefaultHorizontalRotation(this.chaseCam.getHorizontalRotation() + 0.5f * tpf);
        }
    }

    @Override
    public void centerFurniture(boolean save) {
        if (this.furniture != null) {
            Node n = this.furniture.getModel();
            ModelUtil.center(n);
            CameraUtils.adjustChaseCam(n, this.chaseCam, this.cam, this.camTarget);
            if (save) {
                this.furniture.setModel(n);
                FurnDBManager.getInstance().saveFurniture(this.furniture, true);
            }
        }
    }

    @Override
    public void rotateFurniture(float rotation, boolean save) {
        if (this.furniture != null) {
            Node n = this.furniture.getModel();
            n.rotate(0.0f, rotation, 0.0f);
            CameraUtils.adjustChaseCam(n, this.chaseCam, this.cam, this.camTarget);
            if (save) {
                this.furniture.setModel(n);
                FurnDBManager.getInstance().saveFurniture(this.furniture, true);
            }
        }
    }

    @Override
    public void arrangeText(final int width, final int height) {
        this.mainApp.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (ModelViewerState.this.infoText != null && ModelViewerState.this.infoText2 != null && ModelViewerState.this.infoText3 != null) {
                    ModelViewerState.this.infoText.setLocalTranslation(0.0f, (float)height, 0.0f);
                    ModelViewerState.this.infoText.setBox(new Rectangle(0.0f, 0.0f, (float)width, ModelViewerState.this.infoText.getLineHeight()));
                    ModelViewerState.this.infoText.setAlignment(BitmapFont.Align.Center);
                    ModelViewerState.this.infoText2.setLocalTranslation(0.0f, (float)height - ModelViewerState.this.infoText.getLineHeight(), 0.0f);
                    ModelViewerState.this.infoText2.setBox(new Rectangle(0.0f, 0.0f, (float)width, ModelViewerState.this.infoText2.getLineHeight()));
                    ModelViewerState.this.infoText2.setAlignment(BitmapFont.Align.Center);
                    ModelViewerState.this.infoText3.setLocalTranslation(0.0f, (float)height - ModelViewerState.this.infoText.getLineHeight() - ModelViewerState.this.infoText2.getLineHeight(), 0.0f);
                    ModelViewerState.this.infoText3.setBox(new Rectangle(0.0f, 0.0f, (float)width, ModelViewerState.this.infoText3.getLineHeight()));
                    ModelViewerState.this.infoText3.setAlignment(BitmapFont.Align.Center);
                    ModelViewerState.this.guiNode.updateGeometricState();
                }
                return null;
            }
        });
    }

    public static void main(String[] args) {
        DBModelSource source = new DBModelSource();
        final FurnyApplication app = new FurnyApplication();
        final ModelViewerState state = new ModelViewerState(source, app);
        app.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                app.getStateManager().attach((AppState)state);
                return null;
            }
        });
        app.start();
    }

    private final class ChaseCam2
    extends ChaseCamera {
        public ChaseCam2(Camera cam, Node target, InputManager inputManager) {
            super(cam, (Spatial)target, inputManager);
        }

        public void setZoomSpeed(float zoomSpeed) {
            this.zoomSpeed = zoomSpeed;
        }
    }
}

