/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.admin.viewer;

import com.jme3.app.Application;
import com.jme3.system.JmeCanvasContext;
import furny.swing.admin.viewer.IModelViewer;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ViewerCanvasPanel
extends JPanel {
    private final IModelViewer viewer;
    private Canvas canvas;
    private final Application app;
    private boolean initialized;

    public ViewerCanvasPanel(Application app, IModelViewer viewer) {
        this.viewer = viewer;
        this.app = app;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ViewerCanvasPanel.this.checkInit();
            }
        });
    }

    private void checkInit() {
        if (!this.initialized) {
            this.app.createCanvas();
            JmeCanvasContext context = (JmeCanvasContext)this.app.getContext();
            this.canvas = context.getCanvas();
            this.canvas.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ViewerCanvasPanel.this.updateViewerSize();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ViewerCanvasPanel.this.updateViewerSize();
                }
            });
            this.app.startCanvas();
            this.viewer.setShowStatistics(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 17;
            JCheckBox cb = new JCheckBox(new ActionToggleRotation());
            cb.setSelected(this.viewer.isRotating());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            cb = new JCheckBox(new ActionToggleGrid());
            cb.setSelected(this.viewer.isShowGrid());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            cb = new JCheckBox(new ActionToggleDirection());
            cb.setSelected(this.viewer.isShowDirection());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            cb = new JCheckBox(new ActionToggleScaleGrid());
            cb.setSelected(this.viewer.isShowScaleGrid());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            cb = new JCheckBox(new ActionToggleUserScaleGrid());
            cb.setSelected(this.viewer.isShowUserScaleGrid());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            cb = new JCheckBox(new ActionToggleStats());
            cb.setSelected(this.viewer.isShowStatistics());
            this.add((Component)cb, constraints);
            ++constraints.gridx;
            this.add((Component)new JButton(new ActionCenter()), constraints);
            ++constraints.gridx;
            this.add((Component)new JButton(new ActionRotateLeft()), constraints);
            ++constraints.gridx;
            this.add((Component)new JButton(new ActionRotateRight()), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            this.add((Component)this.canvas, constraints);
            this.initialized = true;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.initialized) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewerCanvasPanel.this.updateViewerSize();
                }
            });
        }
    }

    public void updateViewerSize() {
        this.checkInit();
        this.viewer.arrangeText(this.canvas.getWidth(), this.canvas.getHeight());
    }

    private class ActionRotateLeft
    extends AbstractAction {
        public ActionRotateLeft() {
            super("Rotate left");
            this.putValue("ShortDescription", "Rotate the model left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.rotateFurniture(-1.5707964f, true);
        }
    }

    private class ActionRotateRight
    extends AbstractAction {
        public ActionRotateRight() {
            super("Rotate right");
            this.putValue("ShortDescription", "Rotate the model left");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.rotateFurniture(1.5707964f, true);
        }
    }

    private class ActionCenter
    extends AbstractAction {
        public ActionCenter() {
            super("Center");
            this.putValue("ShortDescription", "Center the model");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.centerFurniture(true);
        }
    }

    private class ActionToggleDirection
    extends AbstractAction {
        public ActionToggleDirection() {
            super("Direction");
            this.putValue("ShortDescription", "Set direction arrow on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setShowDirection(!ViewerCanvasPanel.this.viewer.isShowDirection());
        }
    }

    private class ActionToggleStats
    extends AbstractAction {
        public ActionToggleStats() {
            super("Statistics");
            this.putValue("ShortDescription", "Set statistics on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setShowStatistics(!ViewerCanvasPanel.this.viewer.isShowStatistics());
        }
    }

    private class ActionToggleScaleGrid
    extends AbstractAction {
        public ActionToggleScaleGrid() {
            super("Real scale");
            this.putValue("ShortDescription", "Set calculated scale grid on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setShowScaleGrid(!ViewerCanvasPanel.this.viewer.isShowScaleGrid());
        }
    }

    private class ActionToggleUserScaleGrid
    extends AbstractAction {
        public ActionToggleUserScaleGrid() {
            super("User scale");
            this.putValue("ShortDescription", "Set user scale grid on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setShowUserScaleGrid(!ViewerCanvasPanel.this.viewer.isShowUserScaleGrid());
        }
    }

    private class ActionToggleGrid
    extends AbstractAction {
        public ActionToggleGrid() {
            super("Axis");
            this.putValue("ShortDescription", "Set axis on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setShowGrid(!ViewerCanvasPanel.this.viewer.isShowGrid());
        }
    }

    private class ActionToggleRotation
    extends AbstractAction {
        public ActionToggleRotation() {
            super("Rotate");
            this.putValue("ShortDescription", "Set rotation on/off");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewerCanvasPanel.this.viewer.setRotating(!ViewerCanvasPanel.this.viewer.isRotating());
        }
    }
}

