/*
 * Decompiled with CFR 0.152.
 */
package furny.swing.common;

import furny.swing.common.FileChosenListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserPanel
extends JPanel {
    private JTextField textField;
    private File lastPath = new File(".");
    private File file;
    private JButton button;
    private FileChosenListener listener;
    private FileFilter filter;
    private int fileSelectionMode = 2;

    public FileChooserPanel(FileChosenListener listener, FileFilter filter) {
        this.listener = listener;
        this.filter = filter;
        this.setLayout(new BorderLayout());
        this.textField = new JTextField(" ", 10);
        this.setBorder(this.textField.getBorder());
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (FileChooserPanel.this.file != null) {
                    FileChooserPanel.this.textField.setText(FileChooserPanel.this.file.getAbsolutePath());
                    FileChooserPanel.this.textField.setToolTipText(FileChooserPanel.this.file.getAbsolutePath());
                } else {
                    FileChooserPanel.this.textField.setText("");
                    FileChooserPanel.this.textField.setToolTipText("");
                }
            }
        });
        this.add((Component)this.textField, "Center");
        this.setBackground(this.textField.getBackground());
        this.button = new JButton(new ActionFileBrowse()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(18, 18);
            }

            @Override
            public void setSize(Dimension d) {
                super.setSize(this.getPreferredSize());
            }
        };
        this.button.setMargin(new Insets(3, 3, 3, 3));
        this.button.setOpaque(false);
        this.button.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.button, "East");
    }

    public File getSelectedFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        String name = file != null ? file.getAbsolutePath() : "";
        this.textField.setText(name);
        String path = file != null ? file.getAbsolutePath() : "";
        this.textField.setToolTipText(path);
        if (file != null) {
            this.lastPath = file.isDirectory() ? file : file.getParentFile();
        }
        this.listener.fileChosen(file, 0);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setFile(String fileName) {
        File f = null;
        if (fileName != null) {
            f = new File(fileName);
        }
        this.setFile(f);
    }

    private class ActionFileBrowse
    extends AbstractAction {
        public ActionFileBrowse() {
            super("...");
            this.putValue("ShortDescription", "Browse for a file");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser chooser = new JFileChooser(FileChooserPanel.this.lastPath);
            chooser.setFileFilter(FileChooserPanel.this.filter);
            chooser.setFileSelectionMode(FileChooserPanel.this.fileSelectionMode);
            int returnVal = chooser.showOpenDialog(FileChooserPanel.this.getParent());
            if (returnVal == 0) {
                FileChooserPanel.this.file = chooser.getSelectedFile();
                FileChooserPanel.this.setFile(FileChooserPanel.this.file);
            }
        }
    }
}

