/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.automatic;

import ga.core.GA;
import ga.core.evaluation.IFitnessEvaluator;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.IMutationOp;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IClusterPopulation;
import ga.core.individual.population.IPopulation;
import ga.core.selection.ISelector;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.logging.Logger;

public class SGA<T extends IIndividual<T>>
implements GA<T> {
    private static final Logger LOGGER = Logger.getLogger(SGA.class.getName());
    private static final int CRITICAL_WHILE_ITERATIONS = 1000;
    private final IPopulation<T> population;
    private final ISelector<T> selector;
    private final IMutationOp<T> mutateOperator;
    private final ICrossoverOp<T> crossoverOperator;
    private IValidator<T> validator;
    private final GAContext gaContext;
    private boolean validate;
    private boolean useEliteStrategy;
    private int generation;

    public SGA(IPopulation<T> population, IFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, boolean useEliteStrategy, GAContext context) {
        this.population = population;
        this.selector = selector;
        this.mutateOperator = mutateOperator;
        this.crossoverOperator = crossoverOperator;
        this.useEliteStrategy = useEliteStrategy;
        this.gaContext = context;
        population.setEvaluator(evaluator);
    }

    public SGA(IPopulation<T> population, IFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, boolean useEliteStrategy) {
        this(population, evaluator, selector, mutateOperator, crossoverOperator, useEliteStrategy, new GAContext());
    }

    @Override
    public void init() {
        this.population.initRandomly(this.validate ? this.validator : null, this.gaContext);
        if (this.population instanceof IClusterPopulation) {
            ((IClusterPopulation)this.population).doClustering();
        }
        this.population.evaluateAutomatic();
    }

    @Override
    public void step() {
        IndividualList<Object> selectedIndividuals;
        ++this.generation;
        int whileCounter = 0;
        do {
            selectedIndividuals = this.selector.select(this.population);
            IIndividual ind1 = (IIndividual)selectedIndividuals.get(0);
            IIndividual ind2 = (IIndividual)selectedIndividuals.get(1);
            selectedIndividuals = this.crossoverOperator.crossover(ind1, ind2, this.gaContext);
            IIndividual mutatedIndividual = this.mutateOperator.mutate((IIndividual)selectedIndividuals.get(0), this.gaContext);
            selectedIndividuals.set(0, mutatedIndividual);
            mutatedIndividual = this.mutateOperator.mutate((IIndividual)selectedIndividuals.get(1), this.gaContext);
            selectedIndividuals.set(1, mutatedIndividual);
            if (++whileCounter <= 1000) continue;
            LOGGER.warning("Critical iterations exceeded. Endless loop?");
        } while (this.validate && this.validator != null && !selectedIndividuals.isValid(this.validator, this.gaContext));
        this.selector.insert(selectedIndividuals, this.population, this.useEliteStrategy);
        if (this.population instanceof IClusterPopulation) {
            ((IClusterPopulation)this.population).doClustering();
        }
        this.population.evaluateAutomatic();
    }

    @Override
    public void setValidate(boolean validate) {
        if (validate && this.validator == null) {
            throw new RuntimeException("Error - no validator has been set");
        }
        this.validate = validate;
    }

    @Override
    public void setValidator(IValidator<T> validator) {
        this.validator = validator;
        if (validator != null) {
            this.validate = true;
        }
    }

    @Override
    public IPopulation<T> getPopulation() {
        return this.population;
    }
}

