/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.automatic;

import ga.core.GA;
import ga.core.evaluation.IFitnessEvaluator;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.IMutationOp;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IClusterPopulation;
import ga.core.individual.population.IPopulation;
import ga.core.selection.ISelector;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.logging.Logger;

public class SGAGeneration<T extends IIndividual<T>>
implements GA<T> {
    private static final Logger LOGGER = Logger.getLogger(SGAGeneration.class.getName());
    private static final int CRITICAL_WHILE_ITERATIONS = 100000;
    private final IPopulation<T> population;
    private final ISelector<T> selector;
    private final IMutationOp<T> mutateOp;
    private final ICrossoverOp<T> crossoverOp;
    private IValidator<T> validator;
    private final GAContext gaContext;
    private boolean validate;
    private boolean useEliteStrategy;
    private int generation;

    public SGAGeneration(IPopulation<T> population, IFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, boolean useEliteStrategy, GAContext context) {
        this.population = population;
        this.selector = selector;
        this.mutateOp = mutateOperator;
        this.crossoverOp = crossoverOperator;
        this.gaContext = context;
        this.useEliteStrategy = useEliteStrategy;
        population.setEvaluator(evaluator);
    }

    public SGAGeneration(IPopulation<T> population, IFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, boolean useEliteStrategy) {
        this(population, evaluator, selector, mutateOperator, crossoverOperator, useEliteStrategy, new GAContext());
    }

    @Override
    public void init() {
        this.population.initRandomly(this.validate ? this.validator : null, this.gaContext);
        if (this.population instanceof IClusterPopulation) {
            ((IClusterPopulation)this.population).doClustering();
        }
        this.population.evaluateAutomatic();
    }

    @Override
    public void step() {
        IndividualList nextGeneration = new IndividualList();
        while (nextGeneration.size() < this.population.size()) {
            IndividualList<T> newIndividuals = this.doReproduction();
            for (IIndividual newIndividual : newIndividuals) {
                if (!this.population.isAllowDuplicates() && nextGeneration.contains(newIndividual)) continue;
                nextGeneration.add(newIndividual);
            }
            while (nextGeneration.size() > this.population.size()) {
                nextGeneration.remove(0);
            }
        }
        if (this.useEliteStrategy) {
            nextGeneration.set(0, this.getPopulation().getEliteIndividual().clone());
        }
        ++this.generation;
        this.population.clear();
        this.population.addIndividuals(nextGeneration);
        if (this.population instanceof IClusterPopulation) {
            ((IClusterPopulation)this.population).doClustering();
        }
        this.population.evaluateAutomatic();
    }

    private IndividualList<T> doReproduction() {
        IndividualList<Object> selectedIndividuals = this.selector.select(this.population);
        IIndividual ind1 = (IIndividual)selectedIndividuals.get(0);
        IIndividual ind2 = (IIndividual)selectedIndividuals.get(1);
        int whileCounter = 0;
        do {
            IndividualList<IIndividual> newSelectedIndividuals;
            if ((newSelectedIndividuals = this.crossoverOp.crossover(ind1, ind2, this.gaContext)) != null) {
                selectedIndividuals = newSelectedIndividuals;
            } else {
                LOGGER.warning("Crossover operation returned null");
            }
            for (int i = 0; i < selectedIndividuals.size(); ++i) {
                IIndividual ind = (IIndividual)selectedIndividuals.get(i);
                IIndividual mutatedIndividual = this.mutateOp.mutate(ind, this.gaContext);
                if (mutatedIndividual != null) {
                    selectedIndividuals.set(i, mutatedIndividual);
                    continue;
                }
                LOGGER.warning("Mutation operation returned null");
            }
            if (++whileCounter <= 100000) continue;
            LOGGER.warning("Critical iterations exceeded. Endless loop? Individuals: " + ind1 + "   " + ind2);
            return selectedIndividuals;
        } while (this.validate && this.validator != null && !selectedIndividuals.isValid(this.validator, this.gaContext));
        return selectedIndividuals;
    }

    @Override
    public void setValidate(boolean validate) {
        if (validate && this.validator == null) {
            throw new RuntimeException("Error - no validator has been set");
        }
        this.validate = validate;
    }

    @Override
    public void setValidator(IValidator<T> validator) {
        this.validator = validator;
        if (validator != null) {
            this.validate = true;
        }
    }

    @Override
    public IPopulation<T> getPopulation() {
        return this.population;
    }
}

