/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.interactive;

import ga.core.algorithm.interactive.ISIGA;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.IMutationOp;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.logging.IGALogger;
import ga.core.selection.ISelector;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.logging.Logger;

public abstract class AbstractSIGA<T extends IIndividual<T>>
implements ISIGA<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractSIGA.class.getName());
    private final Thread accessThread;
    private final IGALogger<T> gaLogger;
    private final IPopulation<T> population;
    private final ISelector<T> selector;
    private final IInteractiveFitnessEvaluator<T> evaluator;
    private final IMutationOp<T> mutationOp;
    private final ICrossoverOp<T> crossoverOp;
    private IValidator<T> validator;
    private final GAContext context = new GAContext();
    private final IndividualList<T> evaluatingIndividuals = new IndividualList();
    private boolean validate;
    private final boolean useEliteStrategy;
    private int generation;

    public AbstractSIGA(IPopulation<T> population, IInteractiveFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, IValidator<T> validator, boolean useEliteStrategy, IGALogger<T> gaLogger) {
        this.population = population;
        this.selector = selector;
        this.evaluator = evaluator;
        this.mutationOp = mutateOperator;
        this.crossoverOp = crossoverOperator;
        this.gaLogger = gaLogger;
        this.setValidator(validator);
        this.useEliteStrategy = useEliteStrategy;
        evaluator.addEvaluationListener(this);
        evaluator.setAlgorithm(this);
        population.setEvaluator(evaluator);
        this.accessThread = Thread.currentThread();
    }

    @Override
    public void init() {
        this.checkThread();
        this.population.initRandomly(this.validate ? this.validator : null, this.context);
        if (this.gaLogger != null) {
            this.gaLogger.evaluationStarted();
            this.gaLogger.populationInitiated(this.generation, this.population);
        }
    }

    protected void checkThread() {
        if (!Thread.currentThread().equals(this.accessThread)) {
            LOGGER.warning("Multiple Threads are accessing this object! Creation thread: " + this.accessThread.getName() + " Current thread: " + Thread.currentThread().getName());
        }
    }

    protected IGALogger<T> getGALogger() {
        return this.gaLogger;
    }

    protected ISelector<T> getSelector() {
        return this.selector;
    }

    protected boolean isUseEliteStrategy() {
        return this.useEliteStrategy;
    }

    @Override
    public ICrossoverOp<T> getCrossoverOp() {
        return this.crossoverOp;
    }

    @Override
    public IMutationOp<T> getMutationOp() {
        return this.mutationOp;
    }

    protected IndividualList<T> getEvaluatingIndividuals() {
        return this.evaluatingIndividuals;
    }

    protected boolean isValidate() {
        return this.validate;
    }

    protected IValidator<T> getValidator() {
        return this.validator;
    }

    protected IInteractiveFitnessEvaluator<T> getEvaluator() {
        return this.evaluator;
    }

    @Override
    public void setValidate(boolean validate) {
        if (validate && this.validator == null) {
            throw new RuntimeException("Error - no validator has been set");
        }
        this.validate = validate;
    }

    @Override
    public void setValidator(IValidator<T> validator) {
        this.validator = validator;
        if (validator != null) {
            this.validate = true;
        }
    }

    @Override
    public IPopulation<T> getPopulation() {
        return this.population;
    }

    @Override
    public GAContext getContext() {
        return this.context;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    protected void incGeneration() {
        ++this.generation;
    }

    @Override
    public void exit() {
        if (this.gaLogger != null) {
            this.gaLogger.exit();
        }
    }
}

