/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.interactive;

import ga.core.algorithm.interactive.AbstractSIGA;
import ga.core.algorithm.util.RandomSingleton;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.IMutationOp;
import ga.core.individual.IClusterableIndividual;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IClusterPopulation;
import ga.core.individual.population.IPopulation;
import ga.core.logging.IGALogger;
import ga.core.selection.ISelector;
import ga.core.validation.IValidator;
import java.util.logging.Logger;

public class SIGAGeneration<T extends IIndividual<T>>
extends AbstractSIGA<T> {
    private static final Logger LOGGER = Logger.getLogger(SIGAGeneration.class.getName());
    private static final int CRITICAL_WHILE_ITERATIONS = 10000;

    public SIGAGeneration(IPopulation<T> population, IInteractiveFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, boolean useEliteStrategy) {
        this(population, evaluator, selector, mutateOperator, crossoverOperator, null, useEliteStrategy, null);
    }

    public SIGAGeneration(IPopulation<T> population, IInteractiveFitnessEvaluator<T> evaluator, ISelector<T> selector, IMutationOp<T> mutateOperator, ICrossoverOp<T> crossoverOperator, IValidator<T> validator, boolean useEliteStrategy, IGALogger<T> gaLogger) {
        super(population, evaluator, selector, mutateOperator, crossoverOperator, validator, useEliteStrategy, gaLogger);
    }

    @Override
    public void step() {
        this.checkThread();
        if (this.getGALogger() != null) {
            this.getGALogger().allIndividualsEvaluated(this.getGeneration(), this.getPopulation());
        }
        IndividualList nextGeneration = new IndividualList();
        while (nextGeneration.size() < this.getPopulation().size()) {
            IndividualList<T> newIndividuals = this.doReproduction();
            for (IIndividual newIndividual : newIndividuals) {
                if (!this.getPopulation().isAllowDuplicates() && nextGeneration.contains(newIndividual)) continue;
                nextGeneration.add(newIndividual);
            }
            while (nextGeneration.size() > this.getPopulation().size()) {
                nextGeneration.remove(0);
            }
        }
        if (this.isUseEliteStrategy()) {
            nextGeneration.set(0, this.getPopulation().getEliteIndividual().clone());
        }
        this.incGeneration();
        this.getPopulation().clear();
        this.getPopulation().addIndividuals(nextGeneration);
        if (this.getPopulation() instanceof IClusterPopulation) {
            ((IClusterPopulation)this.getPopulation()).doClustering();
        }
        if (this.getGALogger() != null) {
            this.getGALogger().individualsInserted(this.getGeneration(), nextGeneration, this.getPopulation());
        }
    }

    private IndividualList<T> doReproduction() {
        this.checkThread();
        IndividualList<Object> selectedIndividuals = this.getSelector().select(this.getPopulation());
        if (this.getGALogger() != null) {
            this.getGALogger().individualsSelected(this.getGeneration(), selectedIndividuals);
        }
        IIndividual ind1 = (IIndividual)selectedIndividuals.get(0);
        IIndividual ind2 = (IIndividual)selectedIndividuals.get(1);
        int whileCounter = 0;
        do {
            IIndividual mutatedIndividual;
            IIndividual ind;
            int i;
            IndividualList<IIndividual> newSelectedIndividuals;
            if ((newSelectedIndividuals = this.getCrossoverOp().crossover(ind1, ind2, this.getContext())) != null) {
                selectedIndividuals = newSelectedIndividuals;
                if (this.getGALogger() != null) {
                    this.getGALogger().individualsCrossed(this.getGeneration(), newSelectedIndividuals);
                }
            } else {
                LOGGER.warning("Crossover operation returned null");
            }
            for (i = 0; i < selectedIndividuals.size(); ++i) {
                ind = (IIndividual)selectedIndividuals.get(i);
                mutatedIndividual = this.getMutationOp().mutate(ind, this.getContext());
                if (mutatedIndividual != null) {
                    selectedIndividuals.set(i, mutatedIndividual);
                    continue;
                }
                LOGGER.warning("Mutation operation returned null");
            }
            if (this.getGALogger() != null) {
                this.getGALogger().individualsMutated(this.getGeneration(), selectedIndividuals);
            }
            if (++whileCounter <= 10000) continue;
            LOGGER.warning("Critical iterations exceeded. Endless loop? Individuals: " + ind1 + "   " + ind2);
            for (i = 0; i < selectedIndividuals.size(); ++i) {
                ind = (IIndividual)selectedIndividuals.get(i);
                mutatedIndividual = this.getMutationOp().mutate(ind, this.getContext());
                if (mutatedIndividual != null) {
                    selectedIndividuals.set(i, mutatedIndividual);
                    continue;
                }
                LOGGER.warning("Mutation operation returned null");
            }
        } while (this.isValidate() && this.getValidator() != null && !selectedIndividuals.isValid(this.getValidator(), this.getContext()));
        return selectedIndividuals;
    }

    @Override
    public void newIndividualRequested() {
        this.checkThread();
        IIndividual ind = null;
        int whileCounter = 0;
        if (!this.getPopulation().isEmpty()) {
            IndividualList list = this.getPopulation().getUnevaluatedIndividuals();
            LOGGER.info("New individual from population");
            if (list.size() == 0) {
                this.step();
                list = this.getPopulation().getUnevaluatedIndividuals();
            }
            do {
                ind = (IIndividual)list.get(RandomSingleton.getRandom().nextInt(list.size()));
                if (++whileCounter <= 10000) continue;
                LOGGER.warning("Critical iterations exceeded. Endless loop?");
            } while (this.getEvaluatingIndividuals().contains(ind));
            LOGGER.info("Evaluate " + ind);
        } else {
            LOGGER.warning("Your Population is too small");
            this.getPopulation().initRandomly(this.getValidator(), this.getContext());
            if (this.getGALogger() != null) {
                this.getGALogger().populationInitiated(this.getGeneration(), this.getPopulation());
            }
            do {
                ind = (IIndividual)this.getPopulation().getRandomIndividualForEvaluation();
                if (++whileCounter <= 10000) continue;
                LOGGER.warning("Critical iterations exceeded. Endless loop?");
            } while (this.getEvaluatingIndividuals().contains(ind));
        }
        if (this.getGALogger() != null) {
            this.getGALogger().individualSelectedForEvaluation(this.getGeneration(), ind);
        }
        this.getEvaluatingIndividuals().add(ind);
        this.getEvaluator().evaluate(ind);
        LOGGER.info("Current Population size: " + this.getPopulation().size());
        if (this.getPopulation().getUnevaluatedIndividuals().size() <= 1) {
            LOGGER.warning("This is the last individual for this generation!");
        }
    }

    @Override
    public void individualEvaluated(T ind) {
        this.checkThread();
        this.getEvaluatingIndividuals().remove(ind);
        if (this.getPopulation() instanceof IClusterPopulation) {
            if (ind instanceof IClusterableIndividual) {
                ((IClusterPopulation)this.getPopulation()).assignFitness((IClusterableIndividual)ind);
            } else {
                throw new RuntimeException(ind + " is not clusterable");
            }
        }
        if (this.getGALogger() != null) {
            this.getGALogger().individualEvaluated(this.getGeneration(), ind);
        }
        LOGGER.info("Current Population size: " + this.getPopulation().size());
    }
}

