/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.util;

import ga.core.individual.IClusterableIndividual;
import ga.core.individual.IFitness;
import ga.core.individual.IIndividual;
import ga.core.individual.IIntervalFitness;
import ga.core.validation.GAContext;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math.stat.clustering.Cluster;

public final class ClusterUtil {
    private ClusterUtil() {
    }

    public static <T extends IClusterableIndividual<T>> T calculateCentroid(Collection<T> c) {
        double minDist = Double.MAX_VALUE;
        IClusterableIndividual minP = null;
        for (IClusterableIndividual p1 : c) {
            double totalDist = 0.0;
            for (IClusterableIndividual p2 : c) {
                if (p2 == p1) continue;
                totalDist += p1.distanceFrom(p2);
            }
            if (!(totalDist < minDist)) continue;
            minDist = totalDist;
            minP = p1;
        }
        return (T)minP;
    }

    public static <T extends IClusterableIndividual<T>> void assignFitness(List<Cluster<T>> clusters, T ind) {
        for (Cluster<T> c : clusters) {
            if (!ind.equals(c.getCenter())) continue;
            if (ind instanceof IIntervalFitness) {
                ClusterUtil.assignIntervalFitness(c, (IIntervalFitness)((Object)ind));
            } else {
                ClusterUtil.assignNumericFitness(c, ind);
            }
            return;
        }
        throw new RuntimeException("something goes wrong");
    }

    public static <T extends IClusterableIndividual<T>, I extends IIntervalFitness> void assignIntervalFitness(Cluster<T> cluster, I ind) {
        double f0 = ind.getFitness();
        for (IClusterableIndividual i : cluster.getPoints()) {
            if (!(i instanceof IIntervalFitness)) continue;
            float maxIntervalWidth = 10.0f;
            GAContext context = ((IIndividual)((Object)ind)).getContext();
            if (context != null) {
                maxIntervalWidth = context.getFloat("IntervalFitnessMaxWidth", maxIntervalWidth).floatValue();
            }
            double w = i.distanceFrom((IClusterableIndividual)((Object)ind));
            ((IIntervalFitness)((Object)i)).setFitnessInterval(f0, (double)maxIntervalWidth * w);
        }
    }

    public static <T extends IClusterableIndividual<T>, I extends IFitness> void assignNumericFitness(Cluster<T> cluster, I ind) {
        for (IClusterableIndividual i : cluster.getPoints()) {
            i.setFitness(ind.getFitness());
        }
    }
}

