/*
 * Decompiled with CFR 0.152.
 */
package ga.core.algorithm.util;

import ga.core.individual.IIndividual;
import ga.core.individual.population.IPopulation;

public final class PopulationUtil {
    private PopulationUtil() {
    }

    public static double getMaxFitness(IPopulation<?> pop) {
        double max = Double.MIN_VALUE;
        for (IIndividual ind : pop.getIndividuals()) {
            if (!ind.isEvaluated() || !(ind.getFitness() > max)) continue;
            max = ind.getFitness();
        }
        return max;
    }

    public static double getMinFitness(IPopulation<?> pop) {
        double min = Double.MAX_VALUE;
        for (IIndividual ind : pop.getIndividuals()) {
            if (!ind.isEvaluated() || !(ind.getFitness() < min)) continue;
            min = ind.getFitness();
        }
        return min;
    }

    public static double getMeanFitness(IPopulation<?> pop) {
        double sum = 0.0;
        int count = 0;
        for (IIndividual ind : pop.getIndividuals()) {
            if (!ind.isEvaluated()) continue;
            sum += ind.getFitness();
            ++count;
        }
        return sum / (double)count;
    }

    public static double[] getMinMeanMaxFitness(IPopulation<?> pop) {
        double sum = 0.0;
        int count = 0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (IIndividual ind : pop.getIndividuals()) {
            if (!ind.isEvaluated()) continue;
            sum += ind.getFitness();
            ++count;
            if (ind.getFitness() < min) {
                min = ind.getFitness();
            }
            if (!(ind.getFitness() > max)) continue;
            max = ind.getFitness();
        }
        double mean = sum / (double)count;
        return new double[]{min, mean, max};
    }
}

