/*
 * Decompiled with CFR 0.152.
 */
package ga.core.evaluation;

import ga.core.evaluation.EvaluationListener;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractInteractiveEvaluator<T extends IIndividual<T>>
implements IInteractiveFitnessEvaluator<T> {
    private final List<EvaluationListener<T>> listeners = new ArrayList<EvaluationListener<T>>();

    @Override
    public void fireNewIndividualRequested() {
        for (EvaluationListener<T> l : this.listeners) {
            l.newIndividualRequested();
        }
    }

    @Override
    public void fireIndividualEvaluated(T individual) {
        for (EvaluationListener<T> l : this.listeners) {
            l.individualEvaluated(individual);
        }
    }

    @Override
    public void addEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.remove(listener);
    }
}

