/*
 * Decompiled with CFR 0.152.
 */
package ga.core.individual;

import ga.core.algorithm.util.RandomSingleton;
import ga.core.individual.IFitness;
import ga.core.individual.IIndividual;
import ga.core.individual.IIntervalFitness;
import ga.core.validation.GAContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

class IndividualComparator<T extends IIndividual<T>>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 6409241438814158534L;
    private final boolean descending;
    private final Random rnd = RandomSingleton.getRandom();

    public IndividualComparator(boolean descending) {
        this.descending = descending;
    }

    @Override
    public int compare(T o1, T o2) {
        int n;
        if (!o1.isEvaluated()) {
            if (!o2.isEvaluated()) {
                return 0;
            }
            return 1;
        }
        if (!o2.isEvaluated() && o1.isEvaluated()) {
            return -1;
        }
        if (o1 instanceof IIntervalFitness && o2 instanceof IIntervalFitness) {
            n = this.compareInterval((IIntervalFitness)o1, (IIntervalFitness)o2);
        } else if (o1 instanceof IFitness && o2 instanceof IFitness) {
            n = this.compareNumber((IFitness)o1, (IFitness)o2);
        } else {
            throw new RuntimeException("This individual has no fitness");
        }
        return this.descending ? -n : n;
    }

    private int compareNumber(IFitness o1, IFitness o2) {
        double d2;
        double d1 = o1.getFitness();
        return d1 < (d2 = o2.getFitness()) ? -1 : (d1 > d2 ? 1 : 0);
    }

    private int compareInterval(IIntervalFitness o1, IIntervalFitness o2) {
        double d = this.getDominationProbability(o1, o2);
        if (Math.abs(d - 0.5) < 1.0E-6) {
            return 0;
        }
        return this.rnd.nextDouble() < d ? 1 : -1;
    }

    private double getDominationProbability(IIntervalFitness o1, IIntervalFitness o2) {
        double d1 = o1.getFitness();
        double d1Min = o1.getMinFitness();
        double d1Max = o1.getMaxFitness();
        double d1Width = o1.getFitnessWidth();
        double d2 = o2.getFitness();
        double d2Min = o2.getMinFitness();
        double d2Max = o2.getMaxFitness();
        double d2Width = o2.getFitnessWidth();
        if (d1Width == 0.0 && d2Width == 0.0) {
            if (d1 == d2) {
                return 0.5;
            }
            return d1 > d2 ? 1.0 : 0.0;
        }
        if (d1Max > d2Max) {
            if (d1Min >= d2Max) {
                return 1.0;
            }
            return 1.0 - 0.5 * ((d2Max - d1Min) / d2Width) * ((d2Max - d1Min) / d1Width);
        }
        if (d1Max <= d2Max && d1Min >= d2Min) {
            return 0.5 * d1Width / d2Width + (d1Min - d2Min) / d2Width;
        }
        return 0.5 * d2Width / d1Width + (d2Min - d1Min) / d1Width;
    }

    public static void main(String[] args) {
        IndividualComparator<TestInterval> cmp = new IndividualComparator<TestInterval>(true);
        TestInterval x1 = new TestInterval("x1");
        TestInterval x2 = new TestInterval("x2");
        ArrayList<TestInterval> list = new ArrayList<TestInterval>();
        list.add(x1);
        list.add(x2);
        x1.setFitnessLimits(3.0, 6.0);
        x2.setFitnessLimits(0.0, 3.0);
        double p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 1: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(1.0, 5.0);
        x2.setFitnessLimits(0.0, 3.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 2: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(0.0, 3.0);
        x2.setFitnessLimits(0.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 3: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(3.0, 6.0);
        x2.setFitnessLimits(0.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 4: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(0.0, 6.0);
        x2.setFitnessLimits(0.0, 3.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 5: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(0.0, 6.0);
        x2.setFitnessLimits(3.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 6: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(2.0, 4.0);
        x2.setFitnessLimits(0.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 7: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(0.0, 0.0);
        x2.setFitnessLimits(0.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 8: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(3.0, 3.0);
        x2.setFitnessLimits(0.0, 6.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 9: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(10.0, 10.0);
        x2.setFitnessLimits(0.0, 10.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 10: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(0.0, 0.0);
        x2.setFitnessLimits(3.0, 3.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 11: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(3.0, 3.0);
        x2.setFitnessLimits(3.0, 3.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 12: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
        x1.setFitnessLimits(6.0, 6.0);
        x2.setFitnessLimits(3.0, 3.0);
        p = super.getDominationProbability(x1, x2);
        System.err.println();
        System.err.println("Test 13: " + p);
        System.err.println("Sorting: " + cmp.compare(x1, x2));
        Collections.sort(list, cmp);
        System.err.println(list);
    }

    static {
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
    }

    private static class TestInterval
    implements IIntervalFitness,
    IIndividual<TestInterval> {
        private double min;
        private double max;
        private double center;
        private final String name;

        public TestInterval(String name) {
            this.name = name;
        }

        @Override
        public void setFitness(double fitness) {
            this.center = fitness;
        }

        @Override
        public double getFitness() {
            return this.center;
        }

        @Override
        public double getMinFitness() {
            return this.min;
        }

        @Override
        public double getMaxFitness() {
            return this.max;
        }

        @Override
        public double getFitnessWidth() {
            return this.max - this.min;
        }

        @Override
        public void setFitnessInterval(double center, double width) {
            this.center = center;
            this.min = center - width / 2.0;
            this.max = this.min + width;
        }

        @Override
        public void setFitnessLimits(double min, double max) {
            this.min = min;
            this.max = max;
            this.center = (max + min) / 2.0;
        }

        @Override
        public void initRandomly() {
        }

        @Override
        public boolean isEvaluated() {
            return false;
        }

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public void setContext(GAContext context) {
        }

        @Override
        public GAContext getContext() {
            return null;
        }

        @Override
        public TestInterval clone() {
            return new TestInterval(this.name);
        }

        public String toString() {
            return this.name + " [" + this.min + ";" + this.max + "]";
        }
    }
}

