/*
 * Decompiled with CFR 0.152.
 */
package ga.core.individual;

import ga.core.individual.IIndividual;
import ga.core.individual.IndividualComparator;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class IndividualList<T extends IIndividual<T>>
extends ArrayList<T> {
    public IndividualList() {
    }

    public IndividualList(Collection<? extends T> c) {
        super(c);
    }

    public void sort(boolean descending) {
        boolean ok = true;
        do {
            try {
                Collections.sort(this, new IndividualComparator(descending));
            }
            catch (IllegalArgumentException e) {
                ok = false;
            }
        } while (!ok);
    }

    public boolean isValid(IValidator<T> validator, GAContext context) {
        if (validator != null) {
            for (IIndividual individual : this) {
                if (validator.isValid(individual, context)) continue;
                return false;
            }
        }
        return true;
    }
}

