/*
 * Decompiled with CFR 0.152.
 */
package ga.core.individual.population;

import ga.core.algorithm.util.RandomSingleton;
import ga.core.evaluation.IFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.core.individual.IIndividualFactory;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.Iterator;
import java.util.Random;

public class ArrayListPopulation<T extends IIndividual<T>>
implements IPopulation<T> {
    private final IndividualList<T> pop = new IndividualList();
    private final IIndividualFactory<T> factory;
    private IFitnessEvaluator<T> evaluator;
    private boolean allowDuplicates;
    private final Random rnd = RandomSingleton.getRandom();
    private int initIndividualCount = 40;

    public ArrayListPopulation(IIndividualFactory<T> factory, int initIndividualCount) {
        this(factory, initIndividualCount, true);
    }

    public ArrayListPopulation(IIndividualFactory<T> factory, int initIndividualCount, boolean allowDuplicates) {
        this.factory = factory;
        this.initIndividualCount = initIndividualCount;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public void setEvaluator(IFitnessEvaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void initRandomly(IValidator<T> validator, GAContext context) {
        try {
            IIndividual template = (IIndividual)context.get("InitIndividual");
            if (template != null && validator.isValid(template, context)) {
                int percentage = context.getInt("InitIndividualPercentage", 1);
                int count = Math.min(Math.max(percentage * this.initIndividualCount / 100, 1), 100);
                for (int i = 0; i < count; ++i) {
                    this.pop.add(template);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (this.pop.size() < this.initIndividualCount) {
            T ind = this.factory.newIndividual(context);
            do {
                ind.initRandomly();
            } while (validator != null && !validator.isValid((IIndividual)ind, context));
            this.pop.add(ind);
        }
    }

    @Override
    public IndividualList<T> getIndividuals() {
        return this.pop;
    }

    @Override
    public void addIndividuals(T ... individuals) {
        for (T ind : individuals) {
            if (!this.allowDuplicates && this.pop.contains(ind)) continue;
            this.pop.add(ind);
        }
    }

    @Override
    public void addIndividual(T individual) {
        if (this.allowDuplicates || !this.pop.contains(individual)) {
            this.pop.add(individual);
        }
    }

    @Override
    public void addIndividuals(IndividualList<T> individuals) {
        for (IIndividual ind : individuals) {
            if (!this.allowDuplicates && this.pop.contains(ind)) continue;
            this.pop.add(ind);
        }
    }

    @Override
    public void clear() {
        this.pop.clear();
    }

    @Override
    public void evaluateAutomatic() {
        for (IIndividual ind : this.pop) {
            if (ind.isEvaluated()) continue;
            this.evaluator.evaluate(ind);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IIndividual ind : this.pop) {
            sb.append(ind);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.pop.size();
    }

    @Override
    public T getUnfittestIndividual() {
        if (this.pop.size() == 0) {
            return null;
        }
        this.pop.sort(false);
        return (T)((IIndividual)this.pop.get(0));
    }

    @Override
    public T getFittestIndividual() {
        if (this.pop.size() == 0) {
            return null;
        }
        this.pop.sort(true);
        return (T)((IIndividual)this.pop.get(0));
    }

    @Override
    public T getEliteIndividual() {
        return this.getFittestIndividual();
    }

    @Override
    public T getRandomIndividualForEvaluation() {
        return (T)((IIndividual)this.pop.get(this.rnd.nextInt(this.pop.size())));
    }

    @Override
    public T getRandomIndividualForSelection() {
        return this.getRandomIndividualForEvaluation();
    }

    @Override
    public IndividualList<T> getUnevaluatedIndividuals() {
        IndividualList list = new IndividualList();
        for (IIndividual ind : this.pop) {
            if (ind.isEvaluated()) continue;
            list.add(ind);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.pop.isEmpty();
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int getEvaluatedIndividualCount() {
        int i = 0;
        for (IIndividual ind : this.pop) {
            if (!ind.isEvaluated()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public boolean containsAny(IndividualList<T> list) {
        for (IIndividual ind : list) {
            if (!this.pop.contains(ind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pop.iterator();
    }

    @Override
    public int getInitIndividualCount() {
        return this.initIndividualCount;
    }

    @Override
    public void setInitIndividualCount(int individualCount) {
        this.initIndividualCount = individualCount;
    }
}

