/*
 * Decompiled with CFR 0.152.
 */
package ga.core.individual.population;

import ga.core.algorithm.util.ClusterUtil;
import ga.core.algorithm.util.RandomSingleton;
import ga.core.evaluation.IFitnessEvaluator;
import ga.core.individual.IClusterableIndividual;
import ga.core.individual.IDebugInfo;
import ga.core.individual.IIndividualFactory;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IClusterPopulation;
import ga.core.validation.GAContext;
import ga.core.validation.IValidator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.stat.clustering.Cluster;
import org.apache.commons.math.stat.clustering.KMeansPlusPlusClusterer;

public class KMeansClusterPopulation<T extends IClusterableIndividual<T>>
implements IClusterPopulation<T> {
    private static final Logger LOGGER = Logger.getLogger(KMeansClusterPopulation.class.getName());
    private static final int MAX_ITERATIONS = 100;
    private final IndividualList<T> pop = new IndividualList();
    private final IIndividualFactory<T> factory;
    private IFitnessEvaluator<T> evaluator;
    private boolean allowDuplicates;
    private final Random rnd = RandomSingleton.getRandom();
    private int initIndividualCount = 100;
    private int clusterCount = 10;
    private List<Cluster<T>> clusters;
    private final KMeansPlusPlusClusterer<T> clusterer;

    public KMeansClusterPopulation(IIndividualFactory<T> factory, int initIndividualCount, int clusterCount) {
        this(factory, initIndividualCount, clusterCount, true);
    }

    public KMeansClusterPopulation(IIndividualFactory<T> factory, int initIndividualCount, int clusterCount, boolean allowDuplicates) {
        this.factory = factory;
        this.initIndividualCount = initIndividualCount;
        this.clusterCount = clusterCount;
        this.allowDuplicates = allowDuplicates;
        this.clusterer = new KMeansPlusPlusClusterer(RandomSingleton.getRandom());
    }

    @Override
    public void setEvaluator(IFitnessEvaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void initRandomly(IValidator<T> validator, GAContext context) {
        try {
            IClusterableIndividual template = (IClusterableIndividual)context.get("InitIndividual");
            if (template != null && validator.isValid(template, context)) {
                int percentage = context.getInt("InitIndividualPercentage", 1);
                int count = Math.min(Math.max(percentage * this.initIndividualCount / 100, 1), 100);
                for (int i = 0; i < count; ++i) {
                    this.pop.add(template);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (this.pop.size() < this.initIndividualCount) {
            IClusterableIndividual ind = (IClusterableIndividual)this.factory.newIndividual(context);
            do {
                ind.initRandomly();
            } while (validator != null && !validator.isValid(ind, context));
            this.pop.add(ind);
        }
        this.doClustering();
    }

    @Override
    public IndividualList<T> getIndividuals() {
        return this.pop;
    }

    @Override
    public void addIndividuals(T ... individuals) {
        for (T ind : individuals) {
            if (!this.allowDuplicates && this.pop.contains(ind)) continue;
            this.pop.add(ind);
        }
    }

    @Override
    public void addIndividual(T individual) {
        if (this.allowDuplicates || !this.pop.contains(individual)) {
            this.pop.add(individual);
        }
    }

    @Override
    public void addIndividuals(IndividualList<T> individuals) {
        for (IClusterableIndividual ind : individuals) {
            if (!this.allowDuplicates && this.pop.contains(ind)) continue;
            this.pop.add(ind);
        }
    }

    @Override
    public void clear() {
        this.pop.clear();
        this.clusters.clear();
    }

    @Override
    public void evaluateAutomatic() {
        if (this.clusters == null || this.clusters.isEmpty()) {
            this.doClustering();
        }
        for (Cluster<T> c : this.clusters) {
            IClusterableIndividual ind = (IClusterableIndividual)c.getCenter();
            if (ind.isEvaluated()) continue;
            this.evaluator.evaluate(ind);
        }
        this.assignFitness();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IClusterableIndividual ind : this.pop) {
            sb.append(ind);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.pop.size();
    }

    @Override
    public T getUnfittestIndividual() {
        if (this.pop.size() == 0) {
            return null;
        }
        this.pop.sort(false);
        return (T)((IClusterableIndividual)this.pop.get(0));
    }

    @Override
    public T getFittestIndividual() {
        if (this.pop.size() == 0) {
            return null;
        }
        this.pop.sort(true);
        return (T)((IClusterableIndividual)this.pop.get(0));
    }

    @Override
    public T getEliteIndividual() {
        IClusterableIndividual ind = (IClusterableIndividual)this.clusters.get(0).getCenter();
        for (Cluster<T> c : this.clusters) {
            IClusterableIndividual t = (IClusterableIndividual)c.getCenter();
            if (!(t.getFitness() > ind.getFitness())) continue;
            ind = t;
        }
        return (T)ind;
    }

    @Override
    public T getRandomIndividualForEvaluation() {
        return (T)((IClusterableIndividual)this.clusters.get(this.rnd.nextInt(this.clusters.size())).getCenter());
    }

    @Override
    public T getRandomIndividualForSelection() {
        return (T)((IClusterableIndividual)this.pop.get(this.rnd.nextInt(this.pop.size())));
    }

    @Override
    public IndividualList<T> getUnevaluatedIndividuals() {
        IndividualList list = new IndividualList();
        for (Cluster<T> c : this.clusters) {
            IClusterableIndividual ind = (IClusterableIndividual)c.getCenter();
            if (ind.isEvaluated()) continue;
            list.add(ind);
        }
        return list;
    }

    public String toClusterString() {
        if (this.clusters == null || this.clusters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Cluster<T> c : this.clusters) {
            boolean first = true;
            IClusterableIndividual center = (IClusterableIndividual)c.getCenter();
            if (center instanceof IDebugInfo) {
                sb.append(center.getId() + ": " + ((IDebugInfo)((Object)center)).getGenotypeString());
            } else {
                sb.append(center.toString());
            }
            for (IClusterableIndividual ind : c.getPoints()) {
                if (ind.equals(center)) continue;
                sb.append(", ");
                if (ind instanceof IDebugInfo) {
                    sb.append(ind.getId() + ": " + ((IDebugInfo)((Object)ind)).getGenotypeString());
                    continue;
                }
                sb.append(ind.toString());
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.pop.isEmpty();
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int getEvaluatedIndividualCount() {
        int i = 0;
        for (IClusterableIndividual ind : this.pop) {
            if (!ind.isEvaluated()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public boolean containsAny(IndividualList<T> list) {
        for (IClusterableIndividual ind : list) {
            if (!this.pop.contains(ind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pop.iterator();
    }

    @Override
    public int getInitIndividualCount() {
        return this.initIndividualCount;
    }

    @Override
    public void setInitIndividualCount(int individualCount) {
        this.initIndividualCount = individualCount;
    }

    @Override
    public void assignFitness(T ind) {
        ClusterUtil.assignFitness(this.clusters, ind);
    }

    @Override
    public void assignFitness() {
        for (Cluster<T> c : this.clusters) {
            this.assignFitness((IClusterableIndividual)c.getCenter());
        }
    }

    @Override
    public void doClustering() {
        try {
            this.clusters = this.clusterer.cluster(this.pop, this.clusterCount, 100);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Clustering failed. Population size: " + this.pop.size() + ", cluster count: " + this.clusterCount + ", Max iterations: " + 100, e);
        }
    }
}

