/*
 * Decompiled with CFR 0.152.
 */
package ga.core.selection;

import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.selection.ISelector;

public class TournamentSelector<T extends IIndividual<T>>
implements ISelector<T> {
    private static final int SELECTED_INDIVIDUALS = 2;
    private int tournamentSize = 3;
    private boolean replaceOldOnInsert = true;
    private final boolean allowDuplicates = true;

    public TournamentSelector(int tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    @Override
    public IndividualList<T> select(IPopulation<T> population) {
        if (population.size() < this.tournamentSize) {
            throw new RuntimeException("There are not enough individuals to select");
        }
        IndividualList list = new IndividualList();
        while (list.size() <= this.tournamentSize) {
            T ind = population.getRandomIndividualForSelection();
            if (!ind.isEvaluated()) continue;
            list.add(ind);
        }
        list.sort(false);
        while (list.size() > 2) {
            list.remove(0);
        }
        if (list.size() != 2) {
            throw new RuntimeException("Wrong list size");
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ((IIndividual)list.get(i)).clone());
        }
        return list;
    }

    public void setReplaceOldOnInsert(boolean replaceOldOnInsert) {
        this.replaceOldOnInsert = replaceOldOnInsert;
    }

    public void setTournamentSize(int tournamentSize) {
        this.tournamentSize = tournamentSize;
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    @Override
    public void insert(IndividualList<T> list, IPopulation<T> population, boolean useEliteStrategy) {
        if (list.size() != 2) {
            throw new RuntimeException("Wrong list size");
        }
        if (this.replaceOldOnInsert) {
            population.getIndividuals().sort(false);
            for (int i = 0; i < list.size(); ++i) {
                population.getIndividuals().set(i, list.get(i));
            }
        } else {
            population.addIndividuals(list);
        }
    }
}

