/*
 * Decompiled with CFR 0.152.
 */
package ga.core.validation;

import ga.core.individual.IIndividual;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;
import ga.core.validation.IValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuleValidator<T extends IIndividual<T>>
implements IValidator<T> {
    private static final Logger LOGGER = Logger.getLogger(RuleValidator.class.getName());
    private final List<IValidationRule<T>> mandatoryRules = new ArrayList<IValidationRule<T>>();
    private final List<IValidationRule<T>> proposedRules = new ArrayList<IValidationRule<T>>();
    private final List<IValidationRule<T>> perfectionRules = new ArrayList<IValidationRule<T>>();
    private final float mandatoryThreshold = 1.0f;
    private final float proposedThreshold = 0.5f;
    private final float perfectionThreshold = 0.3f;

    public void addRule(IValidationRule<T> rule) {
        switch (rule.getType()) {
            case MANDATORY: {
                this.mandatoryRules.add(rule);
                break;
            }
            case PROPOSED: {
                this.proposedRules.add(rule);
                break;
            }
            case PERFECTION: {
                this.perfectionRules.add(rule);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("added rule " + (Object)((Object)rule.getType()) + " " + rule.getClass().getName());
        }
    }

    @Override
    public boolean isValid(T individual, GAContext context) {
        for (IValidationRule<T> rule : this.mandatoryRules) {
            if (!(rule.matchingDegree(individual, context) < 1.0f)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("individual did not match rule " + rule);
            }
            return false;
        }
        for (IValidationRule<T> rule : this.proposedRules) {
            if (!(rule.matchingDegree(individual, context) < 0.5f)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("individual did not match rule " + rule);
            }
            return false;
        }
        for (IValidationRule<T> rule : this.perfectionRules) {
            if (!(rule.matchingDegree(individual, context) < 0.3f)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("individual did not match rule " + rule);
            }
            return false;
        }
        return true;
    }
}

