/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.lwjgl;

import com.jme3.light.LightList;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.IDList;
import com.jme3.renderer.RenderContext;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.lwjgl.TextureUtil;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.ListMap;
import com.jme3.util.NativeObject;
import com.jme3.util.NativeObjectManager;
import com.jme3.util.SafeArrayList;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.MipMapGenerator;
import jme3tools.shader.ShaderDebug;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBTextureMultisample;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferBlit;
import org.lwjgl.opengl.EXTFramebufferMultisample;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LwjglRenderer
implements Renderer {
    private static final Logger logger = Logger.getLogger(LwjglRenderer.class.getName());
    private static final boolean VALIDATE_SHADER = false;
    private final ByteBuffer nameBuf = BufferUtils.createByteBuffer((int)250);
    private final StringBuilder stringBuf = new StringBuilder(250);
    private final IntBuffer intBuf1 = BufferUtils.createIntBuffer((int)1);
    private final IntBuffer intBuf16 = BufferUtils.createIntBuffer((int)16);
    private final RenderContext context = new RenderContext();
    private final NativeObjectManager objManager = new NativeObjectManager();
    private final EnumSet<Caps> caps = EnumSet.noneOf(Caps.class);
    private Shader boundShader;
    private int initialDrawBuf;
    private int initialReadBuf;
    private int glslVer;
    private int vertexTextureUnits;
    private int fragTextureUnits;
    private int vertexUniforms;
    private int fragUniforms;
    private int vertexAttribs;
    private int maxFBOSamples;
    private int maxFBOAttachs;
    private int maxMRTFBOAttachs;
    private int maxRBSize;
    private int maxTexSize;
    private int maxCubeTexSize;
    private int maxVertCount;
    private int maxTriCount;
    private int maxColorTexSamples;
    private int maxDepthTexSamples;
    private FrameBuffer lastFb = null;
    private FrameBuffer mainFbOverride = null;
    private final Statistics statistics = new Statistics();
    private int vpX;
    private int vpY;
    private int vpW;
    private int vpH;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;

    protected void updateNameBuffer() {
        int len = this.stringBuf.length();
        this.nameBuf.position(0);
        this.nameBuf.limit(len);
        for (int i = 0; i < len; ++i) {
            this.nameBuf.put((byte)this.stringBuf.charAt(i));
        }
        this.nameBuf.rewind();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public EnumSet<Caps> getCaps() {
        return this.caps;
    }

    public void initialize() {
        ContextCapabilities ctxCaps = GLContext.getCapabilities();
        if (ctxCaps.OpenGL20) {
            this.caps.add(Caps.OpenGL20);
            if (ctxCaps.OpenGL21) {
                this.caps.add(Caps.OpenGL21);
                if (ctxCaps.OpenGL30) {
                    this.caps.add(Caps.OpenGL30);
                    if (ctxCaps.OpenGL31) {
                        this.caps.add(Caps.OpenGL31);
                        if (ctxCaps.OpenGL32) {
                            this.caps.add(Caps.OpenGL32);
                        }
                    }
                }
            }
        }
        String versionStr = null;
        if (ctxCaps.OpenGL20) {
            versionStr = GL11.glGetString((int)35724);
        }
        if (versionStr == null || versionStr.equals("")) {
            this.glslVer = -1;
            throw new UnsupportedOperationException("GLSL and OpenGL2 is required for the LWJGL renderer!");
        }
        this.initialDrawBuf = GL11.glGetInteger((int)3073);
        this.initialReadBuf = GL11.glGetInteger((int)3074);
        int spaceIdx = versionStr.indexOf(" ");
        if (spaceIdx >= 1) {
            versionStr = versionStr.substring(0, spaceIdx);
        }
        float version = Float.parseFloat(versionStr);
        this.glslVer = (int)(version * 100.0f);
        switch (this.glslVer) {
            default: {
                if (this.glslVer < 400) break;
            }
            case 150: 
            case 330: 
            case 400: {
                this.caps.add(Caps.GLSL150);
            }
            case 140: {
                this.caps.add(Caps.GLSL140);
            }
            case 130: {
                this.caps.add(Caps.GLSL130);
            }
            case 120: {
                this.caps.add(Caps.GLSL120);
            }
            case 110: {
                this.caps.add(Caps.GLSL110);
            }
            case 100: {
                this.caps.add(Caps.GLSL100);
            }
        }
        if (!this.caps.contains(Caps.GLSL100)) {
            logger.log(Level.WARNING, "Force-adding GLSL100 support, since OpenGL2 is supported.");
            this.caps.add(Caps.GLSL100);
        }
        GL11.glGetInteger((int)35660, (IntBuffer)this.intBuf16);
        this.vertexTextureUnits = this.intBuf16.get(0);
        logger.log(Level.FINER, "VTF Units: {0}", this.vertexTextureUnits);
        if (this.vertexTextureUnits > 0) {
            this.caps.add(Caps.VertexTextureFetch);
        }
        GL11.glGetInteger((int)34930, (IntBuffer)this.intBuf16);
        this.fragTextureUnits = this.intBuf16.get(0);
        logger.log(Level.FINER, "Texture Units: {0}", this.fragTextureUnits);
        GL11.glGetInteger((int)35658, (IntBuffer)this.intBuf16);
        this.vertexUniforms = this.intBuf16.get(0);
        logger.log(Level.FINER, "Vertex Uniforms: {0}", this.vertexUniforms);
        GL11.glGetInteger((int)35657, (IntBuffer)this.intBuf16);
        this.fragUniforms = this.intBuf16.get(0);
        logger.log(Level.FINER, "Fragment Uniforms: {0}", this.fragUniforms);
        GL11.glGetInteger((int)34921, (IntBuffer)this.intBuf16);
        this.vertexAttribs = this.intBuf16.get(0);
        logger.log(Level.FINER, "Vertex Attributes: {0}", this.vertexAttribs);
        GL11.glGetInteger((int)3408, (IntBuffer)this.intBuf16);
        int subpixelBits = this.intBuf16.get(0);
        logger.log(Level.FINER, "Subpixel Bits: {0}", subpixelBits);
        GL11.glGetInteger((int)33000, (IntBuffer)this.intBuf16);
        this.maxVertCount = this.intBuf16.get(0);
        logger.log(Level.FINER, "Preferred Batch Vertex Count: {0}", this.maxVertCount);
        GL11.glGetInteger((int)33001, (IntBuffer)this.intBuf16);
        this.maxTriCount = this.intBuf16.get(0);
        logger.log(Level.FINER, "Preferred Batch Index Count: {0}", this.maxTriCount);
        GL11.glGetInteger((int)3379, (IntBuffer)this.intBuf16);
        this.maxTexSize = this.intBuf16.get(0);
        logger.log(Level.FINER, "Maximum Texture Resolution: {0}", this.maxTexSize);
        GL11.glGetInteger((int)34076, (IntBuffer)this.intBuf16);
        this.maxCubeTexSize = this.intBuf16.get(0);
        logger.log(Level.FINER, "Maximum CubeMap Resolution: {0}", this.maxCubeTexSize);
        if (ctxCaps.GL_ARB_color_buffer_float && ctxCaps.GL_ARB_half_float_pixel) {
            this.caps.add(Caps.FloatColorBuffer);
        }
        if (ctxCaps.GL_ARB_depth_buffer_float) {
            this.caps.add(Caps.FloatDepthBuffer);
        }
        if (ctxCaps.OpenGL30) {
            this.caps.add(Caps.PackedDepthStencilBuffer);
        }
        if (ctxCaps.GL_ARB_draw_instanced) {
            this.caps.add(Caps.MeshInstancing);
        }
        if (ctxCaps.GL_ARB_fragment_program) {
            this.caps.add(Caps.ARBprogram);
        }
        if (ctxCaps.GL_ARB_texture_buffer_object) {
            this.caps.add(Caps.TextureBuffer);
        }
        if (ctxCaps.GL_ARB_texture_float && ctxCaps.GL_ARB_half_float_pixel) {
            this.caps.add(Caps.FloatTexture);
        }
        if (ctxCaps.GL_ARB_vertex_array_object) {
            this.caps.add(Caps.VertexBufferArray);
        }
        if (ctxCaps.GL_ARB_texture_non_power_of_two) {
            this.caps.add(Caps.NonPowerOfTwoTextures);
        } else {
            logger.log(Level.WARNING, "Your graphics card does not support non-power-of-2 textures. Some features might not work.");
        }
        boolean latc = ctxCaps.GL_EXT_texture_compression_latc;
        if (latc) {
            this.caps.add(Caps.TextureCompressionLATC);
        }
        if (ctxCaps.GL_EXT_packed_float) {
            this.caps.add(Caps.PackedFloatColorBuffer);
            if (ctxCaps.GL_ARB_half_float_pixel) {
                this.caps.add(Caps.PackedFloatTexture);
            }
        }
        if (ctxCaps.GL_EXT_texture_array) {
            this.caps.add(Caps.TextureArray);
        }
        if (ctxCaps.GL_EXT_texture_shared_exponent) {
            this.caps.add(Caps.SharedExponentTexture);
        }
        if (ctxCaps.GL_EXT_framebuffer_object) {
            this.caps.add(Caps.FrameBuffer);
            GL11.glGetInteger((int)34024, (IntBuffer)this.intBuf16);
            this.maxRBSize = this.intBuf16.get(0);
            logger.log(Level.FINER, "FBO RB Max Size: {0}", this.maxRBSize);
            GL11.glGetInteger((int)36063, (IntBuffer)this.intBuf16);
            this.maxFBOAttachs = this.intBuf16.get(0);
            logger.log(Level.FINER, "FBO Max renderbuffers: {0}", this.maxFBOAttachs);
            if (ctxCaps.GL_EXT_framebuffer_multisample) {
                this.caps.add(Caps.FrameBufferMultisample);
                GL11.glGetInteger((int)36183, (IntBuffer)this.intBuf16);
                this.maxFBOSamples = this.intBuf16.get(0);
                logger.log(Level.FINER, "FBO Max Samples: {0}", this.maxFBOSamples);
            }
            if (ctxCaps.GL_ARB_texture_multisample) {
                this.caps.add(Caps.TextureMultisample);
                GL11.glGetInteger((int)37134, (IntBuffer)this.intBuf16);
                this.maxColorTexSamples = this.intBuf16.get(0);
                logger.log(Level.FINER, "Texture Multisample Color Samples: {0}", this.maxColorTexSamples);
                GL11.glGetInteger((int)37135, (IntBuffer)this.intBuf16);
                this.maxDepthTexSamples = this.intBuf16.get(0);
                logger.log(Level.FINER, "Texture Multisample Depth Samples: {0}", this.maxDepthTexSamples);
            }
            GL11.glGetInteger((int)34852, (IntBuffer)this.intBuf16);
            this.maxMRTFBOAttachs = this.intBuf16.get(0);
            if (this.maxMRTFBOAttachs > 1) {
                this.caps.add(Caps.FrameBufferMRT);
                logger.log(Level.FINER, "FBO Max MRT renderbuffers: {0}", this.maxMRTFBOAttachs);
            }
        }
        if (ctxCaps.GL_ARB_multisample) {
            GL11.glGetInteger((int)32936, (IntBuffer)this.intBuf16);
            boolean available = this.intBuf16.get(0) != 0;
            GL11.glGetInteger((int)32937, (IntBuffer)this.intBuf16);
            int samples = this.intBuf16.get(0);
            logger.log(Level.FINER, "Samples: {0}", samples);
            boolean enabled = GL11.glIsEnabled((int)32925);
            if (samples > 0 && available && !enabled) {
                GL11.glEnable((int)32925);
            }
            this.caps.add(Caps.Multisample);
        }
        logger.log(Level.INFO, "Caps: {0}", this.caps);
    }

    public void invalidateState() {
        this.context.reset();
        this.boundShader = null;
        this.lastFb = null;
        this.initialDrawBuf = GL11.glGetInteger((int)3073);
        this.initialReadBuf = GL11.glGetInteger((int)3074);
    }

    public void resetGLObjects() {
        logger.log(Level.INFO, "Reseting objects and invalidating state");
        this.objManager.resetObjects();
        this.statistics.clearMemory();
        this.invalidateState();
    }

    public void cleanup() {
        logger.log(Level.INFO, "Deleting objects and invalidating state");
        this.objManager.deleteAllObjects((Object)this);
        this.statistics.clearMemory();
        this.invalidateState();
    }

    private void checkCap(Caps cap) {
        if (!this.caps.contains(cap)) {
            throw new UnsupportedOperationException("Required capability missing: " + cap.name());
        }
    }

    public void setDepthRange(float start, float end) {
        GL11.glDepthRange((double)start, (double)end);
    }

    public void clearBuffers(boolean color, boolean depth, boolean stencil) {
        int bits = 0;
        if (color) {
            if (!this.context.colorWriteEnabled) {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.context.colorWriteEnabled = true;
            }
            bits = 16384;
        }
        if (depth) {
            if (!this.context.depthWriteEnabled) {
                GL11.glDepthMask((boolean)true);
                this.context.depthWriteEnabled = true;
            }
            bits |= 0x100;
        }
        if (stencil) {
            bits |= 0x400;
        }
        if (bits != 0) {
            GL11.glClear((int)bits);
        }
    }

    public void setBackgroundColor(ColorRGBA color) {
        GL11.glClearColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
    }

    public void setAlphaToCoverage(boolean value) {
        if (this.caps.contains(Caps.Multisample)) {
            if (value) {
                GL11.glEnable((int)32926);
            } else {
                GL11.glDisable((int)32926);
            }
        }
    }

    public void applyRenderState(RenderState state) {
        if (state.isWireframe() && !this.context.wireframe) {
            GL11.glPolygonMode((int)1032, (int)6913);
            this.context.wireframe = true;
        } else if (!state.isWireframe() && this.context.wireframe) {
            GL11.glPolygonMode((int)1032, (int)6914);
            this.context.wireframe = false;
        }
        if (state.isDepthTest() && !this.context.depthTestEnabled) {
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)515);
            this.context.depthTestEnabled = true;
        } else if (!state.isDepthTest() && this.context.depthTestEnabled) {
            GL11.glDisable((int)2929);
            this.context.depthTestEnabled = false;
        }
        if (state.isAlphaTest() && !this.context.alphaTestEnabled) {
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)state.getAlphaFallOff());
            this.context.alphaTestEnabled = true;
        } else if (!state.isAlphaTest() && this.context.alphaTestEnabled) {
            GL11.glDisable((int)3008);
            this.context.alphaTestEnabled = false;
        }
        if (state.isDepthWrite() && !this.context.depthWriteEnabled) {
            GL11.glDepthMask((boolean)true);
            this.context.depthWriteEnabled = true;
        } else if (!state.isDepthWrite() && this.context.depthWriteEnabled) {
            GL11.glDepthMask((boolean)false);
            this.context.depthWriteEnabled = false;
        }
        if (state.isColorWrite() && !this.context.colorWriteEnabled) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            this.context.colorWriteEnabled = true;
        } else if (!state.isColorWrite() && this.context.colorWriteEnabled) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.context.colorWriteEnabled = false;
        }
        if (state.isPointSprite() && !this.context.pointSprite) {
            if (this.context.boundTextures[0] != null) {
                if (this.context.boundTextureUnit != 0) {
                    GL13.glActiveTexture((int)33984);
                    this.context.boundTextureUnit = 0;
                }
                GL11.glEnable((int)34913);
                GL11.glEnable((int)34370);
            }
            this.context.pointSprite = true;
        } else if (!state.isPointSprite() && this.context.pointSprite && this.context.boundTextures[0] != null) {
            if (this.context.boundTextureUnit != 0) {
                GL13.glActiveTexture((int)33984);
                this.context.boundTextureUnit = 0;
            }
            GL11.glDisable((int)34913);
            GL11.glDisable((int)34370);
            this.context.pointSprite = false;
        }
        if (state.isPolyOffset()) {
            if (!this.context.polyOffsetEnabled) {
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)state.getPolyOffsetFactor(), (float)state.getPolyOffsetUnits());
                this.context.polyOffsetEnabled = true;
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            } else if (state.getPolyOffsetFactor() != this.context.polyOffsetFactor || state.getPolyOffsetUnits() != this.context.polyOffsetUnits) {
                GL11.glPolygonOffset((float)state.getPolyOffsetFactor(), (float)state.getPolyOffsetUnits());
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            }
        } else if (this.context.polyOffsetEnabled) {
            GL11.glDisable((int)32823);
            this.context.polyOffsetEnabled = false;
            this.context.polyOffsetFactor = 0.0f;
            this.context.polyOffsetUnits = 0.0f;
        }
        if (state.getFaceCullMode() != this.context.cullMode) {
            if (state.getFaceCullMode() == RenderState.FaceCullMode.Off) {
                GL11.glDisable((int)2884);
            } else {
                GL11.glEnable((int)2884);
            }
            switch (state.getFaceCullMode()) {
                case Off: {
                    break;
                }
                case Back: {
                    GL11.glCullFace((int)1029);
                    break;
                }
                case Front: {
                    GL11.glCullFace((int)1028);
                    break;
                }
                case FrontAndBack: {
                    GL11.glCullFace((int)1032);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized face cull mode: " + state.getFaceCullMode());
                }
            }
            this.context.cullMode = state.getFaceCullMode();
        }
        if (state.getBlendMode() != this.context.blendMode) {
            if (state.getBlendMode() == RenderState.BlendMode.Off) {
                GL11.glDisable((int)3042);
            } else {
                GL11.glEnable((int)3042);
                switch (state.getBlendMode()) {
                    case Off: {
                        break;
                    }
                    case Additive: {
                        GL11.glBlendFunc((int)1, (int)1);
                        break;
                    }
                    case AlphaAdditive: {
                        GL11.glBlendFunc((int)770, (int)1);
                        break;
                    }
                    case Color: {
                        GL11.glBlendFunc((int)1, (int)769);
                        break;
                    }
                    case Alpha: {
                        GL11.glBlendFunc((int)770, (int)771);
                        break;
                    }
                    case PremultAlpha: {
                        GL11.glBlendFunc((int)1, (int)771);
                        break;
                    }
                    case Modulate: {
                        GL11.glBlendFunc((int)774, (int)0);
                        break;
                    }
                    case ModulateX2: {
                        GL11.glBlendFunc((int)774, (int)768);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unrecognized blend mode: " + state.getBlendMode());
                    }
                }
            }
            this.context.blendMode = state.getBlendMode();
        }
        if (this.context.stencilTest != state.isStencilTest() || this.context.frontStencilStencilFailOperation != state.getFrontStencilStencilFailOperation() || this.context.frontStencilDepthFailOperation != state.getFrontStencilDepthFailOperation() || this.context.frontStencilDepthPassOperation != state.getFrontStencilDepthPassOperation() || this.context.backStencilStencilFailOperation != state.getBackStencilStencilFailOperation() || this.context.backStencilDepthFailOperation != state.getBackStencilDepthFailOperation() || this.context.backStencilDepthPassOperation != state.getBackStencilDepthPassOperation() || this.context.frontStencilFunction != state.getFrontStencilFunction() || this.context.backStencilFunction != state.getBackStencilFunction()) {
            this.context.frontStencilStencilFailOperation = state.getFrontStencilStencilFailOperation();
            this.context.frontStencilDepthFailOperation = state.getFrontStencilDepthFailOperation();
            this.context.frontStencilDepthPassOperation = state.getFrontStencilDepthPassOperation();
            this.context.backStencilStencilFailOperation = state.getBackStencilStencilFailOperation();
            this.context.backStencilDepthFailOperation = state.getBackStencilDepthFailOperation();
            this.context.backStencilDepthPassOperation = state.getBackStencilDepthPassOperation();
            this.context.frontStencilFunction = state.getFrontStencilFunction();
            this.context.backStencilFunction = state.getBackStencilFunction();
            if (state.isStencilTest()) {
                GL11.glEnable((int)2960);
                GL20.glStencilOpSeparate((int)1028, (int)this.convertStencilOperation(state.getFrontStencilStencilFailOperation()), (int)this.convertStencilOperation(state.getFrontStencilDepthFailOperation()), (int)this.convertStencilOperation(state.getFrontStencilDepthPassOperation()));
                GL20.glStencilOpSeparate((int)1029, (int)this.convertStencilOperation(state.getBackStencilStencilFailOperation()), (int)this.convertStencilOperation(state.getBackStencilDepthFailOperation()), (int)this.convertStencilOperation(state.getBackStencilDepthPassOperation()));
                GL20.glStencilFuncSeparate((int)1028, (int)this.convertTestFunction(state.getFrontStencilFunction()), (int)0, (int)Integer.MAX_VALUE);
                GL20.glStencilFuncSeparate((int)1029, (int)this.convertTestFunction(state.getBackStencilFunction()), (int)0, (int)Integer.MAX_VALUE);
            } else {
                GL11.glDisable((int)2960);
            }
        }
    }

    private int convertStencilOperation(RenderState.StencilOperation stencilOp) {
        switch (stencilOp) {
            case Keep: {
                return 7680;
            }
            case Zero: {
                return 0;
            }
            case Replace: {
                return 7681;
            }
            case Increment: {
                return 7682;
            }
            case IncrementWrap: {
                return 34055;
            }
            case Decrement: {
                return 7683;
            }
            case DecrementWrap: {
                return 34056;
            }
            case Invert: {
                return 5386;
            }
        }
        throw new UnsupportedOperationException("Unrecognized stencil operation: " + stencilOp);
    }

    private int convertTestFunction(RenderState.TestFunction testFunc) {
        switch (testFunc) {
            case Never: {
                return 512;
            }
            case Less: {
                return 513;
            }
            case LessOrEqual: {
                return 515;
            }
            case Greater: {
                return 516;
            }
            case GreaterOrEqual: {
                return 518;
            }
            case Equal: {
                return 514;
            }
            case NotEqual: {
                return 517;
            }
            case Always: {
                return 519;
            }
        }
        throw new UnsupportedOperationException("Unrecognized test function: " + testFunc);
    }

    public void setViewPort(int x, int y, int w, int h) {
        if (x != this.vpX || this.vpY != y || this.vpW != w || this.vpH != h) {
            GL11.glViewport((int)x, (int)y, (int)w, (int)h);
            this.vpX = x;
            this.vpY = y;
            this.vpW = w;
            this.vpH = h;
        }
    }

    public void setClipRect(int x, int y, int width, int height) {
        if (!this.context.clipRectEnabled) {
            GL11.glEnable((int)3089);
            this.context.clipRectEnabled = true;
        }
        if (this.clipX != x || this.clipY != y || this.clipW != width || this.clipH != height) {
            GL11.glScissor((int)x, (int)y, (int)width, (int)height);
            this.clipX = x;
            this.clipY = y;
            this.clipW = width;
            this.clipH = height;
        }
    }

    public void clearClipRect() {
        if (this.context.clipRectEnabled) {
            GL11.glDisable((int)3089);
            this.context.clipRectEnabled = false;
            this.clipX = 0;
            this.clipY = 0;
            this.clipW = 0;
            this.clipH = 0;
        }
    }

    public void onFrame() {
        this.objManager.deleteUnused((Object)this);
    }

    public void setWorldMatrix(Matrix4f worldMatrix) {
    }

    public void setViewProjectionMatrices(Matrix4f viewMatrix, Matrix4f projMatrix) {
    }

    protected void updateUniformLocation(Shader shader, Uniform uniform) {
        this.stringBuf.setLength(0);
        this.stringBuf.append(uniform.getName()).append('\u0000');
        this.updateNameBuffer();
        int loc = GL20.glGetUniformLocation((int)shader.getId(), (ByteBuffer)this.nameBuf);
        if (loc < 0) {
            uniform.setLocation(-1);
            logger.log(Level.INFO, "Uniform {0} is not declared in shader {1}.", new Object[]{uniform.getName(), shader.getSources()});
        } else {
            uniform.setLocation(loc);
        }
    }

    protected void bindProgram(Shader shader) {
        int shaderId = shader.getId();
        if (this.context.boundShaderProgram != shaderId) {
            GL20.glUseProgram((int)shaderId);
            this.statistics.onShaderUse(shader, true);
            this.boundShader = shader;
            this.context.boundShaderProgram = shaderId;
        } else {
            this.statistics.onShaderUse(shader, false);
        }
    }

    protected void updateUniform(Shader shader, Uniform uniform) {
        int shaderId = shader.getId();
        assert (uniform.getName() != null);
        assert (shader.getId() > 0);
        this.bindProgram(shader);
        int loc = uniform.getLocation();
        if (loc == -1) {
            return;
        }
        if (loc == -2) {
            this.updateUniformLocation(shader, uniform);
            if (uniform.getLocation() == -1) {
                uniform.clearUpdateNeeded();
                return;
            }
            loc = uniform.getLocation();
        }
        if (uniform.getVarType() == null) {
            return;
        }
        this.statistics.onUniformSet();
        uniform.clearUpdateNeeded();
        switch (uniform.getVarType()) {
            case Float: {
                Float f = (Float)uniform.getValue();
                GL20.glUniform1f((int)loc, (float)f.floatValue());
                break;
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)uniform.getValue();
                GL20.glUniform2f((int)loc, (float)v2.getX(), (float)v2.getY());
                break;
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)uniform.getValue();
                GL20.glUniform3f((int)loc, (float)v3.getX(), (float)v3.getY(), (float)v3.getZ());
                break;
            }
            case Vector4: {
                Object val = uniform.getValue();
                if (val instanceof ColorRGBA) {
                    ColorRGBA c = (ColorRGBA)val;
                    GL20.glUniform4f((int)loc, (float)c.r, (float)c.g, (float)c.b, (float)c.a);
                    break;
                }
                if (val instanceof Vector4f) {
                    Vector4f c = (Vector4f)val;
                    GL20.glUniform4f((int)loc, (float)c.x, (float)c.y, (float)c.z, (float)c.w);
                    break;
                }
                Quaternion c = (Quaternion)uniform.getValue();
                GL20.glUniform4f((int)loc, (float)c.getX(), (float)c.getY(), (float)c.getZ(), (float)c.getW());
                break;
            }
            case Boolean: {
                Boolean b = (Boolean)uniform.getValue();
                GL20.glUniform1i((int)loc, (int)(b != false ? 1 : 0));
                break;
            }
            case Matrix3: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 9);
                GL20.glUniformMatrix3((int)loc, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case Matrix4: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 16);
                GL20.glUniformMatrix4((int)loc, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case FloatArray: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GL20.glUniform1((int)loc, (FloatBuffer)fb);
                break;
            }
            case Vector2Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GL20.glUniform2((int)loc, (FloatBuffer)fb);
                break;
            }
            case Vector3Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GL20.glUniform3((int)loc, (FloatBuffer)fb);
                break;
            }
            case Vector4Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GL20.glUniform4((int)loc, (FloatBuffer)fb);
                break;
            }
            case Matrix4Array: {
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GL20.glUniformMatrix4((int)loc, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case Int: {
                Integer i = (Integer)uniform.getValue();
                GL20.glUniform1i((int)loc, (int)i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported uniform type: " + uniform.getVarType());
            }
        }
    }

    protected void updateShaderUniforms(Shader shader) {
        ListMap uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = (Uniform)uniforms.getValue(i);
            if (!uniform.isUpdateNeeded()) continue;
            this.updateUniform(shader, uniform);
        }
    }

    protected void resetUniformLocations(Shader shader) {
        ListMap uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = (Uniform)uniforms.getValue(i);
            uniform.reset();
        }
    }

    public void setLighting(LightList list) {
    }

    public int convertShaderType(Shader.ShaderType type) {
        switch (type) {
            case Fragment: {
                return 35632;
            }
            case Vertex: {
                return 35633;
            }
        }
        throw new UnsupportedOperationException("Unrecognized shader type.");
    }

    public void updateShaderSourceData(Shader.ShaderSource source) {
        int version;
        int id = source.getId();
        if (id == -1) {
            id = GL20.glCreateShader((int)this.convertShaderType(source.getType()));
            if (id <= 0) {
                throw new RendererException("Invalid ID received when trying to create shader.");
            }
        } else {
            throw new RendererException("Cannot recompile shader source");
        }
        source.setId(id);
        String language = source.getLanguage();
        this.stringBuf.setLength(0);
        if (language.startsWith("GLSL") && (version = Integer.parseInt(language.substring(4))) > 100) {
            this.stringBuf.append("#version ");
            this.stringBuf.append(language.substring(4));
            if (version >= 150) {
                this.stringBuf.append(" core");
            }
            this.stringBuf.append("\n");
        }
        this.updateNameBuffer();
        byte[] definesCodeData = source.getDefines().getBytes();
        byte[] sourceCodeData = source.getSource().getBytes();
        ByteBuffer codeBuf = BufferUtils.createByteBuffer((int)(this.nameBuf.limit() + definesCodeData.length + sourceCodeData.length));
        codeBuf.put(this.nameBuf);
        codeBuf.put(definesCodeData);
        codeBuf.put(sourceCodeData);
        codeBuf.flip();
        GL20.glShaderSource((int)id, (ByteBuffer)codeBuf);
        GL20.glCompileShader((int)id);
        GL20.glGetShader((int)id, (int)35713, (IntBuffer)this.intBuf1);
        boolean compiledOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!compiledOK) {
            GL20.glGetShader((int)id, (int)35716, (IntBuffer)this.intBuf1);
            int length = this.intBuf1.get(0);
            if (length > 3) {
                ByteBuffer logBuf = BufferUtils.createByteBuffer((int)length);
                GL20.glGetShaderInfoLog((int)id, null, (ByteBuffer)logBuf);
                byte[] logBytes = new byte[length];
                logBuf.get(logBytes, 0, length);
                infoLog = new String(logBytes);
            }
        }
        if (compiledOK) {
            if (infoLog != null) {
                logger.log(Level.INFO, "{0} compile success\n{1}", new Object[]{source.getName(), infoLog});
            } else {
                logger.log(Level.FINE, "{0} compile success", source.getName());
            }
        } else {
            logger.log(Level.WARNING, "Bad compile of:\n{0}", new Object[]{ShaderDebug.formatShaderSource((String)source.getDefines(), (String)source.getSource(), (String)this.stringBuf.toString())});
            if (infoLog != null) {
                throw new RendererException("compile error in:" + source + " error:" + infoLog);
            }
            throw new RendererException("compile error in:" + source + " error: <not provided>");
        }
        source.clearUpdateNeeded();
    }

    public void updateShaderData(Shader shader) {
        int id = shader.getId();
        boolean needRegister = false;
        if (id == -1) {
            id = GL20.glCreateProgram();
            if (id == 0) {
                throw new RendererException("Invalid ID (" + id + ") received when trying to create shader program.");
            }
            shader.setId(id);
            needRegister = true;
        }
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.isUpdateNeeded()) {
                this.updateShaderSourceData(source);
            }
            GL20.glAttachShader((int)id, (int)source.getId());
        }
        if (this.caps.contains(Caps.OpenGL30)) {
            GL30.glBindFragDataLocation((int)id, (int)0, (CharSequence)"outFragColor");
            for (int i = 0; i < this.maxMRTFBOAttachs; ++i) {
                GL30.glBindFragDataLocation((int)id, (int)i, (CharSequence)("outFragData[" + i + "]"));
            }
        }
        GL20.glLinkProgram((int)id);
        GL20.glGetProgram((int)id, (int)35714, (IntBuffer)this.intBuf1);
        boolean linkOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!linkOK) {
            GL20.glGetProgram((int)id, (int)35716, (IntBuffer)this.intBuf1);
            int length = this.intBuf1.get(0);
            if (length > 3) {
                ByteBuffer logBuf = BufferUtils.createByteBuffer((int)length);
                GL20.glGetProgramInfoLog((int)id, null, (ByteBuffer)logBuf);
                byte[] logBytes = new byte[length];
                logBuf.get(logBytes, 0, length);
                infoLog = new String(logBytes);
            }
        }
        if (linkOK) {
            if (infoLog != null) {
                logger.log(Level.INFO, "shader link success. \n{0}", infoLog);
            } else {
                logger.fine("shader link success");
            }
            shader.clearUpdateNeeded();
            if (needRegister) {
                this.objManager.registerForCleanup((NativeObject)shader);
                this.statistics.onNewShader();
            } else {
                this.resetUniformLocations(shader);
            }
        } else {
            if (infoLog != null) {
                throw new RendererException("Shader link failure, shader:" + shader + " info:" + infoLog);
            }
            throw new RendererException("Shader link failure, shader:" + shader + " info: <not provided>");
        }
    }

    public void setShader(Shader shader) {
        if (shader == null) {
            throw new IllegalArgumentException("Shader cannot be null");
        }
        if (shader.isUpdateNeeded()) {
            this.updateShaderData(shader);
        }
        assert (shader.getId() > 0);
        this.updateShaderUniforms(shader);
        this.bindProgram(shader);
    }

    public void deleteShaderSource(Shader.ShaderSource source) {
        if (source.getId() < 0) {
            logger.warning("Shader source is not uploaded to GPU, cannot delete.");
            return;
        }
        source.clearUpdateNeeded();
        GL20.glDeleteShader((int)source.getId());
        source.resetObject();
    }

    public void deleteShader(Shader shader) {
        if (shader.getId() == -1) {
            logger.warning("Shader is not uploaded to GPU, cannot delete.");
            return;
        }
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.getId() == -1) continue;
            GL20.glDetachShader((int)shader.getId(), (int)source.getId());
            this.deleteShaderSource(source);
        }
        GL20.glDeleteProgram((int)shader.getId());
        this.statistics.onDeleteShader();
        shader.resetObject();
    }

    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst) {
        this.copyFrameBuffer(src, dst, true);
    }

    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst, boolean copyDepth) {
        if (GLContext.getCapabilities().GL_EXT_framebuffer_blit) {
            int srcX0 = 0;
            int srcY0 = 0;
            int srcX1 = 0;
            int srcY1 = 0;
            int dstX0 = 0;
            int dstY0 = 0;
            int dstX1 = 0;
            int dstY1 = 0;
            int prevFBO = this.context.boundFBO;
            if (this.mainFbOverride != null) {
                if (src == null) {
                    src = this.mainFbOverride;
                }
                if (dst == null) {
                    dst = this.mainFbOverride;
                }
            }
            if (src != null && src.isUpdateNeeded()) {
                this.updateFrameBuffer(src);
            }
            if (dst != null && dst.isUpdateNeeded()) {
                this.updateFrameBuffer(dst);
            }
            if (src == null) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36008, (int)0);
                srcX0 = this.vpX;
                srcY0 = this.vpY;
                srcX1 = this.vpX + this.vpW;
                srcY1 = this.vpY + this.vpH;
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36008, (int)src.getId());
                srcX1 = src.getWidth();
                srcY1 = src.getHeight();
            }
            if (dst == null) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36009, (int)0);
                dstX0 = this.vpX;
                dstY0 = this.vpY;
                dstX1 = this.vpX + this.vpW;
                dstY1 = this.vpY + this.vpH;
            } else {
                EXTFramebufferObject.glBindFramebufferEXT((int)36009, (int)dst.getId());
                dstX1 = dst.getWidth();
                dstY1 = dst.getHeight();
            }
            int mask = 16384;
            if (copyDepth) {
                mask |= 0x100;
            }
            EXTFramebufferBlit.glBlitFramebufferEXT((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)9728);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)prevFBO);
            try {
                this.checkFrameBufferError();
            }
            catch (IllegalStateException ex) {
                logger.log(Level.SEVERE, "Source FBO:\n{0}", src);
                logger.log(Level.SEVERE, "Dest FBO:\n{0}", dst);
                throw ex;
            }
        } else {
            throw new RendererException("EXT_framebuffer_blit required.");
        }
    }

    private String getTargetBufferName(int buffer) {
        switch (buffer) {
            case 0: {
                return "NONE";
            }
            case 1028: {
                return "GL_FRONT";
            }
            case 1029: {
                return "GL_BACK";
            }
        }
        if (buffer >= 36064 && buffer <= 36079) {
            return "GL_COLOR_ATTACHMENT" + (buffer - 36064);
        }
        return "UNKNOWN? " + buffer;
    }

    private void printRealRenderBufferInfo(FrameBuffer fb, FrameBuffer.RenderBuffer rb, String name) {
        System.out.println("== Renderbuffer " + name + " ==");
        System.out.println("RB ID: " + rb.getId());
        System.out.println("Is proper? " + EXTFramebufferObject.glIsRenderbufferEXT((int)rb.getId()));
        int attachment = this.convertAttachmentSlot(rb.getSlot());
        int type = EXTFramebufferObject.glGetFramebufferAttachmentParameterEXT((int)36009, (int)attachment, (int)36048);
        int rbName = EXTFramebufferObject.glGetFramebufferAttachmentParameterEXT((int)36009, (int)attachment, (int)36049);
        switch (type) {
            case 0: {
                System.out.println("Type: None");
                break;
            }
            case 5890: {
                System.out.println("Type: Texture");
                break;
            }
            case 36161: {
                System.out.println("Type: Buffer");
                System.out.println("RB ID: " + rbName);
            }
        }
    }

    private void printRealFrameBufferInfo(FrameBuffer fb) {
        boolean doubleBuffer = GL11.glGetBoolean((int)3122);
        String drawBuf = this.getTargetBufferName(GL11.glGetInteger((int)3073));
        String readBuf = this.getTargetBufferName(GL11.glGetInteger((int)3074));
        int fbId = fb.getId();
        int curDrawBinding = GL11.glGetInteger((int)36006);
        int curReadBinding = GL11.glGetInteger((int)36010);
        System.out.println("=== OpenGL FBO State ===");
        System.out.println("Context doublebuffered? " + doubleBuffer);
        System.out.println("FBO ID: " + fbId);
        System.out.println("Is proper? " + EXTFramebufferObject.glIsFramebufferEXT((int)fbId));
        System.out.println("Is bound to draw? " + (fbId == curDrawBinding));
        System.out.println("Is bound to read? " + (fbId == curReadBinding));
        System.out.println("Draw buffer: " + drawBuf);
        System.out.println("Read buffer: " + readBuf);
        if (this.context.boundFBO != fbId) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36009, (int)fbId);
            this.context.boundFBO = fbId;
        }
        if (fb.getDepthBuffer() != null) {
            this.printRealRenderBufferInfo(fb, fb.getDepthBuffer(), "Depth");
        }
        for (int i = 0; i < fb.getNumColorBuffers(); ++i) {
            this.printRealRenderBufferInfo(fb, fb.getColorBuffer(i), "Color" + i);
        }
    }

    private void checkFrameBufferError() {
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        switch (status) {
            case 36053: {
                break;
            }
            case 36061: {
                throw new IllegalStateException("Framebuffer object format is unsupported by the video hardware.");
            }
            case 36054: {
                throw new IllegalStateException("Framebuffer has erronous attachment.");
            }
            case 36055: {
                throw new IllegalStateException("Framebuffer doesn't have any renderbuffers attached.");
            }
            case 36057: {
                throw new IllegalStateException("Framebuffer attachments must have same dimensions.");
            }
            case 36058: {
                throw new IllegalStateException("Framebuffer attachments must have same formats.");
            }
            case 36059: {
                throw new IllegalStateException("Incomplete draw buffer.");
            }
            case 36060: {
                throw new IllegalStateException("Incomplete read buffer.");
            }
            case 36182: {
                throw new IllegalStateException("Incomplete multisample buffer.");
            }
            default: {
                throw new IllegalStateException("Some video driver error or programming error occured. Framebuffer object status is invalid. ");
            }
        }
    }

    private void updateRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        int id = rb.getId();
        if (id == -1) {
            EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)this.intBuf1);
            id = this.intBuf1.get(0);
            rb.setId(id);
        }
        if (this.context.boundRB != id) {
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)id);
            this.context.boundRB = id;
        }
        if (fb.getWidth() > this.maxRBSize || fb.getHeight() > this.maxRBSize) {
            throw new RendererException("Resolution " + fb.getWidth() + ":" + fb.getHeight() + " is not supported.");
        }
        TextureUtil.GLImageFormat glFmt = TextureUtil.getImageFormatWithError(rb.getFormat());
        if (fb.getSamples() > 1 && GLContext.getCapabilities().GL_EXT_framebuffer_multisample) {
            int samples = fb.getSamples();
            if (this.maxFBOSamples < samples) {
                samples = this.maxFBOSamples;
            }
            EXTFramebufferMultisample.glRenderbufferStorageMultisampleEXT((int)36161, (int)samples, (int)glFmt.internalFormat, (int)fb.getWidth(), (int)fb.getHeight());
        } else {
            EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)glFmt.internalFormat, (int)fb.getWidth(), (int)fb.getHeight());
        }
    }

    private int convertAttachmentSlot(int attachmentSlot) {
        if (attachmentSlot == -100) {
            return 36096;
        }
        if (attachmentSlot < 0 || attachmentSlot >= 16) {
            throw new UnsupportedOperationException("Invalid FBO attachment slot: " + attachmentSlot);
        }
        return 36064 + attachmentSlot;
    }

    public void updateRenderTexture(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        Texture tex = rb.getTexture();
        Image image = tex.getImage();
        if (image.isUpdateNeeded()) {
            this.updateTexImageData(image, tex.getType(), tex.getMinFilter().usesMipMapLevels(), 0);
            this.setupTextureParams(tex);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)this.convertAttachmentSlot(rb.getSlot()), (int)this.convertTextureType(tex.getType(), image.getMultiSamples(), rb.getFace()), (int)image.getId(), (int)0);
    }

    public void updateFrameBufferAttachment(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        boolean needAttach;
        if (rb.getTexture() == null) {
            needAttach = rb.getId() == -1;
            this.updateRenderBuffer(fb, rb);
        } else {
            needAttach = false;
            this.updateRenderTexture(fb, rb);
        }
        if (needAttach) {
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)this.convertAttachmentSlot(rb.getSlot()), (int)36161, (int)rb.getId());
        }
    }

    public void updateFrameBuffer(FrameBuffer fb) {
        FrameBuffer.RenderBuffer depthBuf;
        int id = fb.getId();
        if (id == -1) {
            EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)this.intBuf1);
            id = this.intBuf1.get(0);
            fb.setId(id);
            this.objManager.registerForCleanup((NativeObject)fb);
            this.statistics.onNewFrameBuffer();
        }
        if (this.context.boundFBO != id) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)id);
            this.context.boundDrawBuf = 0;
            this.context.boundFBO = id;
        }
        if ((depthBuf = fb.getDepthBuffer()) != null) {
            this.updateFrameBufferAttachment(fb, depthBuf);
        }
        for (int i = 0; i < fb.getNumColorBuffers(); ++i) {
            FrameBuffer.RenderBuffer colorBuf = fb.getColorBuffer(i);
            this.updateFrameBufferAttachment(fb, colorBuf);
        }
        fb.clearUpdateNeeded();
    }

    public Vector2f[] getFrameBufferSamplePositions(FrameBuffer fb) {
        if (fb.getSamples() <= 1) {
            throw new IllegalArgumentException("Framebuffer must be multisampled");
        }
        this.setFrameBuffer(fb);
        Vector2f[] samplePositions = new Vector2f[fb.getSamples()];
        FloatBuffer samplePos = BufferUtils.createFloatBuffer((int)2);
        for (int i = 0; i < samplePositions.length; ++i) {
            ARBTextureMultisample.glGetMultisample((int)36432, (int)i, (FloatBuffer)samplePos);
            samplePos.clear();
            samplePositions[i] = new Vector2f(samplePos.get(0) - 0.5f, samplePos.get(1) - 0.5f);
        }
        return samplePositions;
    }

    public void setMainFrameBufferOverride(FrameBuffer fb) {
        this.mainFbOverride = fb;
    }

    public void setFrameBuffer(FrameBuffer fb) {
        int i;
        if (fb == null && this.mainFbOverride != null) {
            fb = this.mainFbOverride;
        }
        if (!(this.lastFb != fb || fb != null && fb.isUpdateNeeded())) {
            return;
        }
        if (this.lastFb != null) {
            for (i = 0; i < this.lastFb.getNumColorBuffers(); ++i) {
                FrameBuffer.RenderBuffer rb = this.lastFb.getColorBuffer(i);
                Texture tex = rb.getTexture();
                if (tex == null || !tex.getMinFilter().usesMipMapLevels()) continue;
                this.setTexture(0, rb.getTexture());
                int textureType = this.convertTextureType(tex.getType(), tex.getImage().getMultiSamples(), rb.getFace());
                GL11.glEnable((int)textureType);
                EXTFramebufferObject.glGenerateMipmapEXT((int)textureType);
                GL11.glDisable((int)textureType);
            }
        }
        if (fb == null) {
            if (this.context.boundFBO != 0) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                this.statistics.onFrameBufferUse(null, true);
                this.context.boundFBO = 0;
            }
            if (this.context.boundDrawBuf != -1) {
                GL11.glDrawBuffer((int)this.initialDrawBuf);
                this.context.boundDrawBuf = -1;
            }
            if (this.context.boundReadBuf != -1) {
                GL11.glReadBuffer((int)this.initialReadBuf);
                this.context.boundReadBuf = -1;
            }
            this.lastFb = null;
        } else {
            if (fb.getNumColorBuffers() == 0 && fb.getDepthBuffer() == null) {
                throw new IllegalArgumentException("The framebuffer: " + fb + "\nDoesn't have any color/depth buffers");
            }
            if (fb.isUpdateNeeded()) {
                this.updateFrameBuffer(fb);
            }
            if (this.context.boundFBO != fb.getId()) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fb.getId());
                this.statistics.onFrameBufferUse(fb, true);
                this.setViewPort(0, 0, fb.getWidth(), fb.getHeight());
                this.context.boundFBO = fb.getId();
            } else {
                this.statistics.onFrameBufferUse(fb, false);
            }
            if (fb.getNumColorBuffers() == 0) {
                if (this.context.boundDrawBuf != -2) {
                    GL11.glDrawBuffer((int)0);
                    this.context.boundDrawBuf = -2;
                }
                if (this.context.boundReadBuf != -2) {
                    GL11.glReadBuffer((int)0);
                    this.context.boundReadBuf = -2;
                }
            } else {
                if (fb.getNumColorBuffers() > this.maxFBOAttachs) {
                    throw new RendererException("Framebuffer has more color attachments than are supported by the video hardware!");
                }
                if (fb.isMultiTarget()) {
                    if (fb.getNumColorBuffers() > this.maxMRTFBOAttachs) {
                        throw new RendererException("Framebuffer has more multi targets than are supported by the video hardware!");
                    }
                    if (this.context.boundDrawBuf != 100 + fb.getNumColorBuffers()) {
                        this.intBuf16.clear();
                        for (i = 0; i < fb.getNumColorBuffers(); ++i) {
                            this.intBuf16.put(36064 + i);
                        }
                        this.intBuf16.flip();
                        GL20.glDrawBuffers((IntBuffer)this.intBuf16);
                        this.context.boundDrawBuf = 100 + fb.getNumColorBuffers();
                    }
                } else {
                    FrameBuffer.RenderBuffer rb = fb.getColorBuffer(fb.getTargetIndex());
                    if (this.context.boundDrawBuf != rb.getSlot()) {
                        GL11.glDrawBuffer((int)(36064 + rb.getSlot()));
                        this.context.boundDrawBuf = rb.getSlot();
                    }
                }
            }
            assert (fb.getId() >= 0);
            assert (this.context.boundFBO == fb.getId());
            this.lastFb = fb;
            try {
                this.checkFrameBufferError();
            }
            catch (IllegalStateException ex) {
                logger.log(Level.SEVERE, "=== jMonkeyEngine FBO State ===\n{0}", fb);
                this.printRealFrameBufferInfo(fb);
                throw ex;
            }
        }
    }

    public void readFrameBuffer(FrameBuffer fb, ByteBuffer byteBuf) {
        if (fb != null) {
            FrameBuffer.RenderBuffer rb = fb.getColorBuffer();
            if (rb == null) {
                throw new IllegalArgumentException("Specified framebuffer does not have a colorbuffer");
            }
            this.setFrameBuffer(fb);
            if (this.context.boundReadBuf != rb.getSlot()) {
                GL11.glReadBuffer((int)(36064 + rb.getSlot()));
                this.context.boundReadBuf = rb.getSlot();
            }
        } else {
            this.setFrameBuffer(null);
        }
        GL11.glReadPixels((int)this.vpX, (int)this.vpY, (int)this.vpW, (int)this.vpH, (int)32993, (int)5121, (ByteBuffer)byteBuf);
    }

    private void deleteRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        this.intBuf1.put(0, rb.getId());
        EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)this.intBuf1);
    }

    public void deleteFrameBuffer(FrameBuffer fb) {
        if (fb.getId() != -1) {
            if (this.context.boundFBO == fb.getId()) {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
                this.context.boundFBO = 0;
            }
            if (fb.getDepthBuffer() != null) {
                this.deleteRenderBuffer(fb, fb.getDepthBuffer());
            }
            if (fb.getColorBuffer() != null) {
                this.deleteRenderBuffer(fb, fb.getColorBuffer());
            }
            this.intBuf1.put(0, fb.getId());
            EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)this.intBuf1);
            fb.resetObject();
            this.statistics.onDeleteFrameBuffer();
        }
    }

    private int convertTextureType(Texture.Type type, int samples, int face) {
        switch (type) {
            case TwoDimensional: {
                if (samples > 1) {
                    return 37120;
                }
                return 3553;
            }
            case TwoDimensionalArray: {
                if (samples > 1) {
                    return 37122;
                }
                return 35866;
            }
            case ThreeDimensional: {
                return 32879;
            }
            case CubeMap: {
                if (face < 0) {
                    return 34067;
                }
                if (face < 6) {
                    return 34069 + face;
                }
                throw new UnsupportedOperationException("Invalid cube map face index: " + face);
            }
        }
        throw new UnsupportedOperationException("Unknown texture type: " + type);
    }

    private int convertMagFilter(Texture.MagFilter filter) {
        switch (filter) {
            case Bilinear: {
                return 9729;
            }
            case Nearest: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown mag filter: " + filter);
    }

    private int convertMinFilter(Texture.MinFilter filter) {
        switch (filter) {
            case Trilinear: {
                return 9987;
            }
            case BilinearNearestMipMap: {
                return 9985;
            }
            case NearestLinearMipMap: {
                return 9986;
            }
            case NearestNearestMipMap: {
                return 9984;
            }
            case BilinearNoMipMaps: {
                return 9729;
            }
            case NearestNoMipMaps: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown min filter: " + filter);
    }

    private int convertWrapMode(Texture.WrapMode mode) {
        switch (mode) {
            case BorderClamp: {
                return 33069;
            }
            case Clamp: {
                return 10496;
            }
            case EdgeClamp: {
                return 33071;
            }
            case Repeat: {
                return 10497;
            }
            case MirroredRepeat: {
                return 33648;
            }
        }
        throw new UnsupportedOperationException("Unknown wrap mode: " + mode);
    }

    private void setupTextureParams(Texture tex) {
        Image image = tex.getImage();
        int target = this.convertTextureType(tex.getType(), image != null ? image.getMultiSamples() : 1, -1);
        int minFilter = this.convertMinFilter(tex.getMinFilter());
        int magFilter = this.convertMagFilter(tex.getMagFilter());
        GL11.glTexParameteri((int)target, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)target, (int)10240, (int)magFilter);
        if (tex.getAnisotropicFilter() > 1 && GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            GL11.glTexParameterf((int)target, (int)34046, (float)tex.getAnisotropicFilter());
        }
        if (this.context.pointSprite) {
            return;
        }
        switch (tex.getType()) {
            case ThreeDimensional: 
            case CubeMap: {
                GL11.glTexParameteri((int)target, (int)32882, (int)this.convertWrapMode(tex.getWrap(Texture.WrapAxis.R)));
            }
            case TwoDimensional: 
            case TwoDimensionalArray: {
                GL11.glTexParameteri((int)target, (int)10243, (int)this.convertWrapMode(tex.getWrap(Texture.WrapAxis.T)));
                GL11.glTexParameteri((int)target, (int)10242, (int)this.convertWrapMode(tex.getWrap(Texture.WrapAxis.S)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + tex.getType());
            }
        }
        if (tex.getShadowCompareMode() != Texture.ShadowCompareMode.Off) {
            GL11.glTexParameteri((int)target, (int)34892, (int)34894);
            GL11.glTexParameteri((int)target, (int)34891, (int)32841);
            if (tex.getShadowCompareMode() == Texture.ShadowCompareMode.GreaterOrEqual) {
                GL11.glTexParameteri((int)target, (int)34893, (int)518);
            } else {
                GL11.glTexParameteri((int)target, (int)34893, (int)515);
            }
        }
    }

    public void updateTexImageData(Image img, Texture.Type type, boolean mips, int unit) {
        int imageSamples;
        int texId = img.getId();
        if (texId == -1) {
            GL11.glGenTextures((IntBuffer)this.intBuf1);
            texId = this.intBuf1.get(0);
            img.setId(texId);
            this.objManager.registerForCleanup((NativeObject)img);
            this.statistics.onNewTexture();
        }
        int target = this.convertTextureType(type, img.getMultiSamples(), -1);
        if (this.context.boundTextureUnit != unit) {
            GL13.glActiveTexture((int)(33984 + unit));
            this.context.boundTextureUnit = unit;
        }
        if (this.context.boundTextures[unit] != img) {
            GL11.glBindTexture((int)target, (int)texId);
            this.context.boundTextures[unit] = img;
            this.statistics.onTextureUse(img, true);
        }
        if (!img.hasMipmaps() && mips) {
            if (!GLContext.getCapabilities().OpenGL30) {
                GL11.glTexParameteri((int)target, (int)33169, (int)1);
            }
        } else if (img.getMipMapSizes() != null) {
            GL11.glTexParameteri((int)target, (int)33085, (int)(img.getMipMapSizes().length - 1));
        }
        if ((imageSamples = img.getMultiSamples()) > 1) {
            if (img.getFormat().isDepthFormat()) {
                img.setMultiSamples(Math.min(this.maxDepthTexSamples, imageSamples));
            } else {
                img.setMultiSamples(Math.min(this.maxColorTexSamples, imageSamples));
            }
        }
        if (!(GLContext.getCapabilities().GL_ARB_texture_non_power_of_two || img.getWidth() == 0 || img.getHeight() == 0 || FastMath.isPowerOfTwo((int)img.getWidth()) && FastMath.isPowerOfTwo((int)img.getHeight()))) {
            if (img.getData(0) == null) {
                throw new RendererException("non-power-of-2 framebuffer textures are not supported by the video hardware");
            }
            MipMapGenerator.resizeToPowerOf2((Image)img);
        }
        if (!GLContext.getCapabilities().GL_ARB_texture_multisample && img.getMultiSamples() > 1) {
            throw new RendererException("Multisample textures not supported by graphics hardware");
        }
        if (target == 34067) {
            List data = img.getData();
            if (data.size() != 6) {
                logger.log(Level.WARNING, "Invalid texture: {0}\nCubemap textures must contain 6 data units.", img);
                return;
            }
            for (int i = 0; i < 6; ++i) {
                TextureUtil.uploadTexture(img, 34069 + i, i, 0);
            }
        } else if (target == 35866) {
            List data = img.getData();
            TextureUtil.uploadTexture(img, target, -1, 0);
            for (int i = 0; i < data.size(); ++i) {
                TextureUtil.uploadTexture(img, target, i, 0);
            }
        } else {
            TextureUtil.uploadTexture(img, target, 0, 0);
        }
        if (img.getMultiSamples() != imageSamples) {
            img.setMultiSamples(imageSamples);
        }
        if (GLContext.getCapabilities().OpenGL30 && !img.hasMipmaps() && mips && img.getData() != null) {
            GL11.glEnable((int)target);
            EXTFramebufferObject.glGenerateMipmapEXT((int)target);
            GL11.glDisable((int)target);
        }
        img.clearUpdateNeeded();
    }

    public void setTexture(int unit, Texture tex) {
        Image image = tex.getImage();
        if (image.isUpdateNeeded()) {
            this.updateTexImageData(image, tex.getType(), tex.getMinFilter().usesMipMapLevels(), unit);
        }
        int texId = image.getId();
        assert (texId != -1);
        Image[] textures = this.context.boundTextures;
        int type = this.convertTextureType(tex.getType(), image.getMultiSamples(), -1);
        if (this.context.boundTextureUnit != unit) {
            GL13.glActiveTexture((int)(33984 + unit));
            this.context.boundTextureUnit = unit;
        }
        if (textures[unit] != image) {
            GL11.glBindTexture((int)type, (int)texId);
            textures[unit] = image;
            this.statistics.onTextureUse(image, true);
        } else {
            this.statistics.onTextureUse(image, false);
        }
        this.setupTextureParams(tex);
    }

    public void clearTextureUnits() {
    }

    public void deleteImage(Image image) {
        int texId = image.getId();
        if (texId != -1) {
            this.intBuf1.put(0, texId);
            this.intBuf1.position(0).limit(1);
            GL11.glDeleteTextures((IntBuffer)this.intBuf1);
            image.resetObject();
            this.statistics.onDeleteTexture();
        }
    }

    private int convertUsage(VertexBuffer.Usage usage) {
        switch (usage) {
            case Static: {
                return 35044;
            }
            case Dynamic: {
                return 35048;
            }
            case Stream: {
                return 35040;
            }
        }
        throw new UnsupportedOperationException("Unknown usage type.");
    }

    private int convertFormat(VertexBuffer.Format format) {
        switch (format) {
            case Byte: {
                return 5120;
            }
            case UnsignedByte: {
                return 5121;
            }
            case Short: {
                return 5122;
            }
            case UnsignedShort: {
                return 5123;
            }
            case Int: {
                return 5124;
            }
            case UnsignedInt: {
                return 5125;
            }
            case Float: {
                return 5126;
            }
            case Double: {
                return 5130;
            }
        }
        throw new UnsupportedOperationException("Unknown buffer format.");
    }

    public void updateBufferData(VertexBuffer vb) {
        block20: {
            int target;
            block19: {
                int bufId = vb.getId();
                boolean created = false;
                if (bufId == -1) {
                    GL15.glGenBuffers((IntBuffer)this.intBuf1);
                    bufId = this.intBuf1.get(0);
                    vb.setId(bufId);
                    this.objManager.registerForCleanup((NativeObject)vb);
                    created = true;
                }
                if (vb.getBufferType() == VertexBuffer.Type.Index) {
                    target = 34963;
                    if (this.context.boundElementArrayVBO != bufId) {
                        GL15.glBindBuffer((int)target, (int)bufId);
                        this.context.boundElementArrayVBO = bufId;
                    }
                } else {
                    target = 34962;
                    if (this.context.boundArrayVBO != bufId) {
                        GL15.glBindBuffer((int)target, (int)bufId);
                        this.context.boundArrayVBO = bufId;
                    }
                }
                int usage = this.convertUsage(vb.getUsage());
                vb.getData().rewind();
                if (!created && !vb.hasDataSizeChanged()) break block19;
                switch (vb.getFormat()) {
                    case Byte: 
                    case UnsignedByte: {
                        GL15.glBufferData((int)target, (ByteBuffer)((ByteBuffer)vb.getData()), (int)usage);
                        break block20;
                    }
                    case Short: 
                    case UnsignedShort: {
                        GL15.glBufferData((int)target, (ShortBuffer)((ShortBuffer)vb.getData()), (int)usage);
                        break block20;
                    }
                    case Int: 
                    case UnsignedInt: {
                        GL15.glBufferData((int)target, (IntBuffer)((IntBuffer)vb.getData()), (int)usage);
                        break block20;
                    }
                    case Float: {
                        GL15.glBufferData((int)target, (FloatBuffer)((FloatBuffer)vb.getData()), (int)usage);
                        break block20;
                    }
                    case Double: {
                        GL15.glBufferData((int)target, (DoubleBuffer)((DoubleBuffer)vb.getData()), (int)usage);
                        break block20;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown buffer format.");
                    }
                }
            }
            switch (vb.getFormat()) {
                case Byte: 
                case UnsignedByte: {
                    GL15.glBufferSubData((int)target, (long)0L, (ByteBuffer)((ByteBuffer)vb.getData()));
                    break;
                }
                case Short: 
                case UnsignedShort: {
                    GL15.glBufferSubData((int)target, (long)0L, (ShortBuffer)((ShortBuffer)vb.getData()));
                    break;
                }
                case Int: 
                case UnsignedInt: {
                    GL15.glBufferSubData((int)target, (long)0L, (IntBuffer)((IntBuffer)vb.getData()));
                    break;
                }
                case Float: {
                    GL15.glBufferSubData((int)target, (long)0L, (FloatBuffer)((FloatBuffer)vb.getData()));
                    break;
                }
                case Double: {
                    GL15.glBufferSubData((int)target, (long)0L, (DoubleBuffer)((DoubleBuffer)vb.getData()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown buffer format.");
                }
            }
        }
        vb.clearUpdateNeeded();
    }

    public void deleteBuffer(VertexBuffer vb) {
        int bufId = vb.getId();
        if (bufId != -1) {
            this.intBuf1.put(0, bufId);
            this.intBuf1.position(0).limit(1);
            GL15.glDeleteBuffers((IntBuffer)this.intBuf1);
            vb.resetObject();
        }
    }

    public void clearVertexAttribs() {
        IDList attribList = this.context.attribIndexList;
        for (int i = 0; i < attribList.oldLen; ++i) {
            int idx = attribList.oldList[i];
            GL20.glDisableVertexAttribArray((int)idx);
            this.context.boundAttribs[idx] = null;
        }
        this.context.attribIndexList.copyNewToOld();
    }

    public void setVertexAttrib(VertexBuffer vb, VertexBuffer idb) {
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Index buffers not allowed to be set to vertex attrib");
        }
        int programId = this.context.boundShaderProgram;
        if (programId > 0) {
            Attribute attrib = this.boundShader.getAttribute(vb.getBufferType());
            int loc = attrib.getLocation();
            if (loc == -1) {
                return;
            }
            if (loc == -2) {
                this.stringBuf.setLength(0);
                this.stringBuf.append("in").append(vb.getBufferType().name()).append('\u0000');
                this.updateNameBuffer();
                loc = GL20.glGetAttribLocation((int)programId, (ByteBuffer)this.nameBuf);
                if (loc < 0) {
                    attrib.setLocation(-1);
                    return;
                }
                attrib.setLocation(loc);
            }
            if (vb.isUpdateNeeded() && idb == null) {
                this.updateBufferData(vb);
            }
            VertexBuffer[] attribs = this.context.boundAttribs;
            if (!this.context.attribIndexList.moveToNew(loc)) {
                GL20.glEnableVertexAttribArray((int)loc);
            }
            if (attribs[loc] != vb) {
                int bufId;
                int n = bufId = idb != null ? idb.getId() : vb.getId();
                assert (bufId != -1);
                if (this.context.boundArrayVBO != bufId) {
                    GL15.glBindBuffer((int)34962, (int)bufId);
                    this.context.boundArrayVBO = bufId;
                }
                GL20.glVertexAttribPointer((int)loc, (int)vb.getNumComponents(), (int)this.convertFormat(vb.getFormat()), (boolean)vb.isNormalized(), (int)vb.getStride(), (long)vb.getOffset());
                attribs[loc] = vb;
            }
        } else {
            throw new IllegalStateException("Cannot render mesh without shader bound");
        }
    }

    public void setVertexAttrib(VertexBuffer vb) {
        this.setVertexAttrib(vb, null);
    }

    public void drawTriangleArray(Mesh.Mode mode, int count, int vertCount) {
        if (count > 1) {
            ARBDrawInstanced.glDrawArraysInstancedARB((int)this.convertElementMode(mode), (int)0, (int)vertCount, (int)count);
        } else {
            GL11.glDrawArrays((int)this.convertElementMode(mode), (int)0, (int)vertCount);
        }
    }

    public void drawTriangleList(VertexBuffer indexBuf, Mesh mesh, int count) {
        boolean useInstancing;
        if (indexBuf.getBufferType() != VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Only index buffers are allowed as triangle lists.");
        }
        if (indexBuf.isUpdateNeeded()) {
            this.updateBufferData(indexBuf);
        }
        int bufId = indexBuf.getId();
        assert (bufId != -1);
        if (this.context.boundElementArrayVBO != bufId) {
            GL15.glBindBuffer((int)34963, (int)bufId);
            this.context.boundElementArrayVBO = bufId;
        }
        int vertCount = mesh.getVertexCount();
        boolean bl = useInstancing = count > 1 && this.caps.contains(Caps.MeshInstancing);
        if (mesh.getMode() == Mesh.Mode.Hybrid) {
            int[] modeStart = mesh.getModeStart();
            int[] elementLengths = mesh.getElementLengths();
            int elMode = this.convertElementMode(Mesh.Mode.Triangles);
            int fmt = this.convertFormat(indexBuf.getFormat());
            int elSize = indexBuf.getFormat().getComponentSize();
            int listStart = modeStart[0];
            int stripStart = modeStart[1];
            int fanStart = modeStart[2];
            int curOffset = 0;
            for (int i = 0; i < elementLengths.length; ++i) {
                if (i == stripStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                } else if (i == fanStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                }
                int elementLength = elementLengths[i];
                if (useInstancing) {
                    ARBDrawInstanced.glDrawElementsInstancedARB((int)elMode, (int)elementLength, (int)fmt, (long)curOffset, (int)count);
                } else {
                    GL12.glDrawRangeElements((int)elMode, (int)0, (int)vertCount, (int)elementLength, (int)fmt, (long)curOffset);
                }
                curOffset += elementLength * elSize;
            }
        } else if (useInstancing) {
            ARBDrawInstanced.glDrawElementsInstancedARB((int)this.convertElementMode(mesh.getMode()), (int)indexBuf.getData().limit(), (int)this.convertFormat(indexBuf.getFormat()), (long)0L, (int)count);
        } else {
            GL12.glDrawRangeElements((int)this.convertElementMode(mesh.getMode()), (int)0, (int)vertCount, (int)indexBuf.getData().limit(), (int)this.convertFormat(indexBuf.getFormat()), (long)0L);
        }
    }

    public int convertElementMode(Mesh.Mode mode) {
        switch (mode) {
            case Points: {
                return 0;
            }
            case Lines: {
                return 1;
            }
            case LineLoop: {
                return 2;
            }
            case LineStrip: {
                return 3;
            }
            case Triangles: {
                return 4;
            }
            case TriangleFan: {
                return 6;
            }
            case TriangleStrip: {
                return 5;
            }
        }
        throw new UnsupportedOperationException("Unrecognized mesh mode: " + mode);
    }

    public void updateVertexArray(Mesh mesh) {
        VertexBuffer interleavedData;
        int id = mesh.getId();
        if (id == -1) {
            IntBuffer temp = this.intBuf1;
            ARBVertexArrayObject.glGenVertexArrays((IntBuffer)temp);
            id = temp.get(0);
            mesh.setId(id);
        }
        if (this.context.boundVertexArray != id) {
            ARBVertexArrayObject.glBindVertexArray((int)id);
            this.context.boundVertexArray = id;
        }
        if ((interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData)) != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        for (VertexBuffer vb : (VertexBuffer[])mesh.getBufferList().getArray()) {
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
    }

    private void renderMeshVertexArray(Mesh mesh, int lod, int count) {
        VertexBuffer indices;
        if (mesh.getId() == -1) {
            this.updateVertexArray(mesh);
        }
        if (this.context.boundVertexArray != mesh.getId()) {
            ARBVertexArrayObject.glBindVertexArray((int)mesh.getId());
            this.context.boundVertexArray = mesh.getId();
        }
        if ((indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : mesh.getBuffer(VertexBuffer.Type.Index)) != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            this.drawTriangleArray(mesh.getMode(), count, mesh.getVertexCount());
        }
        this.clearVertexAttribs();
        this.clearTextureUnits();
    }

    private void renderMeshDefault(Mesh mesh, int lod, int count) {
        VertexBuffer indices = null;
        VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
        if (interleavedData != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        SafeArrayList buffersList = mesh.getBufferList();
        indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : mesh.getBuffer(VertexBuffer.Type.Index);
        for (VertexBuffer vb : (VertexBuffer[])mesh.getBufferList().getArray()) {
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
        if (indices != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            this.drawTriangleArray(mesh.getMode(), count, mesh.getVertexCount());
        }
        this.clearVertexAttribs();
        this.clearTextureUnits();
    }

    public void renderMesh(Mesh mesh, int lod, int count) {
        if (mesh.getVertexCount() == 0) {
            return;
        }
        if (this.context.pointSprite && mesh.getMode() != Mesh.Mode.Points && this.context.boundTextures[0] != null) {
            if (this.context.boundTextureUnit != 0) {
                GL13.glActiveTexture((int)33984);
                this.context.boundTextureUnit = 0;
            }
            GL11.glDisable((int)34913);
            GL11.glDisable((int)34370);
            this.context.pointSprite = false;
        }
        if (this.context.pointSize != mesh.getPointSize()) {
            GL11.glPointSize((float)mesh.getPointSize());
            this.context.pointSize = mesh.getPointSize();
        }
        if (this.context.lineWidth != mesh.getLineWidth()) {
            GL11.glLineWidth((float)mesh.getLineWidth());
            this.context.lineWidth = mesh.getLineWidth();
        }
        this.statistics.onMeshDrawn(mesh, lod);
        this.renderMeshDefault(mesh, lod, count);
    }
}

