/*
 * Decompiled with CFR 0.152.
 */
package furny.entities;

import com.jme3.scene.Node;
import furny.entities.MetaData;
import furny.util.IOUtils;
import furny.util.ModelUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@SecondaryTables(value={@SecondaryTable(name="binary_data", pkJoinColumns={@PrimaryKeyJoinColumn(name="furn_id")}), @SecondaryTable(name="image_data", pkJoinColumns={@PrimaryKeyJoinColumn(name="furn_id")})})
public class Furniture {
    private static final transient Logger LOGGER = Logger.getLogger(Furniture.class.getName());
    private long id;
    private MetaData metaData;
    private Date date;
    @Transient
    private Node model;
    private byte[] modelBytes;
    @Transient
    private BufferedImage image;

    private Furniture() {
    }

    public Furniture(String name, Node model) {
        this.metaData = new MetaData();
        this.metaData.setName(name);
        ModelUtil.center(model);
        this.setModel(model);
        this.metaData.setDimension(ModelUtil.getExtents(model));
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Lob
    @Column(name="data", table="image_data")
    private byte[] getImageBytes() {
        try {
            return IOUtils.getBytes(this.image);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error getting bytes", e);
            return new byte[0];
        }
    }

    private void setImageBytes(byte[] bytes) {
        try {
            this.image = IOUtils.createImage(bytes);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error setting bytes", e);
        }
    }

    @Lob
    @Column(name="data", table="binary_data")
    private byte[] getModelBytes() {
        return this.modelBytes;
    }

    private void setModelBytes(byte[] bytes) {
        this.modelBytes = bytes;
        try {
            this.model = IOUtils.createNode(bytes);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Furniture " + this.id + " failed to load", e);
        }
    }

    @Transient
    public Node getModel() {
        return this.model;
    }

    public void setModel(Node model) {
        this.model = model;
        try {
            this.modelBytes = IOUtils.getBytes(model);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Furniture " + this.id + " failed to attach model", e);
        }
    }

    @Transient
    public String getName() {
        return this.metaData.getName();
    }

    @Transient
    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @MapsId
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="id", referencedColumnName="furn_id", nullable=false, updatable=false)
    public MetaData getMetaData() {
        return this.metaData;
    }

    private void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String toString() {
        if (this.metaData != null) {
            return "Furniture(" + this.id + ": " + this.metaData.getName() + ")";
        }
        return "Furniture(" + this.id + ")";
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((Furniture)obj).getId() == this.id;
    }
}

