/*
 * Decompiled with CFR 0.152.
 */
package furny.entities;

import furny.entities.TagType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
public class Tag
implements Comparable<Tag> {
    private long id;
    private String name;
    private TagType type;

    private Tag() {
    }

    public Tag(TagType type, String name) {
        this.type = type;
        this.name = name;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    @Enumerated(value=EnumType.STRING)
    public TagType getType() {
        return this.type;
    }

    public void setType(TagType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Tag o) {
        if (o.getType().equals((Object)this.type)) {
            return this.name.compareTo(o.getName());
        }
        return o.getType().getRanking() - this.type.getRanking();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && this.name.equals(((Tag)obj).getName()) && this.type.equals((Object)((Tag)obj).getType());
    }

    public String toString() {
        return this.type.name() + "/" + this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static Tag valueOf(String tagName) {
        String[] s = tagName.split("/");
        return new Tag(TagType.valueOf(s[0]), s[1]);
    }
}

