/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb;

import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.furndb.FurnitureUpdateListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FurnCache
implements FurnitureUpdateListener {
    private static final FurnCache INSTANCE = new FurnCache();
    private final Map<Long, Furniture> furnitures = new HashMap<Long, Furniture>();
    private final FurnDBManager dbManager = FurnDBManager.getInstance();

    private FurnCache() {
        List<Furniture> list = this.dbManager.getFurnitures();
        for (Furniture f : list) {
            this.furnitures.put(f.getId(), f);
        }
        this.dbManager.addFurnitureUpdateListener(this);
    }

    public static FurnCache getInstance() {
        return INSTANCE;
    }

    @Override
    public void furnitureUpdated(Long id, Furniture furniture) {
        this.furnitures.put(id, furniture);
    }

    @Override
    public void furnitureIdsUpdated(List<Long> ids) {
    }

    @Override
    public void furnitureDeleted(Long id) {
        this.furnitures.remove(id);
    }

    public List<Furniture> getAllFurnitures() {
        return new ArrayList<Furniture>(this.furnitures.values());
    }

    public Furniture getFurniture(Long id) {
        return this.furnitures.get(id);
    }
}

