/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.shader.VarType;
import com.jme3.system.JmeSystem;
import com.jme3.texture.Texture2D;
import furny.entities.Furniture;
import furny.entities.Tag;
import furny.entities.TagType;
import furny.entities.TextureData;
import furny.furndb.FurnitureUpdateListener;
import furny.furndb.SearchType;
import furny.furndb.TagUpdateListener;
import furny.util.IOUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public final class FurnDBManager {
    private static final Logger LOGGER = Logger.getLogger(FurnDBManager.class.getName());
    private static final FurnDBManager INSTANCE = new FurnDBManager();
    private static final String PARAMETERS = ";PAGE_SIZE=8192;AUTO_SERVER=TRUE;MVCC=TRUE;MAX_LENGTH_INPLACE_LOB=104857600;LOCK_TIMEOUT=100;DB_CLOSE_DELAY=-1";
    private EntityManagerFactory entityManagerFactory;
    private final AssetManager assetManager = JmeSystem.newAssetManager((URL)this.getClass().getResource("/asset.cfg"));
    private final List<FurnitureUpdateListener> furnitureListeners = new Vector<FurnitureUpdateListener>();
    private final List<TagUpdateListener> tagListeners = new Vector<TagUpdateListener>();
    private final ExecutorService executor = Executors.newFixedThreadPool(4);
    private final List<Long> updateIds = new Vector<Long>();

    private FurnDBManager() {
    }

    public static FurnDBManager getInstance() {
        return INSTANCE;
    }

    public void setCustomFilename(String filename) {
        if (filename != null) {
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
            }
            HashMap<String, String> dbProps = new HashMap<String, String>();
            String jdbcString = !filename.startsWith("jdbc:") ? "jdbc:h2:" + filename + PARAMETERS : filename;
            dbProps.put("javax.persistence.jdbc.url", jdbcString);
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"furny", dbProps);
        }
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    private EntityManager createEntityManager() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"furny");
        }
        return this.entityManagerFactory.createEntityManager();
    }

    public void saveFurniture(Furniture furniture, boolean merge) {
        this.saveFurniture(furniture, merge, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFurniture(Furniture furniture, boolean merge, File path) {
        EntityManager entityManager = this.createEntityManager();
        ((DesktopAssetManager)this.assetManager).clearCache();
        Furniture f = furniture;
        try {
            entityManager.getTransaction().begin();
            furniture.setDate(new Date());
            if (merge) {
                f = (Furniture)entityManager.merge((Object)furniture);
            } else {
                this.convertTexturesToDB(entityManager, f, path);
                entityManager.persist((Object)furniture);
            }
            entityManager.getTransaction().commit();
            this.fireFurnitureUpdate(f.getId(), f);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save furniture", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    private boolean convertTexturesToDB(EntityManager entityManager, Furniture f, File path) throws IOException {
        boolean changes = false;
        List<Material> mats = IOUtils.getMaterials(f.getModel());
        for (Material m : mats) {
            for (MatParam mp : m.getParams()) {
                Texture2D tex;
                if (!mp.getVarType().equals((Object)VarType.Texture2D) || (tex = (Texture2D)mp.getValue()).getKey().getName().startsWith("db://")) continue;
                LOGGER.info("Trying to load " + path.getAbsolutePath() + "\\" + tex.getKey().getName());
                BufferedImage bi = ImageIO.read(new File(path.getAbsolutePath() + "/" + tex.getKey().getName()));
                TextureData td = new TextureData(bi);
                entityManager.persist((Object)td);
                String newId = "db://" + td.getId() + ".png";
                TextureKey ak = new TextureKey(newId, ((TextureKey)tex.getKey()).isFlipY());
                tex.setKey((AssetKey)ak);
                tex.setName(newId);
                changes = true;
            }
        }
        if (changes) {
            f.setModel(f.getModel());
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTag(Tag tag) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)tag);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save tag", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFurniture(Long id) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query q = entityManager.createNativeQuery("DELETE FROM Binary_data WHERE furn_id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            q = entityManager.createNativeQuery("DELETE FROM Image_data WHERE furn_id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            q = entityManager.createNativeQuery("DELETE FROM Furniture_tags WHERE metadata_id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            q = entityManager.createNativeQuery("DELETE FROM Furniture WHERE id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            q = entityManager.createNativeQuery("DELETE FROM Furniture_metadata WHERE id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            entityManager.getTransaction().commit();
            this.fireFurnitureDeleted(id);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to delete furniture", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTag(Tag tag) {
        EntityManager entityManager = this.createEntityManager();
        Long id = tag.getId();
        try {
            entityManager.getTransaction().begin();
            Query q = entityManager.createQuery("SELECT f.id FROM Furniture f JOIN f.metaData.tags t WHERE t.id = :id");
            q.setParameter("id", (Object)id);
            List furnitureIds = q.getResultList();
            q = entityManager.createNativeQuery("DELETE FROM Furniture_tags WHERE tag_id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            q = entityManager.createNativeQuery("DELETE FROM Tag WHERE id = :id");
            q.setParameter("id", (Object)id);
            q.executeUpdate();
            entityManager.getTransaction().commit();
            for (Long furnId : furnitureIds) {
                Furniture f = this.getFurniture(furnId);
                if (f == null) continue;
                this.fireFurnitureUpdate(furnId, f);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to delete tag", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getFurnitureIds() {
        EntityManager entityManager = this.createEntityManager();
        ArrayList<Long> result = null;
        try {
            entityManager.getTransaction().begin();
            result = entityManager.createQuery("SELECT id FROM Furniture", Long.class).getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get furniture ids", e);
            entityManager.getTransaction().rollback();
            result = new ArrayList<Long>();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Furniture getFurniture(Long id) {
        EntityManager entityManager = this.createEntityManager();
        Furniture result = null;
        try {
            entityManager.getTransaction().begin();
            result = (Furniture)entityManager.find(Furniture.class, (Object)id);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get furniture", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureData getTextureData(String key) {
        EntityManager entityManager = this.createEntityManager();
        String splitKey = key.replace("db://", "");
        splitKey = splitKey.replace(".png", "");
        Long id = Long.valueOf(splitKey);
        TextureData result = null;
        try {
            entityManager.getTransaction().begin();
            result = (TextureData)entityManager.find(TextureData.class, (Object)id);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get texture data", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Furniture> getFurnitures() {
        EntityManager entityManager = this.createEntityManager();
        ArrayList<Furniture> result = null;
        try {
            entityManager.getTransaction().begin();
            TypedQuery q = entityManager.createQuery("from Furniture", Furniture.class);
            result = q.getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get furnitures", e);
            entityManager.getTransaction().rollback();
            result = new ArrayList<Furniture>();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tag> getTags(TagType type) {
        EntityManager entityManager = this.createEntityManager();
        ArrayList<Tag> result = null;
        try {
            TypedQuery q;
            entityManager.getTransaction().begin();
            if (type == null) {
                q = entityManager.createQuery("FROM Tag t", Tag.class);
            } else {
                q = entityManager.createQuery("FROM Tag t WHERE t.type=:tagType", Tag.class);
                q.setParameter("tagType", (Object)type);
            }
            result = q.getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get tags", e);
            entityManager.getTransaction().rollback();
            result = new ArrayList<Tag>();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    public void addFurnitureTags(Furniture furniture, Set<Tag> newTags) {
        newTags.addAll(furniture.getMetaData().getTags());
        this.setFurnitureTags(furniture, newTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFurnitureTags(Furniture furniture, Set<Tag> tags) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            furniture.getMetaData().setTags(tags);
            furniture.setDate(new Date());
            Furniture f = (Furniture)entityManager.merge((Object)furniture);
            entityManager.getTransaction().commit();
            this.fireFurnitureUpdate(f.getId(), f);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to set furniture tags", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getFurnitureIdsByString(SearchType searchType, String text, boolean equals) {
        EntityManager entityManager = this.createEntityManager();
        String name = equals ? text.toLowerCase() : "%" + text.toLowerCase() + "%";
        List<Long> result = null;
        try {
            TypedQuery q;
            entityManager.getTransaction().begin();
            switch (searchType) {
                case NAME: {
                    q = entityManager.createQuery("SELECT DISTINCT f.id FROM Furniture f WHERE lower(f.metaData.name) like :name", Long.class);
                    q.setParameter("name", (Object)name);
                    break;
                }
                case DESCRIPTION: {
                    q = entityManager.createQuery("SELECT DISTINCT f.id FROM Furniture f WHERE lower(f.metaData.description) like :descr", Long.class);
                    q.setParameter("descr", (Object)name);
                    break;
                }
                case TAGS: {
                    q = entityManager.createQuery("SELECT DISTINCT f.id FROM Furniture f JOIN f.metaData.tags t WHERE lower(t.name) like :tagname", Long.class);
                    q.setParameter("tagname", (Object)name);
                    break;
                }
                default: {
                    q = entityManager.createQuery("SELECT DISTINCT f.id FROM Furniture f LEFT JOIN f.metaData.tags t WHERE lower(f.metaData.name) like :name OR lower(f.metaData.description) like :descr OR lower(t.name) like :tagname", Long.class);
                    q.setParameter("name", (Object)name);
                    q.setParameter("descr", (Object)name);
                    q.setParameter("tagname", (Object)name);
                }
            }
            result = q.getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to find furniture ids", e);
            entityManager.getTransaction().rollback();
            result = new ArrayList<Long>();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    public void updateFurnitureIds() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List<Long> newList = FurnDBManager.this.getFurnitureIds();
                for (FurnitureUpdateListener l : FurnDBManager.this.furnitureListeners) {
                    l.furnitureIdsUpdated(newList);
                }
            }
        });
    }

    public void updateTags(final TagType type) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List newList = FurnDBManager.this.getTags(type);
                for (TagUpdateListener l : FurnDBManager.this.tagListeners) {
                    l.tagsUpdated(type, newList);
                }
            }
        });
    }

    public void updateFurniture(final Long id) {
        if (this.updateIds.contains(id)) {
            return;
        }
        this.updateIds.add(id);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Furniture furniture = FurnDBManager.this.getFurniture(id);
                if (furniture != null) {
                    for (FurnitureUpdateListener l : FurnDBManager.this.furnitureListeners) {
                        l.furnitureUpdated(furniture.getId(), furniture);
                    }
                }
                FurnDBManager.this.updateIds.remove(id);
            }
        });
    }

    public void updateIdsByTagName(final SearchType searchType, final String text, final boolean equals) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List newList = FurnDBManager.this.getFurnitureIdsByString(searchType, text, equals);
                for (FurnitureUpdateListener l : FurnDBManager.this.furnitureListeners) {
                    l.furnitureIdsUpdated(newList);
                }
            }
        });
    }

    public void addFurnitureUpdateListener(FurnitureUpdateListener listener) {
        if (!this.furnitureListeners.contains(listener)) {
            this.furnitureListeners.add(listener);
        }
    }

    public void addTagUpdateListener(TagUpdateListener listener) {
        if (!this.tagListeners.contains(listener)) {
            this.tagListeners.add(listener);
        }
    }

    public void removeTagUpdateListener(TagUpdateListener listener) {
        this.tagListeners.remove(listener);
    }

    private void fireFurnitureUpdate(final Long id, final Furniture furniture) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (FurnitureUpdateListener l : FurnDBManager.this.furnitureListeners) {
                    l.furnitureUpdated(id, furniture);
                }
            }
        });
    }

    private void fireFurnitureDeleted(final Long id) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (FurnitureUpdateListener l : FurnDBManager.this.furnitureListeners) {
                    l.furnitureDeleted(id);
                }
            }
        });
    }

    public void exit() {
        this.executor.shutdown();
        this.entityManagerFactory.close();
    }
}

