/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb.importer;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.furndb.FurnDBManager;
import furny.furndb.importer.IModelSource;
import java.util.List;
import java.util.logging.Logger;

public class DBModelSource
implements IModelSource {
    private static final Logger LOGGER = Logger.getLogger(DBModelSource.class.getName());
    private List<Long> ids;
    private int index;

    public DBModelSource() {
        this.reset();
    }

    @Override
    public void reset() {
        this.index = -1;
        this.ids = FurnDBManager.getInstance().getFurnitureIds();
    }

    @Override
    public void seek(Furniture furn) {
        for (int i = 0; i < this.ids.size(); ++i) {
            Long id = this.ids.get(i);
            if (!id.equals(furn.getId())) continue;
            this.index = i;
            LOGGER.info("Loading " + furn.getId() + " " + furn.getName() + " at index " + i);
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.ids.size();
    }

    @Override
    public Furniture next(int offset) {
        if (this.ids.size() == 0) {
            return null;
        }
        this.index = (this.index + offset) % this.ids.size();
        if (this.index < 0) {
            this.index = this.ids.size() - 1;
        }
        Long id = this.ids.get(this.index);
        return FurnCache.getInstance().getFurniture(id);
    }

    @Override
    public Furniture next() {
        return this.next(1);
    }

    @Override
    public Furniture previous() {
        return this.next(-1);
    }

    @Override
    public int getSize() {
        return this.ids.size();
    }
}

