/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb.importer;

import com.jme3.scene.Node;
import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.furndb.importer.IModelSource;
import furny.util.FileUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePathModelSource
implements IModelSource {
    private static final Logger LOGGER = Logger.getLogger(FilePathModelSource.class.getName());
    private static final String ASSET_PREFIX = "src/assets/";
    private final String assetPath;
    private List<File> files;
    private int index;

    public FilePathModelSource(String assetPath) {
        this.assetPath = assetPath;
        this.reset();
    }

    @Override
    public void reset() {
        this.index = -1;
        this.files = FileUtils.getFiles(new File(ASSET_PREFIX + this.assetPath), ".*\\.mesh\\.xml");
    }

    @Override
    public void seek(Furniture furn) {
        for (int i = 0; i < this.files.size(); ++i) {
            File f = this.files.get(i);
            if (!f.getName().equals(furn.getName())) continue;
            this.index = i;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.files.size();
    }

    @Override
    public Furniture next(int offset) {
        File f;
        this.index = (this.index + offset) % this.files.size();
        if (this.index < 0) {
            this.index = this.files.size() - offset;
        }
        if ((f = this.files.get(this.index)).exists()) {
            try {
                String assetName = this.assetPath + f.getName();
                LOGGER.info("Loading model " + f.getAbsolutePath());
                Node n = (Node)FurnDBManager.getInstance().getAssetManager().loadModel(assetName);
                Furniture furn = new Furniture(f.getName().replace(".mesh.xml", ""), n);
                return furn;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to load model", e);
            }
        }
        return null;
    }

    @Override
    public Furniture next() {
        return this.next(1);
    }

    @Override
    public Furniture previous() {
        return this.next(-1);
    }

    @Override
    public int getSize() {
        return this.files.size();
    }
}

