/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb.importer;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.furndb.importer.FileModelSource;
import furny.furndb.importer.FilePathModelSource;
import furny.furndb.importer.IModelSource;
import furny.furndb.importer.RenderThumbnailState;
import furny.jme.FurnyApplication;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FurnDBImporter
implements RenderThumbnailState.RenderListener {
    private static final Logger LOGGER = Logger.getLogger(FurnDBImporter.class.getName());
    private IModelSource modelSource;
    private final RenderThumbnailState rtt;
    private Furniture actFurn;
    private ExitMode exitMode = ExitMode.EXIT_JME_CONTEXT_AND_DB;
    private final SimpleApplication app;
    private ImportListener listener;
    private String lastAssetPath = ".";

    public FurnDBImporter() {
        this.rtt = new RenderThumbnailState();
        this.rtt.setRenderImage(true);
        this.rtt.setSaveImage(false);
        this.rtt.setEnabled(false);
        this.app = new FurnyApplication();
        this.app.setShowSettings(false);
        this.app.setPauseOnLostFocus(false);
        this.app.start(JmeContext.Type.OffscreenSurface);
        AppSettings settings = new AppSettings(true);
        settings.setWidth(RenderThumbnailState.IMAGE_SIZE.width * 4);
        settings.setHeight(RenderThumbnailState.IMAGE_SIZE.height * 4);
        settings.setBitsPerPixel(24);
        settings.setFrequency(60);
        this.app.setSettings(settings);
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FurnDBImporter.this.app.getStateManager().attach((AppState)FurnDBImporter.this.rtt);
                return null;
            }
        });
    }

    public FurnDBImporter(SimpleApplication app) {
        this.rtt = new RenderThumbnailState();
        this.rtt.setRenderImage(true);
        this.rtt.setSaveImage(false);
        this.rtt.setEnabled(false);
        this.app = app;
        this.exitMode = ExitMode.DETACH_AND_UPDATE_IDS;
    }

    public void importModelsFromPath(final String assetPath) {
        LOGGER.info("waiting for renderer to start");
        this.rtt.setEnabled(true);
        while (!this.rtt.isInitialized()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Failed to sleep", e);
            }
        }
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LOGGER.info("importing " + assetPath);
                FurnDBImporter.this.modelSource = new FilePathModelSource(assetPath);
                LOGGER.info(FurnDBImporter.this.modelSource.getSize() + " files to import");
                if (FurnDBImporter.this.modelSource.hasNext()) {
                    FurnDBImporter.this.app.enqueue((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            FurnDBImporter.this.actFurn = FurnDBImporter.this.modelSource.next();
                            LOGGER.info(FurnDBImporter.this.actFurn.toString());
                            FurnDBImporter.this.renderThumbNail(FurnDBImporter.this.actFurn);
                            return null;
                        }
                    });
                } else {
                    FurnDBImporter.this.rtt.setEnabled(false);
                    FurnDBImporter.this.checkForExit();
                }
                return null;
            }
        });
    }

    public void importModelsFromFiles(final String assetPath, final List<File> files, ImportListener listener) {
        LOGGER.info("waiting for renderer to start");
        this.listener = listener;
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FurnDBImporter.this.app.getStateManager().attach((AppState)FurnDBImporter.this.rtt);
                FurnDBImporter.this.rtt.setEnabled(true);
                return null;
            }
        });
        while (!this.rtt.isInitialized()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Failed to sleep", e);
            }
        }
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LOGGER.info("importing " + files);
                FurnDBImporter.this.lastAssetPath = assetPath;
                FurnDBImporter.this.modelSource = new FileModelSource(assetPath, files);
                LOGGER.info(FurnDBImporter.this.modelSource.getSize() + " files to import");
                if (FurnDBImporter.this.modelSource.hasNext()) {
                    FurnDBImporter.this.app.enqueue((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            FurnDBImporter.this.actFurn = FurnDBImporter.this.modelSource.next();
                            LOGGER.info(String.valueOf(FurnDBImporter.this.actFurn));
                            if (FurnDBImporter.this.actFurn != null) {
                                FurnDBImporter.this.renderThumbNail(FurnDBImporter.this.actFurn);
                            }
                            return null;
                        }
                    });
                } else {
                    FurnDBImporter.this.rtt.setEnabled(false);
                    FurnDBImporter.this.checkForExit();
                }
                return null;
            }
        });
    }

    public void setExitMode(ExitMode exitMode) {
        this.exitMode = exitMode;
    }

    private void renderThumbNail(Furniture f) {
        this.rtt.renderThumbnail(f.getName(), f.getModel(), this);
    }

    @Override
    public void renderingCompleted(String id, BufferedImage image) {
        LOGGER.info(id + " rendered");
        if (id.equals(this.actFurn.getName())) {
            this.actFurn.setImage(image);
            FurnDBManager.getInstance().saveFurniture(this.actFurn, false, new File(this.lastAssetPath));
            if (this.modelSource.hasNext()) {
                this.actFurn = this.modelSource.next();
                this.renderThumbNail(this.actFurn);
            } else {
                this.checkForExit();
            }
        }
    }

    @Override
    public void savingCompleted(String id, File file) {
        LOGGER.info(id + " saved as " + file.getAbsolutePath());
    }

    private void checkForExit() {
        switch (this.exitMode) {
            case EXIT_JME_CONTEXT: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Failed to sleep", e);
                }
                LOGGER.info("System should exit now");
                this.app.stop();
                break;
            }
            case EXIT_JME_CONTEXT_AND_DB: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Failed to sleep", e);
                }
                LOGGER.info("System should exit now");
                this.app.stop();
                FurnDBManager.getInstance().exit();
                break;
            }
            case DETACH_AND_UPDATE_IDS: {
                this.app.enqueue((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        FurnDBImporter.this.rtt.setEnabled(false);
                        FurnDBImporter.this.app.getStateManager().detach((AppState)FurnDBImporter.this.rtt);
                        return null;
                    }
                });
                FurnDBManager.getInstance().updateFurnitureIds();
            }
        }
        if (this.listener != null) {
            this.listener.importDone();
            this.listener = null;
        }
    }

    public static void main(String[] args) {
        FurnDBImporter importer = new FurnDBImporter();
        importer.setExitMode(ExitMode.EXIT_JME_CONTEXT_AND_DB);
        importer.importModelsFromPath("models/");
    }

    public static interface ImportListener {
        public void importDone();
    }

    public static enum ExitMode {
        DETACH_AND_UPDATE_IDS,
        EXIT_JME_CONTEXT,
        EXIT_JME_CONTEXT_AND_DB;

    }
}

