/*
 * Decompiled with CFR 0.152.
 */
package furny.furndb.importer;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.ChaseCamera;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import furny.jme.FurnyApplication;
import furny.jme.appstate.RootNodeState;
import furny.util.CameraUtils;
import furny.util.ImageUtils;
import furny.util.LightingUtil;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class RenderThumbnailState
extends RootNodeState {
    public static final Dimension IMAGE_SIZE = new Dimension(200, 150);
    private static final Logger LOGGER = Logger.getLogger(RenderThumbnailState.class.getName());
    private RenderListener outterListener;
    private ChaseCamera chaseCam;
    private Camera cam;
    private Node camTarget;
    private Node modelNode;
    private String id;
    private RenderToImageProcessor state;
    private int renderCycles;
    private boolean captureNextFrame;
    private boolean doRender;
    private boolean doSave;
    private boolean initialized;
    private String fileName;
    private FurnyApplication app;
    private ViewPort viewPort;
    private RenderManager rm;

    public void stateAttached(AppStateManager stateManager) {
        if (this.viewPort != null) {
            this.viewPort.setEnabled(true);
        }
    }

    public void stateDetached(AppStateManager stateManager) {
        this.viewPort.setEnabled(false);
    }

    public void render(RenderManager rm) {
    }

    public void initialize(AppStateManager stateManager, Application app) {
        if (app instanceof FurnyApplication) {
            this.app = (FurnyApplication)app;
            this.app.setDisplayFps(false);
            this.app.setDisplayStatView(false);
        }
        this.rm = app.getRenderManager();
        this.cam = new Camera(RenderThumbnailState.IMAGE_SIZE.width * 4, RenderThumbnailState.IMAGE_SIZE.height * 4);
        this.cam.setFrustumPerspective(45.0f, (float)RenderThumbnailState.IMAGE_SIZE.width / (float)RenderThumbnailState.IMAGE_SIZE.height, 0.1f, 20.0f);
        this.viewPort = this.rm.createPostView("Offscreen View", this.cam);
        this.viewPort.setClearFlags(true, true, true);
        this.viewPort.setBackgroundColor(app.getViewPort().getBackgroundColor());
        this.viewPort.attachScene((Spatial)this.rootNode);
        this.state = new RenderToImageProcessor();
        this.viewPort.addProcessor((SceneProcessor)this.state);
        this.camTarget = new Node("Camera Target");
        this.modelNode = new Node("Model Node");
        this.rootNode.attachChild((Spatial)this.camTarget);
        this.rootNode.attachChild((Spatial)this.modelNode);
        this.chaseCam = new ChaseCamera(this.cam, (Spatial)this.camTarget);
        this.chaseCam.setSmoothMotion(false);
        this.chaseCam.setTrailingSensitivity(2.0f);
        this.chaseCam.setDefaultHorizontalRotation(2.3561945f);
        LightingUtil.createDefaultLights(this.rootNode);
        this.update(1.0f);
        this.initialized = true;
    }

    public void renderThumbnail(String id, Node node, RenderListener listener) {
        this.id = id;
        this.outterListener = listener;
        this.modelNode.detachAllChildren();
        this.modelNode.attachChild((Spatial)node);
        this.fileName = id;
        try {
            CameraUtils.adjustChaseCam(this.rootNode, this.chaseCam, this.cam, this.camTarget);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, node + ", " + this.chaseCam + ", " + this.camTarget, e);
        }
        this.rootNode.updateGeometricState();
        this.rootNode.updateLogicalState(1.0f);
        this.captureNextFrame = true;
        this.renderCycles = 5;
    }

    public void setRenderImage(boolean render) {
        this.doRender = render;
    }

    public void setSaveImage(boolean save) {
        this.doSave = save;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void cleanup() {
        super.cleanup();
        this.rootNode.detachAllChildren();
        this.rm.removePostView(this.viewPort);
    }

    public static interface RenderListener {
        public void renderingCompleted(String var1, BufferedImage var2);

        public void savingCompleted(String var1, File var2);
    }

    public class RenderToImageProcessor
    implements SceneProcessor {
        private Renderer renderer;
        private ByteBuffer outBuf;
        private int shotIndex;
        private BufferedImage awtImage;

        public void initialize(RenderManager rm, ViewPort vp) {
            this.renderer = rm.getRenderer();
            this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
        }

        public boolean isInitialized() {
            return this.renderer != null;
        }

        public void reshape(ViewPort vp, int w, int h) {
            this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
            this.awtImage = new BufferedImage(w, h, 6);
        }

        public void preFrame(float tpf) {
        }

        public void postQueue(RenderQueue rq) {
        }

        public void postFrame(FrameBuffer out) {
            if (RenderThumbnailState.this.captureNextFrame) {
                if (--RenderThumbnailState.this.renderCycles > 0) {
                    return;
                }
                RenderThumbnailState.this.captureNextFrame = false;
                ++this.shotIndex;
                this.renderer.readFrameBuffer(out, this.outBuf);
                Screenshots.convertScreenShot((ByteBuffer)this.outBuf, (BufferedImage)this.awtImage);
                BufferedImage img = ImageUtils.getScaledInstance(this.awtImage, RenderThumbnailState.IMAGE_SIZE.width, RenderThumbnailState.IMAGE_SIZE.height, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
                if (RenderThumbnailState.this.doRender) {
                    RenderThumbnailState.this.outterListener.renderingCompleted(RenderThumbnailState.this.id, img);
                }
                if (RenderThumbnailState.this.doSave) {
                    try {
                        File f = new File(RenderThumbnailState.this.fileName + this.shotIndex + ".png");
                        ImageIO.write((RenderedImage)img, "png", f);
                        RenderThumbnailState.this.outterListener.savingCompleted(RenderThumbnailState.this.id, f);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Error while saving screenshot", ex);
                    }
                }
            }
        }

        public void cleanup() {
            this.outBuf.clear();
        }
    }
}

