/*
 * Decompiled with CFR 0.152.
 */
package furny.jme.appstate;

import com.jme3.app.Application;
import com.jme3.app.StatsView;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.FlyByCamera;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.util.BufferUtils;
import furny.jme.appstate.RootNodeState;

public abstract class SimpleAppState
extends RootNodeState {
    public static final String INPUT_MAPPING_EXIT = "SIMPLEAPP_Exit";
    public static final String INPUT_MAPPING_CAMERA_POS = "SIMPLEAPP_CameraPos";
    public static final String INPUT_MAPPING_MEMORY = "SIMPLEAPP_Memory";
    protected ViewPort viewPort;
    protected ViewPort guiViewPort;
    protected Camera cam;
    protected Node guiNode = new Node("Gui Node");
    protected float secondCounter;
    protected BitmapText fpsText;
    protected BitmapFont guiFont;
    protected StatsView statsView;
    protected FlyByCamera flyCam;
    protected boolean showSettings = true;
    protected VIEWPORT createViewPort = VIEWPORT.MAIN;
    protected Application app;
    protected RenderManager renderManager;
    protected Renderer renderer;
    protected AssetManager assetManager;
    protected InputManager inputManager;
    protected JmeContext context;
    protected AppSettings settings;
    private boolean showStatistics = true;
    private boolean showFps = true;
    private boolean showStatsView = true;
    private final AppActionListener actionListener = new AppActionListener();
    private Integer overrideWidth;
    private Integer overrideHeight;

    public void setOverrideSize(int width, int height) {
        this.overrideWidth = width;
        this.overrideHeight = height;
    }

    public final void initialize(AppStateManager stateManager, Application app) {
        this.app = app;
        this.assetManager = app.getAssetManager();
        this.inputManager = app.getInputManager();
        this.renderManager = app.getRenderManager();
        this.renderer = this.renderManager.getRenderer();
        this.context = app.getContext();
        this.settings = this.context.getSettings();
        this.initCamera();
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.loadFPSText();
        this.loadStatsView();
        this.viewPort.attachScene((Spatial)this.rootNode);
        this.guiViewPort.attachScene((Spatial)this.guiNode);
        if (this.inputManager != null) {
            this.flyCam = new FlyByCamera(this.cam);
            this.flyCam.setMoveSpeed(1.0f);
            this.flyCam.registerWithInput(this.inputManager);
            if (app.getContext().getType() == JmeContext.Type.Display) {
                this.inputManager.addMapping(INPUT_MAPPING_EXIT, new Trigger[]{new KeyTrigger(1)});
            }
            this.inputManager.addMapping(INPUT_MAPPING_CAMERA_POS, new Trigger[]{new KeyTrigger(46)});
            this.inputManager.addMapping(INPUT_MAPPING_MEMORY, new Trigger[]{new KeyTrigger(50)});
            this.inputManager.addListener((InputListener)this.actionListener, new String[]{INPUT_MAPPING_EXIT, INPUT_MAPPING_CAMERA_POS, INPUT_MAPPING_MEMORY});
        }
        this.simpleInitAppState();
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
        super.initialize(stateManager, app);
    }

    private void initCamera() {
        boolean overrideSize = this.overrideWidth != null && this.overrideHeight != null;
        int width = overrideSize ? this.overrideWidth.intValue() : this.app.getViewPort().getCamera().getWidth();
        int height = overrideSize ? this.overrideWidth.intValue() : this.app.getViewPort().getCamera().getHeight();
        this.cam = new Camera(width, height);
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 0.1f, 20.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 10.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        if (this.createViewPort == VIEWPORT.MAIN) {
            this.viewPort = this.renderManager.createMainView("Main " + ((Object)((Object)this)).getClass().getSimpleName(), this.cam);
        } else if (this.createViewPort == VIEWPORT.POST) {
            this.viewPort = this.renderManager.createPostView("Main " + ((Object)((Object)this)).getClass().getSimpleName(), this.cam);
        }
        this.viewPort.setClearFlags(true, true, true);
        Camera guiCam = new Camera(this.cam.getWidth(), this.cam.getHeight());
        this.guiViewPort = this.renderManager.createPostView("Gui " + ((Object)((Object)this)).getClass().getSimpleName(), guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
    }

    public Camera getCamera() {
        return this.cam;
    }

    public FlyByCamera getFlyByCamera() {
        return this.flyCam;
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    @Override
    public final void update(float tpf) {
        if (this.showFps) {
            this.secondCounter += tpf;
            int fps = (int)(1.0f / tpf);
            if (this.secondCounter >= 1.0f) {
                this.fpsText.setText("Frames per second: " + fps);
                this.secondCounter = 0.0f;
            }
        }
        this.simpleUpdate(tpf);
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        this.guiNode.updateGeometricState();
    }

    private void loadFPSText() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.fpsText = new BitmapText(this.guiFont, false);
        this.fpsText.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.fpsText.setText("Frames per second");
        this.setDisplayFps(this.showFps);
        this.guiNode.attachChild((Spatial)this.fpsText);
    }

    private void loadStatsView() {
        this.statsView = new StatsView("Statistics View", this.assetManager, this.renderer.getStatistics());
        this.statsView.setLocalTranslation(0.0f, this.fpsText.getLineHeight(), 0.0f);
        this.setDisplayStatView(this.showStatsView);
        this.guiNode.attachChild((Spatial)this.statsView);
    }

    public BitmapText getFpsText() {
        return this.fpsText;
    }

    public void setShowStatistics(boolean showStatistics) {
        this.showStatistics = showStatistics;
        this.setDisplayFps(showStatistics);
        this.setDisplayStatView(showStatistics);
    }

    public boolean isShowStatistics() {
        return this.showStatistics;
    }

    public void setDisplayFps(boolean show) {
        this.showFps = show;
        if (this.fpsText != null) {
            this.fpsText.setCullHint(show ? Spatial.CullHint.Never : Spatial.CullHint.Always);
        }
    }

    public void setDisplayStatView(boolean show) {
        this.showStatsView = show;
        if (this.statsView != null) {
            this.statsView.setEnabled(show);
            this.statsView.setCullHint(show ? Spatial.CullHint.Never : Spatial.CullHint.Always);
        }
    }

    public ViewPort getGuiViewPort() {
        return this.guiViewPort;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public abstract void simpleInitAppState();

    public void simpleUpdate(float tpf) {
    }

    private class AppActionListener
    implements ActionListener {
        private AppActionListener() {
        }

        public void onAction(String name, boolean value, float tpf) {
            if (!value) {
                return;
            }
            if (name.equals(SimpleAppState.INPUT_MAPPING_EXIT)) {
                SimpleAppState.this.app.stop();
            } else if (name.equals(SimpleAppState.INPUT_MAPPING_CAMERA_POS)) {
                if (SimpleAppState.this.cam != null) {
                    Vector3f loc = SimpleAppState.this.cam.getLocation();
                    Quaternion rot = SimpleAppState.this.cam.getRotation();
                }
            } else if (name.equals(SimpleAppState.INPUT_MAPPING_MEMORY)) {
                BufferUtils.printCurrentDirectMemory(null);
            }
        }
    }

    public static enum VIEWPORT {
        POST,
        MAIN;

    }
}

