/*
 * Decompiled with CFR 0.152.
 */
package furny.jme.node;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;

public class Arrow
extends Node {
    private final float lineWidth;

    public Arrow(Vector3f start, Vector3f end, float arrowSize, float lineWidth, AssetManager assetManager) {
        super("Grid");
        this.lineWidth = lineWidth;
        Vector3f dir = end.subtract(start).normalize();
        this.addLine("Dir line", start, end);
        this.addLine("Arrow line 1", end.subtract(dir.mult(arrowSize)).add(arrowSize * 0.3f, 0.0f, 0.0f), end);
        this.addLine("Arrow line 2", end.subtract(dir.mult(arrowSize)).add(-arrowSize * 0.3f, 0.0f, 0.0f), end);
        Material lineMaterial = assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        this.setMaterial(lineMaterial);
    }

    private void addLine(String name, Vector3f start, Vector3f end) {
        Line line = new Line(start, end);
        line.setLineWidth(this.lineWidth);
        Geometry lineGeometry = new Geometry(name, (Mesh)line);
        this.attachChild((Spatial)lineGeometry);
    }
}

