/*
 * Decompiled with CFR 0.152.
 */
package furny.jme.node;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;

public class Grid
extends Node {
    private static final float MINOR_TICK_SIZE = 0.05f;
    private static final float MAJOR_TICK_SIZE = 0.1f;
    private final float lineWidth;

    public Grid(Vector3f size, float minorTickStep, float majorTickStep, AssetManager assetManager) {
        this(size, minorTickStep, majorTickStep, 1.0f, assetManager);
    }

    public Grid(Vector3f size, float minorTickStep, float majorTickStep, float lineWidth, AssetManager assetManager) {
        super("Grid");
        this.lineWidth = lineWidth;
        if (size.x > 0.0f) {
            this.addLine("Line x", Vector3f.ZERO, Vector3f.UNIT_X.mult(size.x));
            this.addTicks(Vector3f.ZERO, Vector3f.UNIT_X.mult(size.x), minorTickStep, majorTickStep);
        }
        if (size.y > 0.0f) {
            this.addLine("Line y", Vector3f.ZERO, Vector3f.UNIT_Y.mult(size.y));
            this.addTicks(Vector3f.ZERO, Vector3f.UNIT_Y.mult(size.y), minorTickStep, majorTickStep);
        }
        if (size.z > 0.0f) {
            this.addLine("Line z", Vector3f.ZERO, Vector3f.UNIT_Z.mult(size.z));
            this.addTicks(Vector3f.ZERO, Vector3f.UNIT_Z.mult(size.z), minorTickStep, majorTickStep);
        }
        Material lineMaterial = assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        this.setMaterial(lineMaterial);
    }

    private void addTicks(Vector3f start, Vector3f end, float minorTickStep, float majorTickStep) {
        block3: {
            block5: {
                block4: {
                    if (!(majorTickStep > 0.0f) || !(minorTickStep > 0.0f)) break block3;
                    if (start.x == end.x) break block4;
                    for (float i = start.x; i <= end.x; i += minorTickStep) {
                        float tickSize = i % majorTickStep < 1.0E-7f ? 0.1f : 0.05f;
                        this.addLine("Tick x " + i, new Vector3f(i, 0.0f, -tickSize / 2.0f), new Vector3f(i, 0.0f, tickSize / 2.0f));
                    }
                    break block3;
                }
                if (start.y == end.y) break block5;
                for (float i = start.y; i <= end.y; i += minorTickStep) {
                    float tickSize = i % majorTickStep < 1.0E-7f ? 0.1f : 0.05f;
                    this.addLine("Tick y " + i, new Vector3f(-tickSize / 2.0f, i, tickSize / 2.0f), new Vector3f(tickSize / 2.0f, i, -tickSize / 2.0f));
                }
                break block3;
            }
            if (start.z == end.z) break block3;
            for (float i = start.z; i <= end.z; i += minorTickStep) {
                float tickSize = i % majorTickStep < 1.0E-7f ? 0.1f : 0.05f;
                this.addLine("Tick z " + i, new Vector3f(-tickSize / 2.0f, 0.0f, i), new Vector3f(tickSize / 2.0f, 0.0f, i));
            }
        }
    }

    private void addLine(String name, Vector3f start, Vector3f end) {
        Line line = new Line(start, end);
        line.setLineWidth(this.lineWidth);
        Geometry lineGeometry = new Geometry(name, (Mesh)line);
        this.attachChild((Spatial)lineGeometry);
    }
}

