/*
 * Decompiled with CFR 0.152.
 */
package furny.util;

import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import furny.entities.TextureData;
import furny.furndb.FurnDBManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class IOUtils {
    private static final Logger LOGGER = Logger.getLogger(IOUtils.class.getName());

    private IOUtils() {
    }

    public static byte[] getBytes(Image image) throws IOException {
        BufferedImage bi;
        if (image instanceof BufferedImage) {
            bi = (BufferedImage)image;
        } else {
            bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, null, null);
            g.dispose();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        return baos.toByteArray();
    }

    public static BufferedImage createImage(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return ImageIO.read(bais);
    }

    public static byte[] getBytes(Node node) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryExporter.debug = true;
        BinaryExporter exp = new BinaryExporter();
        exp.save((Savable)node, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Map<Texture, TextureData> getTextureData(Material mat) throws IOException {
        HashMap<Texture, TextureData> map = new HashMap<Texture, TextureData>();
        for (MatParam mp : mat.getParams()) {
            if (!mp.getVarType().equals((Object)VarType.Texture2D)) continue;
            Texture2D tex = (Texture2D)mp.getValue();
            LOGGER.info(tex.toString());
            LOGGER.info(tex.getKey().getName());
            BufferedImage bi = ImageIO.read(IOUtils.class.getResource("/" + tex.getKey().getName()));
            TextureData td = new TextureData();
            td.setBytes(IOUtils.getBytes(bi));
            map.put((Texture)tex, td);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(File f) throws IOException {
        byte[] buf = new byte[(int)f.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            fis.read(buf);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load file", e);
        }
        finally {
            fis.close();
        }
        return buf;
    }

    public static List<Material> getMaterials(Node node) {
        return IOUtils.getMaterials(new ArrayList<Material>(), (Spatial)node);
    }

    private static List<Material> getMaterials(List<Material> list, Spatial node) {
        if (node instanceof Geometry) {
            list.add(((Geometry)node).getMaterial());
        } else if (node instanceof Node) {
            for (Spatial s : ((Node)node).getChildren()) {
                IOUtils.getMaterials(list, s);
            }
        }
        return list;
    }

    public static Node createNode(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BinaryImporter imp = new BinaryImporter();
        imp.setAssetManager(FurnDBManager.getInstance().getAssetManager());
        return (Node)imp.load((InputStream)bais, null, null);
    }
}

