/*
 * Decompiled with CFR 0.152.
 */
package furny.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static void center(Node n) {
        Vector3f oldCenter = n.getWorldBound().getCenter();
        Vector3f trans = n.getLocalTranslation();
        n.setLocalTranslation(trans.subtract(oldCenter).setY(0.0f));
    }

    public static Vector3f getExtents(Node n) {
        return ModelUtil.getHalfExtents(n).mult(2.0f);
    }

    public static Vector3f getHalfExtents(Node n) {
        BoundingVolume bv = n.getWorldBound();
        Vector3f extents = null;
        if (bv instanceof BoundingBox) {
            extents = ((BoundingBox)bv).getExtent(null);
        } else if (bv instanceof BoundingSphere) {
            float r = ((BoundingSphere)bv).getRadius();
            extents = new Vector3f(r, r, r);
        }
        return extents;
    }
}

