/*
 * Decompiled with CFR 0.152.
 */
package furny.ga;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import furny.entities.Furniture;
import furny.ga.RoomVector;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.geom2d.AffineTransform2D;
import math.geom2d.Point2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Rectangle2D;
import org.apache.commons.lang3.ObjectUtils;

public class FurnEntry
implements Comparable<FurnEntry> {
    private static final Logger LOGGER = Logger.getLogger(FurnEntry.class.getName());
    private RoomVector vector;
    private Furniture furniture;
    private Polygon2D bounds;

    public FurnEntry(RoomVector vector, Furniture furniture) {
        this.vector = vector;
        this.setFurniture(furniture);
    }

    public Node createTranslatedModel() {
        Node model = new Node("Furniture Node");
        Node n = this.furniture.getModel().clone(true);
        model.attachChild((Spatial)n);
        model.setLocalTranslation(0.0f, 0.0f, 0.0f);
        model.getLocalRotation().fromAngles(0.0f, this.vector.getRotation(), 0.0f);
        model.setLocalTranslation(this.vector.getX(), 0.0f, this.vector.getY());
        return model;
    }

    public Polygon2D getBounds() {
        return this.bounds;
    }

    private void updateShape() {
        float width = this.furniture.getMetaData().getWidth().floatValue();
        float length = this.furniture.getMetaData().getLength().floatValue();
        Point2D p = new Point2D((double)this.vector.getX() - (double)width / 2.0, (double)this.vector.getY() - (double)length / 2.0);
        this.bounds = new Rectangle2D(p, (double)width, (double)length);
        this.bounds = this.bounds.transform(AffineTransform2D.createRotation((double)this.vector.getX(), (double)this.vector.getY(), (double)this.vector.getRotation()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Bounding of FurnEntry: " + this.bounds.getBoundingBox().toString());
        }
    }

    public RoomVector getVector() {
        return this.vector;
    }

    public void setVector(RoomVector vector) {
        this.vector = vector;
        this.updateShape();
    }

    public Furniture getFurniture() {
        return this.furniture;
    }

    public void setFurniture(Furniture furniture) {
        if (this.furniture != furniture) {
            this.furniture = furniture;
            this.updateShape();
        }
    }

    protected FurnEntry clone() {
        return new FurnEntry(this.vector, this.furniture);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.vector.toString() + "," + this.furniture.toString() + ")";
    }

    @Override
    public int compareTo(FurnEntry o) {
        return this.hashCode() - o.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && obj.hashCode() == this.hashCode() && ((FurnEntry)obj).furniture.equals((Object)this.furniture) && ((FurnEntry)obj).vector.equals(this.vector);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.furniture, this.vector});
    }

    public static void main(String[] args) {
        Node n = new Node();
        n.attachChild((Spatial)new Geometry("", (Mesh)new Box(2.0f, 2.0f, 3.0f)));
        Furniture f = new Furniture("", n);
        FurnEntry fe = new FurnEntry(new RoomVector(100, 200, 0), f);
        FurnEntry fe2 = new FurnEntry(new RoomVector(100, 200, 100), f);
        System.out.println(fe.getBounds().getBoundingBox().getAsAWTRectangle2D().intersects(fe2.getBounds().getBoundingBox().getAsAWTRectangle2D()));
    }
}

