/*
 * Decompiled with CFR 0.152.
 */
package furny.ga;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.RoomVector;
import furny.ga.util.Distance;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.algorithm.util.ClusterUtil;
import ga.core.algorithm.util.RandomSingleton;
import ga.core.individual.IClusterableIndividual;
import ga.core.individual.ICostInfo;
import ga.core.individual.IDebugInfo;
import ga.core.individual.IIntervalFitness;
import ga.core.validation.GAContext;
import ga.view.interfaces.IPhenotypeSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public final class FurnLayoutIndividual
implements IClusterableIndividual<FurnLayoutIndividual>,
IIntervalFitness,
IDebugInfo,
ICostInfo {
    private static Random rnd = RandomSingleton.getRandom();
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final long id;
    private final FurnEntryList furnitures = new FurnEntryList();
    private double fitnessCenter = Double.MIN_VALUE;
    private double fitnessMin;
    private double fitnessMax;
    private GAContext context;

    public FurnLayoutIndividual(GAContext context) {
        this();
        this.setContext(context);
    }

    public FurnLayoutIndividual() {
        this.id = ID_GENERATOR.incrementAndGet();
    }

    public void setContext(GAContext context) {
        this.context = context;
    }

    public GAContext getContext() {
        return this.context;
    }

    public long getId() {
        return this.id;
    }

    public void setFitness(double fitness) {
        this.setFitnessInterval(fitness, 0.0);
    }

    public double getFitness() {
        return this.fitnessCenter;
    }

    public double getMaxFitness() {
        return this.fitnessMax;
    }

    public double getMinFitness() {
        return this.fitnessMin;
    }

    public double getFitnessWidth() {
        return this.fitnessMax - this.fitnessMin;
    }

    public void setFitnessInterval(double center, double width) {
        this.fitnessCenter = center;
        this.fitnessMin = center - width / 2.0;
        this.fitnessMax = this.fitnessMin + width;
    }

    public void setFitnessLimits(double min, double max) {
        this.fitnessMin = min;
        this.fitnessMax = max;
        this.fitnessCenter = (max + min) / 2.0;
    }

    public void initRandomly() {
        Object o;
        this.fitnessCenter = Double.MIN_VALUE;
        this.fitnessMin = 0.0;
        this.fitnessMax = 0.0;
        this.furnitures.clear();
        float minX = -10.0f;
        float maxX = 10.0f;
        float minY = -10.0f;
        float maxY = 10.0f;
        IPhenotypeSpace space = null;
        if (this.context != null && (o = this.context.get((Object)"ValidationSpace")) != null && o instanceof IPhenotypeSpace) {
            space = (IPhenotypeSpace)o;
            minX = (float)space.getOutterBounds().getX();
            maxX = (float)(space.getOutterBounds().getX() + space.getOutterBounds().getWidth());
            minY = (float)space.getOutterBounds().getY();
            maxY = (float)(space.getOutterBounds().getY() + space.getOutterBounds().getHeight());
        }
        int genomeMinLength = 1;
        int genomeMaxLength = 6;
        if (this.context != null) {
            if (this.context.containsKey((Object)"GenomeMinLength")) {
                genomeMinLength = (Integer)this.context.get((Object)"GenomeMinLength");
            }
            if (this.context.containsKey((Object)"GenomeMaxLength")) {
                genomeMaxLength = (Integer)this.context.get((Object)"GenomeMaxLength");
            }
        }
        int genomeLength = rnd.nextInt(1 + genomeMaxLength - genomeMinLength) + genomeMinLength;
        List all = FurnCache.getInstance().getAllFurnitures();
        for (int i = 0; i < genomeLength; ++i) {
            int x = Math.round((rnd.nextFloat() * (maxX - minX) + minX) * 100.0f);
            int y = Math.round((rnd.nextFloat() * (maxY - minY) + minY) * 100.0f);
            int rotationSteps = rnd.nextInt(4);
            Furniture f = (Furniture)all.get(rnd.nextInt(all.size()));
            this.furnitures.add(new FurnEntry(new RoomVector(x, y, rotationSteps), f));
        }
    }

    public FurnEntryList getFurnitures() {
        return this.furnitures;
    }

    public long[][] getSimpleGenotype() {
        long[][] store = new long[this.furnitures.size()][4];
        for (int i = 0; i < this.furnitures.size(); ++i) {
            FurnEntry entry = (FurnEntry)this.furnitures.get(i);
            store[i][0] = entry.getFurniture().getId();
            store[i][1] = entry.getVector().getXGene();
            store[i][2] = entry.getVector().getYGene();
            store[i][3] = entry.getVector().getRotationSteps();
        }
        return store;
    }

    public boolean isEvaluated() {
        return this.fitnessCenter != Double.MIN_VALUE;
    }

    public FurnLayoutIndividual clone() {
        FurnLayoutIndividual newInd = new FurnLayoutIndividual(this.context);
        for (FurnEntry entry : this.furnitures) {
            newInd.furnitures.add(entry.clone());
        }
        return newInd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        FurnLayoutIOUtil.writeSimpleGenotype(this.getSimpleGenotype(), sb);
        FurnLayoutIOUtil.writeFitness(this, sb);
        return sb.toString();
    }

    public String getDebugString() {
        String fitnessString = this.isEvaluated() ? (this.fitnessMin != this.fitnessMax ? String.format(Locale.ENGLISH, "[%.2f;%.2f]", this.fitnessMin, this.fitnessMax) : String.format(Locale.ENGLISH, "%.2f", this.fitnessCenter)) : "N/A";
        return this.id + " " + this.getGenotypeString() + " Fitness: " + fitnessString;
    }

    public String getIdString() {
        return String.valueOf(this.id);
    }

    public double getCosts() {
        double costs = 0.0;
        for (FurnEntry fe : this.furnitures) {
            costs += fe.getFurniture().getMetaData().getPrice().doubleValue();
        }
        return costs;
    }

    public String getCostString() {
        return String.format(Locale.ENGLISH, "%.2f Euro", this.getCosts());
    }

    public String getGenotypeString() {
        StringBuilder sb = new StringBuilder();
        FurnLayoutIOUtil.writeSimpleGenotypeSet(this.getSimpleGenotype(), sb);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FurnLayoutIndividual that = (FurnLayoutIndividual)obj;
        return this.furnitures.containsAll(that.furnitures) && that.furnitures.containsAll(this.furnitures);
    }

    public int hashCode() {
        Collections.sort(this.furnitures);
        return this.furnitures.hashCode();
    }

    public FurnLayoutIndividual centroidOf(Collection<FurnLayoutIndividual> c) {
        return (FurnLayoutIndividual)ClusterUtil.calculateCentroid(c);
    }

    public double distanceFrom(FurnLayoutIndividual ind2) {
        return Distance.calcDistance2(this, ind2, this.context);
    }
}

