/*
 * Decompiled with CFR 0.152.
 */
package furny.ga;

import ga.view.interfaces.IPhenotypeSpace;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Rectangle2D;

public class PseudoSpace
implements IPhenotypeSpace {
    private final Rectangle2D bounds;

    public PseudoSpace(float roomWidth, float roomLength) {
        float roomWidthHalf = roomWidth / 2.0f;
        float roomLengthHalf = roomLength / 2.0f;
        this.bounds = new Rectangle2D((double)(-roomWidthHalf), (double)(-roomLengthHalf), (double)roomWidth, (double)roomLength);
    }

    public boolean contains(Polygon2D shape) {
        return this.getOutterBounds().getBoundingBox().containsBounds((Shape2D)shape);
    }

    public Rectangle2D getOutterBounds() {
        return this.bounds;
    }

    public float minDistanceToWall(Polygon2D shape, float angle) {
        float minDistance = Float.MAX_VALUE;
        for (LineSegment2D edge : this.bounds.getEdges()) {
            for (Point2D vert : shape.getVertices()) {
                boolean sameDir = false;
                if (Math.abs(angle) < 1.0E-4f) {
                    if (edge.getFirstPoint().getY() < vert.getY() && edge.getLastPoint().getY() < vert.getY()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - 1.5707964f) < 1.0E-4f) {
                    if (edge.getFirstPoint().getX() < vert.getX() && edge.getLastPoint().getX() < vert.getX()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - (float)Math.PI) < 1.0E-4f) {
                    if (edge.getFirstPoint().getY() > vert.getY() && edge.getLastPoint().getY() > vert.getY()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - 4.712389f) < 1.0E-4f && edge.getFirstPoint().getX() > vert.getX() && edge.getLastPoint().getX() > vert.getX()) {
                    sameDir = true;
                }
                if (!sameDir) continue;
                minDistance = Math.min(minDistance, (float)edge.getDistance(vert));
            }
        }
        return minDistance;
    }
}

