/*
 * Decompiled with CFR 0.152.
 */
package furny.ga;

import com.jme3.math.FastMath;
import org.apache.commons.lang3.ObjectUtils;

public final class RoomVector {
    private static final float ROTATION_DEGREES = 90.0f;
    private static final int MAX_ROTATION = 4;
    private final int xGene;
    private final int yGene;
    private final int rotGene;

    public RoomVector(int xGene, int yGene, int rotationSteps) {
        this.xGene = xGene;
        this.yGene = yGene;
        this.rotGene = rotationSteps % 4;
    }

    public int getXGene() {
        return this.xGene;
    }

    public int getYGene() {
        return this.yGene;
    }

    public float getX() {
        return (float)this.xGene / 100.0f;
    }

    public float getY() {
        return (float)this.yGene / 100.0f;
    }

    public float getRotation() {
        return 1.5707964f * (float)this.rotGene;
    }

    public int getRotationSteps() {
        return this.rotGene;
    }

    public RoomVector getTranslatedInstance(int x, int y) {
        return new RoomVector(this.xGene + x, this.yGene + y, this.rotGene);
    }

    public RoomVector getRotatedInstance(int rotationSteps) {
        return new RoomVector(this.xGene, this.yGene, (this.rotGene + rotationSteps) % 4);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((RoomVector)obj).xGene == this.xGene && ((RoomVector)obj).yGene == this.yGene && ((RoomVector)obj).rotGene == this.rotGene;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.xGene, this.yGene, this.rotGene});
    }

    protected RoomVector clone() {
        return new RoomVector(this.xGene, this.yGene, this.rotGene);
    }

    public float distance(RoomVector vec) {
        return FastMath.sqrt((float)(FastMath.pow((float)(this.getX() - vec.getX()), (float)2.0f) + FastMath.pow((float)(this.getY() - vec.getY()), (float)2.0f)));
    }

    public float diffAngleDeg(RoomVector vec) {
        float diffangle = 57.295776f * this.getRotation() - 57.295776f * vec.getRotation() + 180.0f;
        diffangle /= 360.0f;
        diffangle = (diffangle - FastMath.floor((float)diffangle)) * 360.0f - 180.0f;
        return diffangle;
    }

    public int diffRotation(RoomVector vec) {
        float diffRot = ((float)(this.rotGene - vec.rotGene) + 2.0f) / 4.0f;
        diffRot = (diffRot - FastMath.floor((float)diffRot)) * 4.0f - 2.0f;
        return Math.round(diffRot);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.xGene + "," + this.yGene + "," + this.getRotation() + ")";
    }
}

