/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger;

import furny.ga.logger.StatisticsCache;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.GeneEntry;
import furny.ga.logger.entities.IndividualEntry;
import furny.ga.tuples.Couple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataCache {
    private static final DataCache INSTANCE = new DataCache();
    private final Map<Couple<?, ?>, Map<Double, Double>> doubleDoubleCache = new HashMap();
    private final Map<Couple<?, ?>, Map<Double, Long>> doubleLongCache = new HashMap();
    private final Map<Couple<?, ?>, Map<Long, Long>> longLongCache = new HashMap();
    private final Map<Couple<?, ?>, Map<Long, Double>> longDoubleCache = new HashMap();

    private DataCache() {
    }

    public static DataCache getInstance() {
        return INSTANCE;
    }

    public Map<Double, Double> getMeanFitnessTime(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.MEAN_FITNESS_OVER_TIME);
        Map<Double, Double> result = this.doubleDoubleCache.get(key);
        if (result == null) {
            result = new HashMap<Double, Double>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            HashMap<Double, Integer> generationIndCount = new HashMap<Double, Integer>();
            HashMap<Double, Double> generationFitness = new HashMap<Double, Double>();
            for (IndividualEntry individualEntry : list) {
                Double time = (double)(individualEntry.getEvent().getDate().getTime() - individualEntry.getEvent().getEvaluationRun().getStarted().getTime()) / 1000.0;
                Integer count = (Integer)generationIndCount.get(time);
                if (count != null) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                } else {
                    count = 1;
                }
                generationIndCount.put(time, count);
                Double fitness = (Double)generationFitness.get(time);
                Double newFitness = individualEntry.getFitness() != null ? individualEntry.getFitness() : null;
                if (newFitness == null) continue;
                fitness = fitness != null ? Double.valueOf(fitness + newFitness) : newFitness;
                generationFitness.put(time, newFitness);
            }
            for (Map.Entry entry : generationIndCount.entrySet()) {
                Double fitness = null;
                if (generationFitness.get(entry.getKey()) != null) {
                    fitness = (Double)generationFitness.get(entry.getKey()) / (double)((Integer)entry.getValue()).intValue();
                }
                result.put((Double)entry.getKey(), fitness);
            }
            this.doubleDoubleCache.put(key, result);
        }
        return result;
    }

    public Map<Long, Double> getMeanFitnessGenerations(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.MEAN_FITNESS_OVER_GENERATIONS);
        Map<Long, Double> result = this.longDoubleCache.get(key);
        if (result == null) {
            result = new HashMap<Long, Double>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            HashMap<Long, Integer> generationIndCount = new HashMap<Long, Integer>();
            HashMap<Long, Double> generationFitness = new HashMap<Long, Double>();
            for (IndividualEntry individualEntry : list) {
                Long generation = individualEntry.getGeneration();
                Integer count = (Integer)generationIndCount.get(generation);
                if (count != null) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                } else {
                    count = 1;
                }
                generationIndCount.put(generation, count);
                Double fitness = (Double)generationFitness.get(generation);
                Double newFitness = individualEntry.getFitness();
                if (newFitness == null) continue;
                fitness = fitness != null ? Double.valueOf(fitness + newFitness) : newFitness;
                generationFitness.put(generation, newFitness);
            }
            for (Map.Entry entry : generationIndCount.entrySet()) {
                Double fitness = generationFitness.get(entry.getKey()) != null ? Double.valueOf((Double)generationFitness.get(entry.getKey()) / ((Integer)entry.getValue()).doubleValue()) : null;
                result.put((Long)entry.getKey(), fitness);
            }
            this.longDoubleCache.put(key, result);
        }
        return result;
    }

    public Map<Double, Double> getMaxFitnessTime(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.MAX_FITNESS_OVER_TIME);
        Map<Double, Double> result = this.doubleDoubleCache.get(key);
        if (result == null) {
            result = new HashMap<Double, Double>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            for (IndividualEntry entry : list) {
                Double time = (double)(entry.getEvent().getDate().getTime() - entry.getEvent().getEvaluationRun().getStarted().getTime()) / 1000.0;
                Double fitness = result.get(time);
                Double newFitness = entry.getFitness() != null ? entry.getFitness() : null;
                if (newFitness == null) continue;
                if (fitness != null) {
                    if (newFitness > fitness) {
                        fitness = newFitness;
                    }
                } else {
                    fitness = newFitness;
                }
                result.put(time, fitness);
            }
            this.doubleDoubleCache.put(key, result);
        }
        return result;
    }

    public Map<Long, Double> getMaxFitnessOverGenerations(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.MAX_FITNESS_OVER_GENERATIONS);
        Map<Long, Double> result = this.longDoubleCache.get(key);
        if (result == null) {
            result = new HashMap<Long, Double>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            for (IndividualEntry entry : list) {
                Long generation = entry.getGeneration();
                Double fitness = result.get(generation);
                Double newFitness = entry.getFitness() != null ? entry.getFitness() : null;
                if (newFitness == null) continue;
                if (fitness != null) {
                    if (newFitness > fitness) {
                        fitness = newFitness;
                    }
                } else {
                    fitness = newFitness;
                }
                result.put(generation, fitness);
            }
            this.longDoubleCache.put(key, result);
        }
        return result;
    }

    public Map<Long, Double> getMinFitnessOverGenerations(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.MIN_FITNESS_OVER_GENERATIONS);
        Map<Long, Double> result = this.longDoubleCache.get(key);
        if (result == null) {
            result = new HashMap<Long, Double>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            for (IndividualEntry entry : list) {
                Long generation = entry.getGeneration();
                Double fitness = result.get(generation);
                Double newFitness = entry.getFitness() != null ? entry.getFitness() : null;
                if (newFitness == null) continue;
                if (fitness != null) {
                    if (newFitness < fitness) {
                        fitness = newFitness;
                    }
                } else {
                    fitness = newFitness;
                }
                result.put(generation, fitness);
            }
            this.longDoubleCache.put(key, result);
        }
        return result;
    }

    public Map<Long, Long> getFurnitureCount(Long runId) {
        Couple<Long, DataId> key = new Couple<Long, DataId>(runId, DataId.FURNID_COUNT);
        Map<Long, Long> result = this.longLongCache.get(key);
        if (result == null) {
            result = new HashMap<Long, Long>();
            List<IndividualEntry> list = StatisticsCache.getInstance().getIndiduals(runId, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED);
            for (IndividualEntry entry : list) {
                for (GeneEntry gene : entry.getGenes()) {
                    Long furnId = gene.getFurnId();
                    Long count = result.get(furnId);
                    if (count != null) {
                        Long l = count;
                        Long l2 = count = Long.valueOf(count + 1L);
                    } else {
                        count = 1L;
                    }
                    result.put(furnId, count);
                }
            }
            this.longLongCache.put(key, result);
        }
        return result;
    }

    private static enum DataId {
        MEAN_FITNESS_OVER_TIME,
        MEAN_FITNESS_OVER_GENERATIONS,
        MIN_FITNESS_OVER_TIME,
        MAX_FITNESS_OVER_TIME,
        MIN_FITNESS_OVER_GENERATIONS,
        MAX_FITNESS_OVER_GENERATIONS,
        FURNID_COUNT;

    }
}

