/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger;

import furny.ga.FurnLayoutIndividual;
import ga.core.algorithm.util.PopulationUtil;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.logging.IGALogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GACSVLogger
implements IGALogger<FurnLayoutIndividual> {
    private static final String DEFAULT_FILE = "fitness.csv";
    private final List<double[]> data = new ArrayList<double[]>();
    private final String csvFileName;

    public GACSVLogger() {
        this.csvFileName = DEFAULT_FILE;
    }

    public GACSVLogger(String csvFileName) {
        this.csvFileName = csvFileName;
    }

    public void evaluationStarted() {
        System.out.println("Evaluation started on " + new Date());
    }

    public void populationInitiated(int generation, IPopulation<FurnLayoutIndividual> population) {
    }

    public void individualsSelected(int generation, IndividualList<FurnLayoutIndividual> list) {
    }

    public void individualsCrossed(int generation, IndividualList<FurnLayoutIndividual> list) {
    }

    public void individualsMutated(int generation, IndividualList<FurnLayoutIndividual> list) {
    }

    public void individualsInserted(int generation, IndividualList<FurnLayoutIndividual> list, IPopulation<FurnLayoutIndividual> population) {
    }

    public void allIndividualsEvaluated(int generation, IPopulation<FurnLayoutIndividual> population) {
        this.data.add(PopulationUtil.getMinMeanMaxFitness(population));
        System.out.println("Writing CSV file");
        GACSVLogger.writeCSV((double[][])this.data.toArray((T[])new double[this.data.size()][]), this.csvFileName);
    }

    public void individualSelectedForEvaluation(int generation, FurnLayoutIndividual individual) {
    }

    public void individualEvaluated(int generation, FurnLayoutIndividual individual) {
    }

    public void exit() {
        System.out.println("Writing CSV file");
        GACSVLogger.writeCSV((double[][])this.data.toArray((T[])new double[this.data.size()][]), this.csvFileName);
        System.out.println("Logger closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCSV(double[][] data, String filename) {
        File csvFile = new File(filename);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(csvFile)));
            bw.write("i;fit_min;fit_mean;fit_max\n");
            for (int i = 0; i < data.length; ++i) {
                try {
                    bw.write(String.format("%d;%,.2f;%,.2f;%,.2f;\n", i, data[i][0], data[i][1], data[i][2]));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception e) {}
        }
    }
}

